/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmpowerPlatformRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmpowerPlatformQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemExtExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemChannelReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemEmpowerImportReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemPlatformReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemChannelRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemChannelService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IRItemBundleService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemChannelDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemChannelEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdShelfEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemChannelServiceImpl
implements IItemChannelService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ItemChannelDas itemChannelDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemExtShelfDas itemExtShelfDas;
    @Resource(name="${project.domain.prefix:tcbj}RItemBundleService")
    private IRItemBundleService itemBundleService;
    @Resource
    private IEmpowerPlatformQueryApi empowerPlatformQueryApi;
    @Resource
    private ItemDas itemDas;

    @Override
    public Long addItemChannel(ItemChannelReqDto addReqDto) {
        ItemChannelEo itemChannelEo = new ItemChannelEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemChannelEo);
        this.itemChannelDas.insert((BaseEo)itemChannelEo);
        return itemChannelEo.getId();
    }

    @Override
    public void modifyItemChannel(ItemChannelReqDto modifyReqDto) {
        ItemChannelEo itemChannelEo = new ItemChannelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemChannelEo);
        this.itemChannelDas.updateSelective((BaseEo)itemChannelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemChannel(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemChannelDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemChannelRespDto queryById(Long id) {
        ItemChannelEo itemChannelEo = (ItemChannelEo)this.itemChannelDas.selectByPrimaryKey(id);
        ItemChannelRespDto itemChannelRespDto = new ItemChannelRespDto();
        DtoHelper.eo2Dto((BaseEo)itemChannelEo, (BaseVo)itemChannelRespDto);
        return itemChannelRespDto;
    }

    @Override
    public PageInfo<ItemChannelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemChannelReqDto itemChannelReqDto = (ItemChannelReqDto)JSON.parseObject((String)filter, ItemChannelReqDto.class);
        ItemChannelEo itemChannelEo = new ItemChannelEo();
        DtoHelper.dto2Eo((BaseVo)itemChannelReqDto, (BaseEo)itemChannelEo);
        PageInfo eoPageInfo = this.itemChannelDas.selectPage((BaseEo)itemChannelEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemChannelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ItemChannelRespDto> getChannelPlatform(ItemChannelReqDto reqDto) {
        ArrayList<ItemChannelRespDto> respDtoList = new ArrayList<ItemChannelRespDto>();
        ItemChannelEo eo = new ItemChannelEo();
        eo.setItemCode(reqDto.getItemCode());
        List channelEoList = this.itemChannelDas.select((BaseEo)eo);
        DtoHelper.eoList2DtoList((Collection)channelEoList, respDtoList, ItemChannelRespDto.class);
        return respDtoList;
    }

    @Override
    public List<ItemChannelRespDto> queryByPlatformId(Long platformId) {
        ArrayList<ItemChannelRespDto> respDtoList = new ArrayList<ItemChannelRespDto>();
        ItemChannelEo eo = new ItemChannelEo();
        eo.setPlatformId(platformId);
        List channelEoList = this.itemChannelDas.select((BaseEo)eo);
        DtoHelper.eoList2DtoList((Collection)channelEoList, respDtoList, ItemChannelRespDto.class);
        return respDtoList;
    }

    @Override
    public List<ItemChannelRespDto> queryListByItemIds(List<Long> itemIds) {
        ExtQueryChainWrapper sqlFilterList = this.itemChannelDas.filter();
        sqlFilterList.in((Object)"item_id", itemIds);
        List select = sqlFilterList.list();
        ArrayList<ItemChannelRespDto> itemChannelRespDtoList = new ArrayList<ItemChannelRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, itemChannelRespDtoList, ItemChannelRespDto.class);
        return itemChannelRespDtoList;
    }

    @Override
    public List<ItemChannelRespDto> queryListByItemIdsPost(List<Long> itemIds) {
        return this.queryListByItemIds(itemIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addItemPlatform(ItemPlatformReqDto platformReqDto) {
        ItemChannelEo itemChannelEo = new ItemChannelEo();
        itemChannelEo.setShelfId(platformReqDto.getId());
        itemChannelEo.setItemId(platformReqDto.getItemId());
        List eoList = this.itemChannelDas.select((BaseEo)itemChannelEo);
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            this.itemChannelDas.delete((BaseEo)itemChannelEo);
        }
        platformReqDto.setShelfId(platformReqDto.getId());
        List channelReqDtoList = platformReqDto.getChannelReqDtoList();
        if (CollectionUtils.isNotEmpty((Collection)channelReqDtoList)) {
            ArrayList channelEoList = Lists.newArrayList();
            List skuEoList = this.itemSkuDas.selectByItemId(platformReqDto.getItemId());
            CubeBeanUtils.copyCollection((Collection)channelEoList, (Collection)channelReqDtoList, ItemChannelEo.class);
            channelEoList.forEach(v -> {
                v.setShelfId(platformReqDto.getShelfId());
                v.setSkuId(CollectionUtils.isNotEmpty((Collection)skuEoList) ? ((ItemSkuEo)skuEoList.get(0)).getId() : null);
            });
            if (CollectionUtils.isNotEmpty((Collection)channelEoList)) {
                this.itemChannelDas.insertBatch((List)channelEoList);
            }
        }
    }

    @Override
    public List<ItemChannelRespDto> queryByItemId(Long itemId) {
        ItemChannelEo itemChannelEo = new ItemChannelEo();
        itemChannelEo.setItemId(itemId);
        List channelEoList = this.itemChannelDas.select((BaseEo)itemChannelEo);
        ArrayList channelRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)channelEoList, (Collection)channelRespDtos, ItemChannelRespDto.class);
        return channelRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String empowerImport(ImportDto importDto) {
        ArrayList itemChannelEoList = new ArrayList();
        String url = importDto.getUrl();
        List<ItemEmpowerImportReqDto> empowerList = null;
        try {
            empowerList = EasyPoiExportUtil.parseImportFile(url, ItemEmpowerImportReqDto.class);
        }
        catch (Exception e2) {
            throw new BizException(ItemExtExceptionCode.ITEM_PLATFORM_IMPORT_PARSING_ERROR.getCode(), ItemExtExceptionCode.ITEM_PLATFORM_IMPORT_PARSING_ERROR.getMsg(), (Throwable)e2);
        }
        List<String> itemCodes = empowerList.stream().map(ItemEmpowerImportReqDto::getItemCode).distinct().collect(Collectors.toList());
        List platformCodes = empowerList.stream().map(ItemEmpowerImportReqDto::getPlatformCode).distinct().collect(Collectors.toList());
        this.itemBundleService.batchShelfItemByCode(itemCodes);
        List skuList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"code", itemCodes)).list();
        List skuIds = skuList.stream().map(BaseEo::getId).collect(Collectors.toList());
        List shelfList = ((ExtQueryChainWrapper)this.itemExtShelfDas.filter().in((Object)"sku_id", skuIds)).list();
        RestResponse listRestResponse = this.empowerPlatformQueryApi.queryByCodes(platformCodes);
        List empowerPlatformRespDtoList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map<String, ItemSkuEo> skuMap = skuList.stream().collect(Collectors.toMap(StdItemSkuEo::getCode, o -> o));
        Map<Long, List<ShelfEo>> shelfSkuMap = shelfList.stream().collect(Collectors.groupingBy(StdShelfEo::getSkuId));
        Map<String, EmpowerPlatformRespDto> platformMap = empowerPlatformRespDtoList.stream().collect(Collectors.toMap(EmpowerPlatformRespDto::getCode, o -> o));
        empowerList.forEach(e -> {
            ItemSkuEo itemSkuEo = (ItemSkuEo)skuMap.get(e.getItemCode());
            Long skuId = itemSkuEo.getId();
            List shelfEos = (List)shelfSkuMap.get(skuId);
            shelfEos.forEach(s -> {
                ItemChannelEo itemChannelEo = new ItemChannelEo();
                itemChannelEo.setItemId(itemSkuEo.getItemId());
                itemChannelEo.setItemCode(itemSkuEo.getCode());
                itemChannelEo.setSkuId(skuId);
                itemChannelEo.setShelfId(s.getId());
                itemChannelEo.setPlatformId(((EmpowerPlatformRespDto)platformMap.get(e.getPlatformCode())).getId());
                itemChannelEo.setPlatformName(((EmpowerPlatformRespDto)platformMap.get(e.getPlatformCode())).getName());
                itemChannelEoList.add(itemChannelEo);
            });
        });
        if (CollectionUtils.isNotEmpty(itemChannelEoList)) {
            this.itemChannelDas.insertBatch(itemChannelEoList);
        }
        return "\u5546\u54c1\u5141\u9500\u5e73\u53f0\u5173\u7cfb\u5bfc\u5165\u6210\u529f\uff01";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddItemPlatform(Long itemId, Long skuId, List<Long> shelfIds) {
        ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)itemId)).one();
        List empowerPlatformRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.empowerPlatformQueryApi.queryPlatform());
        ItemChannelEo channelEo = new ItemChannelEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.eq((String)"item_id", (Object)itemEo.getId()));
        sqlFilterList.add(SqlFilter.in((String)"shelf_id", shelfIds));
        channelEo.setSqlFilters(sqlFilterList);
        this.itemChannelDas.delete((BaseEo)channelEo);
        shelfIds.forEach(v -> {
            ArrayList itemChannelEos = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)empowerPlatformRespDtos)) {
                empowerPlatformRespDtos.forEach(i -> {
                    ItemChannelEo itemChannelEo = new ItemChannelEo();
                    itemChannelEo.setItemId(itemId);
                    itemChannelEo.setSkuId(skuId);
                    itemChannelEo.setShelfId(v);
                    itemChannelEo.setPlatformId(i.getId());
                    itemChannelEo.setPlatformName(i.getName());
                    itemChannelEo.setItemCode(itemEo.getCode());
                    itemChannelEos.add(itemChannelEo);
                });
                this.itemChannelDas.insertBatch((List)itemChannelEos);
            }
        });
    }
}

