/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.b2b.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DealerAddItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IShopItemService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.ItemAuthService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShopItemServiceImpl
implements IShopItemService {
    private static final Logger log = LoggerFactory.getLogger(ShopItemServiceImpl.class);
    @Resource
    private ItemAuthService itemAuthService;
    @Resource
    private IItemService itemService;
    @Resource
    private IItemSkuService itemSkuService;
    @Resource
    private IItemShelfService itemShelfService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItem(DealerAddItemReqDto dealerAddItemReqDto) {
        log.info("\u7ecf\u9500\u5546\u65b0\u589e\u5546\u54c1\u4fe1\u606f=>{}}", (Object)JSON.toJSONString((Object)dealerAddItemReqDto));
        Long itemId = this.itemService.addItem((ItemChangeApplyDto)dealerAddItemReqDto);
        ItemEo itemEo = this.itemService.queryById(itemId);
        List<ItemSkuRespDto> list = this.itemSkuService.queryByItemIdList(Lists.newArrayList((Object[])new Long[]{itemId}));
        List<ItemShelfReqDto> onShelfDtoList = this.buildItemShelfReqDto(itemEo, dealerAddItemReqDto, list);
        List<ItemAuthReqDto> itemAuthReqDtoList = this.buildItemAuthInfo(dealerAddItemReqDto, list);
        log.info("\u6388\u6743\u4fe1\u606fitemAuthReqDtoList->>>>>>>>>>>{}", (Object)JSON.toJSONString(itemAuthReqDtoList));
        this.itemAuthService.batchNewAddItemAuth(itemAuthReqDtoList);
        log.info("listTobReqDto->>>>>>>>>>>{}", (Object)JSON.toJSONString(onShelfDtoList));
        this.itemShelfService.onShelfOperation(onShelfDtoList, true, null);
        return itemId;
    }

    private List<ItemAuthReqDto> buildItemAuthInfo(DealerAddItemReqDto dealerAddItemReqDto, List<ItemSkuRespDto> list) {
        if (Objects.isNull(dealerAddItemReqDto.getShopId())) {
            log.info("\u5e97\u94faid\u4e3a\u7a7a\uff0c\u4e0d\u63d2\u5165\u6388\u6743\u4fe1\u606f");
            return null;
        }
        ArrayList itemAuthReqDtoList = Lists.newArrayList();
        list.forEach(n -> {
            ItemAuthPageReqDto itemAuthReqDto = new ItemAuthPageReqDto();
            itemAuthReqDto.setStatus(Integer.valueOf(1));
            itemAuthReqDto.setBusinessId(n.getId());
            itemAuthReqDto.setBusinessType("SKU");
            itemAuthReqDto.setTargetType(Integer.valueOf(2));
            itemAuthReqDto.setTargetId(dealerAddItemReqDto.getShopId());
            itemAuthReqDtoList.add(itemAuthReqDto);
        });
        return itemAuthReqDtoList;
    }

    private List<ItemShelfReqDto> buildItemShelfReqDto(ItemEo itemEo, DealerAddItemReqDto dealerReqDto, List<ItemSkuRespDto> list) {
        ArrayList<ItemShelfReqDto> dtoList = new ArrayList<ItemShelfReqDto>();
        for (ItemSkuRespDto itemSkuRespDto : list) {
            ItemShelfReqDto itemTobReqDto = new ItemShelfReqDto();
            itemTobReqDto.setItemId(itemEo.getId());
            itemTobReqDto.setItemType(itemEo.getType());
            itemTobReqDto.setBusType(itemEo.getBusType());
            itemTobReqDto.setSkuId(itemSkuRespDto.getId());
            itemTobReqDto.setShopId(itemEo.getShopId());
            itemTobReqDto.setDirId(itemEo.getDirId());
            itemTobReqDto.setLimitMin(dealerReqDto.getLimitMin());
            itemTobReqDto.setHomePageDisplay(dealerReqDto.getHomePageDisplay());
            itemTobReqDto.setStockDisplay(dealerReqDto.getStockDisplay());
            itemTobReqDto.setMultipleStatus(dealerReqDto.getMultipleStatus());
            itemTobReqDto.setLimitMinMode(dealerReqDto.getLimitMinMode());
            itemTobReqDto.setOrganizationId(dealerReqDto.getOrganizationId());
            itemTobReqDto.setOrganizationName(dealerReqDto.getOrganizationName());
            itemTobReqDto.setSellerId(dealerReqDto.getSellerId());
            itemTobReqDto.setStorage(Long.valueOf(0L));
            dtoList.add(itemTobReqDto);
        }
        return dtoList;
    }
}

