/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.lcd.api.constants;

import java.util.HashMap;
import java.util.Map;

public enum ContainerType {
    ABILITY_CENTER(1, "center"),
    FRONTEND_APP(2, "frontend"),
    BACKEND_APP(3, "backend");

    private String typeStr;
    private Integer type;
    private static Map<Integer, ContainerType> typeMap;
    private static Map<String, ContainerType> typeStrMap;

    public static ContainerType fromType(Integer type) {
        ContainerType value = typeMap.get(type);
        if (value != null) {
            return value;
        }
        return null;
    }

    public static ContainerType fromTypeStr(String typeStr) {
        ContainerType value = typeStrMap.get(typeStr);
        if (value != null) {
            return value;
        }
        return null;
    }

    private ContainerType(Integer type, String typeStr) {
        this.typeStr = typeStr;
        this.type = type;
    }

    public String getTypeStr() {
        return this.typeStr;
    }

    public void setTypeStr(String typeStr) {
        this.typeStr = typeStr;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    static {
        typeMap = new HashMap<Integer, ContainerType>();
        typeStrMap = new HashMap<String, ContainerType>();
        for (ContainerType value : ContainerType.values()) {
            typeMap.put(value.type, value);
            typeStrMap.put(value.typeStr, value);
        }
    }
}

