/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.price.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountLogReqDto;
import com.yx.tcbj.center.price.api.dto.response.PrBaseDiscountLogRespDto;
import com.yx.tcbj.center.price.api.exception.PriceCenterExceptionCode;
import com.yx.tcbj.center.price.biz.service.IPrBaseDiscountLogService;
import com.yx.tcbj.center.price.dao.das.PrBaseDiscountLogDas;
import com.yx.tcbj.center.price.dao.eo.PrBaseDiscountLogEo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrBaseDiscountLogServiceImpl
implements IPrBaseDiscountLogService {
    private Logger logger = LoggerFactory.getLogger(PrBaseDiscountLogServiceImpl.class);
    @Resource
    private PrBaseDiscountLogDas prBaseDiscountLogDas;

    @Override
    public Long addPrBaseDiscountLog(PrBaseDiscountLogReqDto addReqDto) {
        PrBaseDiscountLogEo prBaseDiscountLogEo = new PrBaseDiscountLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)prBaseDiscountLogEo);
        this.prBaseDiscountLogDas.insert((BaseEo)prBaseDiscountLogEo);
        return prBaseDiscountLogEo.getId();
    }

    @Override
    public void modifyPrBaseDiscountLog(PrBaseDiscountLogReqDto modifyReqDto) {
        PrBaseDiscountLogEo prBaseDiscountLogEo = new PrBaseDiscountLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)prBaseDiscountLogEo);
        this.prBaseDiscountLogDas.updateSelective((BaseEo)prBaseDiscountLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePrBaseDiscountLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.prBaseDiscountLogDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PrBaseDiscountLogRespDto queryById(Long id) {
        PrBaseDiscountLogEo prBaseDiscountLogEo = (PrBaseDiscountLogEo)this.prBaseDiscountLogDas.selectByPrimaryKey(id);
        PrBaseDiscountLogRespDto prBaseDiscountLogRespDto = new PrBaseDiscountLogRespDto();
        DtoHelper.eo2Dto((BaseEo)prBaseDiscountLogEo, (BaseVo)prBaseDiscountLogRespDto);
        return prBaseDiscountLogRespDto;
    }

    @Override
    public PageInfo<PrBaseDiscountLogRespDto> queryByPage(PrBaseDiscountLogReqDto reqDto) {
        PrBaseDiscountLogEo prBaseDiscountLogEo = new PrBaseDiscountLogEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)prBaseDiscountLogEo);
        if (ObjectUtils.isEmpty((Object)prBaseDiscountLogEo.getMerchantId()) && ObjectUtils.isEmpty((Object)prBaseDiscountLogEo.getCustomerId())) {
            String orgIdStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            if (StringUtils.isBlank((CharSequence)orgIdStr)) {
                PriceCenterExceptionCode.ORG_ID_NOT_EXIST.throwException();
            }
            prBaseDiscountLogEo.setMerchantId(Long.valueOf(orgIdStr));
        }
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerCode())) {
            sqlFilterList.add(SqlFilter.like((String)"customer_code", (Object)reqDto.getCustomerCode()));
            prBaseDiscountLogEo.setCustomerCode(null);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerName())) {
            sqlFilterList.add(SqlFilter.like((String)"customer_name", (Object)reqDto.getCustomerName()));
            prBaseDiscountLogEo.setCustomerName(null);
        }
        if (reqDto.getUpdateTimeBegin() != null) {
            sqlFilterList.add(SqlFilter.ge((String)"update_time", (Object)format.format(reqDto.getUpdateTimeBegin())));
        }
        if (reqDto.getUpdateTimeEnd() != null) {
            sqlFilterList.add(SqlFilter.le((String)"update_time", (Object)format.format(reqDto.getUpdateTimeEnd())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdatePerson())) {
            sqlFilterList.add(SqlFilter.like((String)"update_person", (Object)reqDto.getUpdatePerson()));
            prBaseDiscountLogEo.setUpdatePerson(null);
        }
        prBaseDiscountLogEo.setOrderBy("customer_id");
        prBaseDiscountLogEo.setOrderByDesc("update_time");
        prBaseDiscountLogEo.setSqlFilters(sqlFilterList);
        PageInfo eoPageInfo = this.prBaseDiscountLogDas.selectPage((BaseEo)prBaseDiscountLogEo, reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PrBaseDiscountLogRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            dtoList.forEach(e -> this.buildBaseDiscountObject((PrBaseDiscountLogRespDto)e));
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void buildBaseDiscountObject(PrBaseDiscountLogRespDto respDto) {
        if (StringUtils.isNotBlank((CharSequence)respDto.getBrandDiscountJson())) {
            StringBuilder strBuilder = new StringBuilder();
            List brandReqDtoList = JSONObject.parseArray((String)respDto.getBrandDiscountJson(), PrBaseDiscountBrandReqDto.class);
            for (PrBaseDiscountBrandReqDto eo : brandReqDtoList) {
                strBuilder.append(eo.getBrandName() + "\uff1a" + eo.getBrandDiscount() + "\uff1b");
            }
            respDto.setBrandDiscountStr(strBuilder.toString());
        }
    }
}

