/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.price.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.price.api.constant.BaseDiscountImportEnum;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountAddEditReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountQueryReqDto;
import com.yx.tcbj.center.price.api.dto.response.ExcelRespDto;
import com.yx.tcbj.center.price.api.dto.response.PrBaseDiscountRespDto;
import com.yx.tcbj.center.price.api.exception.PriceCenterExceptionCode;
import com.yx.tcbj.center.price.biz.service.IPrBaseDiscountService;
import com.yx.tcbj.center.price.biz.util.EasyPoiExportUtil;
import com.yx.tcbj.center.price.biz.util.NumberFormatUtils;
import com.yx.tcbj.center.price.dao.das.PrBaseDiscountDas;
import com.yx.tcbj.center.price.dao.das.PrBaseDiscountLogDas;
import com.yx.tcbj.center.price.dao.eo.PrBaseDiscountEo;
import com.yx.tcbj.center.price.dao.eo.PrBaseDiscountLogEo;
import com.yx.tcbj.center.price.dao.mapper.PrBaseDiscountLogMapper;
import com.yx.tcbj.center.price.dao.mapper.PrBaseDiscountMapper;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PrBaseDiscountServiceImpl
implements IPrBaseDiscountService {
    private Logger logger = LoggerFactory.getLogger(PrBaseDiscountServiceImpl.class);
    @Resource
    private PrBaseDiscountDas prBaseDiscountDas;
    @Resource
    private IContext context;
    @Resource
    private PrBaseDiscountLogDas logDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private PrBaseDiscountMapper prBaseDiscountMapper;
    @Resource
    private PrBaseDiscountLogMapper prBaseDiscountLogMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrInsert(List<PrBaseDiscountAddEditReqDto> modifyReqDtos) {
        if (CollectionUtils.isNotEmpty(modifyReqDtos)) {
            ArrayList list = Lists.newArrayList();
            modifyReqDtos.stream().forEach(dto -> {
                PrBaseDiscountEo eo = new PrBaseDiscountEo();
                this.checkDiscountValue(dto.getStandardDiscount());
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
                eo.setBrandDiscountJson(JSONObject.toJSONString((Object)dto.getBrandDiscountList()));
                list.add(eo);
            });
            this.prBaseDiscountMapper.updateOrInsert((List)list);
            this.prBaseDiscountLogMapper.insertLogBatch((List)list);
        } else {
            this.logger.error("PrBaseDiscountServiceImpl:updateOrInsert modifyReqDtos is NULL");
        }
    }

    @Override
    public Long addPrBaseDiscount(PrBaseDiscountQueryReqDto addReqDto) {
        PrBaseDiscountEo prBaseDiscountEo = new PrBaseDiscountEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)prBaseDiscountEo);
        this.prBaseDiscountDas.insert((BaseEo)prBaseDiscountEo);
        return prBaseDiscountEo.getId();
    }

    @Override
    public void modifyPrBaseDiscount(PrBaseDiscountQueryReqDto modifyReqDto) {
        PrBaseDiscountEo prBaseDiscountEo = new PrBaseDiscountEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)prBaseDiscountEo);
        this.prBaseDiscountDas.updateSelective((BaseEo)prBaseDiscountEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePrBaseDiscount(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.prBaseDiscountDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PrBaseDiscountRespDto queryById(Long id) {
        PrBaseDiscountEo prBaseDiscountEo = (PrBaseDiscountEo)this.prBaseDiscountDas.selectByPrimaryKey(id);
        return this.transferJsonToStr(prBaseDiscountEo);
    }

    @Override
    public PageInfo<PrBaseDiscountRespDto> queryByPage(PrBaseDiscountQueryReqDto prBaseDiscountQueryReqDto) {
        PageInfo dtoPageInfo = new PageInfo();
        PrBaseDiscountEo prBaseDiscountEo = new PrBaseDiscountEo();
        DtoHelper.dto2Eo((BaseVo)prBaseDiscountQueryReqDto, (BaseEo)prBaseDiscountEo);
        if (ObjectUtils.isEmpty((Object)prBaseDiscountQueryReqDto.getCustomerIdList()) && ObjectUtils.isEmpty((Object)prBaseDiscountQueryReqDto.getCustomerId()) && ObjectUtils.isEmpty((Object)prBaseDiscountQueryReqDto.getMerchantId())) {
            String orgIdStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            if (StringUtils.isBlank((CharSequence)orgIdStr)) {
                PriceCenterExceptionCode.ORG_ID_NOT_EXIST.throwException();
            }
            prBaseDiscountEo.setMerchantId(Long.valueOf(orgIdStr));
        }
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)prBaseDiscountQueryReqDto.getCustomerCode())) {
            sqlFilterList.add(SqlFilter.like((String)"customer_code", (Object)prBaseDiscountQueryReqDto.getCustomerCode()));
            prBaseDiscountEo.setCustomerCode(null);
        }
        ArrayList customerIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)prBaseDiscountQueryReqDto.getCustomerName())) {
            prBaseDiscountEo.setCustomerName(null);
            String orgIdStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            if (StringUtils.isBlank((CharSequence)orgIdStr)) {
                PriceCenterExceptionCode.ORG_ID_NOT_EXIST.throwException();
            }
            Long merchatId = Long.valueOf(orgIdStr);
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            ArrayList<Long> merchantIds = new ArrayList<Long>();
            merchantIds.add(merchatId);
            searchReqDto.setMerchantIds(merchantIds);
            searchReqDto.setName(prBaseDiscountQueryReqDto.getCustomerName());
            RestResponse customerListResp = this.customerQueryApi.queryPostByList(searchReqDto);
            List customerList = (List)RestResponseHelper.extractData((RestResponse)customerListResp);
            if (CollectionUtils.isEmpty((Collection)customerList)) {
                return dtoPageInfo;
            }
            customerIds.addAll(customerList.stream().map(BaseRespDto::getId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)prBaseDiscountQueryReqDto.getCustomerIdList())) {
            customerIds.addAll(prBaseDiscountQueryReqDto.getCustomerIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)customerIds)) {
            sqlFilterList.add(SqlFilter.in((String)"customer_id", (Object)customerIds));
        }
        prBaseDiscountEo.setOrderByDesc("update_time");
        prBaseDiscountEo.setSqlFilters(sqlFilterList);
        PageInfo eoPageInfo = this.prBaseDiscountDas.selectPage((BaseEo)prBaseDiscountEo, prBaseDiscountQueryReqDto.getPageNum(), prBaseDiscountQueryReqDto.getPageSize());
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PrBaseDiscountRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List resultCustomerIds = dtoList.stream().map(PrBaseDiscountRespDto::getCustomerId).distinct().collect(Collectors.toList());
            List customerNameLists = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListOnPostByCustomerIds(resultCustomerIds));
            Map<Long, String> customerMaps = Optional.ofNullable(customerNameLists).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getName()));
            dtoList.forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)customerMaps.get(e.getCustomerId())))) {
                    e.setCustomerName((String)customerMaps.get(e.getCustomerId()));
                }
                this.buildBaseDiscountObject((PrBaseDiscountRespDto)e);
            });
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional
    public Long add(PrBaseDiscountAddEditReqDto addReqDto) {
        PrBaseDiscountEo searchEo = new PrBaseDiscountEo();
        searchEo.setCustomerId(addReqDto.getCustomerId());
        List discountEoList = this.prBaseDiscountDas.select((BaseEo)searchEo);
        if (CollectionUtils.isNotEmpty((Collection)discountEoList)) {
            PriceCenterExceptionCode.DISCOUNT_HAS_EXISTS.throwException();
        }
        this.checkDiscountValue(addReqDto.getStandardDiscount());
        return this.commonAdd(addReqDto);
    }

    @Override
    @Transactional
    public Long commonAdd(PrBaseDiscountAddEditReqDto addReqDto) {
        PrBaseDiscountEo insertEo = new PrBaseDiscountEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[]{"brandDiscountList"});
        return this.addUpdateCommon(addReqDto, insertEo);
    }

    private void checkDiscountValue(BigDecimal discount) {
        if (discount == null) {
            PriceCenterExceptionCode.DISCOUNT_DISABLE_NULL.throwException();
        }
        if (discount.compareTo(BigDecimal.ZERO) < 0) {
            PriceCenterExceptionCode.DISCOUNT_DISABLE_SMALL_ZERO.throwException();
        }
        if (discount.compareTo(new BigDecimal(10000)) >= 0) {
            PriceCenterExceptionCode.DISCOUNT_DISABLE_BIGGER_YIWAN.throwException();
        }
    }

    @Override
    public PrBaseDiscountRespDto queryByCustomerId(Long customerId) {
        PrBaseDiscountEo searchEo = new PrBaseDiscountEo();
        searchEo.setCustomerId(customerId);
        List discountEoList = this.prBaseDiscountDas.selectList((BaseEo)searchEo);
        if (CollectionUtils.isEmpty((Collection)discountEoList)) {
            return new PrBaseDiscountRespDto();
        }
        return this.transferJsonToStr((PrBaseDiscountEo)discountEoList.get(0));
    }

    public PrBaseDiscountRespDto transferJsonToStr(PrBaseDiscountEo resultEo) {
        PrBaseDiscountRespDto respDto = new PrBaseDiscountRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)resultEo, (String[])new String[0]);
        this.buildBaseDiscountObject(respDto);
        return respDto;
    }

    private void buildBaseDiscountObject(PrBaseDiscountRespDto respDto) {
        if (StringUtils.isNotBlank((CharSequence)respDto.getBrandDiscountJson())) {
            StringBuilder strBuilder = new StringBuilder();
            List brandReqDtoList = JSONObject.parseArray((String)respDto.getBrandDiscountJson(), PrBaseDiscountBrandReqDto.class);
            for (PrBaseDiscountBrandReqDto eo : brandReqDtoList) {
                strBuilder.append(eo.getBrandName() + "\uff1a" + eo.getBrandDiscount() + "\uff1b");
            }
            respDto.setBrandDiscountList(brandReqDtoList);
            respDto.setBrandDiscountStr(strBuilder.toString());
        }
    }

    @Override
    @Transactional
    public Long modify(PrBaseDiscountAddEditReqDto addReqDto) {
        PrBaseDiscountEo existEo = (PrBaseDiscountEo)this.prBaseDiscountDas.selectByPrimaryKey(addReqDto.getId());
        if (existEo == null) {
            PriceCenterExceptionCode.DISCOUNT_NOT_EXISTS.throwException();
        }
        this.checkDiscountValue(addReqDto.getStandardDiscount());
        return this.commonModify(addReqDto);
    }

    @Override
    @Transactional
    public Long commonModify(PrBaseDiscountAddEditReqDto addReqDto) {
        PrBaseDiscountEo upEo = new PrBaseDiscountEo();
        upEo.setId(addReqDto.getId());
        upEo.setStandardDiscount(addReqDto.getStandardDiscount());
        return this.addUpdateCommon(addReqDto, upEo);
    }

    private Long addUpdateCommon(PrBaseDiscountAddEditReqDto addReqDto, PrBaseDiscountEo discountEo) {
        int num;
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getBrandDiscountList())) {
            for (PrBaseDiscountBrandReqDto brandDto : addReqDto.getBrandDiscountList()) {
                this.checkDiscountValue(brandDto.getBrandDiscount());
            }
            Set distinctSet = addReqDto.getBrandDiscountList().stream().map(e -> e.getBrandId()).collect(Collectors.toSet());
            if (distinctSet.size() != addReqDto.getBrandDiscountList().size()) {
                PriceCenterExceptionCode.DISCOUNT_BRAND_REPEAT.throwException();
            }
            String brandDiscountJsonStr = JSONObject.toJSONString((Object)addReqDto.getBrandDiscountList().toArray());
            discountEo.setBrandDiscountJson(brandDiscountJsonStr);
        } else {
            discountEo.setBrandDiscountJson("[]");
        }
        boolean ifAdd = discountEo.getId() == null;
        int n = num = ifAdd ? this.prBaseDiscountDas.insert((BaseEo)discountEo) : this.prBaseDiscountDas.updateSelective((BaseEo)discountEo);
        if (num > 0) {
            if (!ifAdd) {
                discountEo = (PrBaseDiscountEo)this.prBaseDiscountDas.selectByPrimaryKey(addReqDto.getId());
            }
            PrBaseDiscountLogEo logInsertEo = new PrBaseDiscountLogEo();
            CubeBeanUtils.copyProperties((Object)logInsertEo, (Object)discountEo, (String[])new String[]{"id"});
            this.logDas.insert((BaseEo)logInsertEo);
        }
        return new Long(num);
    }

    @Override
    public ExcelRespDto excel(MultipartFile file) {
        ExcelRespDto respDto = new ExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        List baseDiscountImportExportVoList = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), Map.class, (ImportParams)importParams);
            baseDiscountImportExportVoList = result.getList();
            if (CollectionUtils.isEmpty(baseDiscountImportExportVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        String orgIdStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        if (StringUtils.isBlank((CharSequence)orgIdStr)) {
            PriceCenterExceptionCode.ORG_ID_NOT_EXIST.throwException();
        }
        Long merchatId = Long.valueOf(orgIdStr);
        int successNum = 0;
        ArrayList errorList = Lists.newArrayList();
        ArrayList<ExcelExportEntity> entityList = new ArrayList<ExcelExportEntity>();
        Set columnNameSet = ((Map)baseDiscountImportExportVoList.get(0)).keySet();
        RestResponse brandResp = this.brandQueryApi.queryByPage("{}", Integer.valueOf(1), Integer.valueOf(5000));
        PageInfo brandPage = (PageInfo)RestResponseHelper.extractData((RestResponse)brandResp);
        if (ObjectUtils.isEmpty((Object)brandPage) || CollectionUtils.isEmpty((Collection)brandPage.getList())) {
            PriceCenterExceptionCode.BRAND_ALL_NOT_EXIST.throwException();
        }
        Map<String, BrandRespDto> brandMap = brandPage.getList().stream().collect(Collectors.toMap(e -> e.getName(), e -> e, (e1, e2) -> e1));
        HashMap<String, Long> brandColumns = new HashMap<String, Long>();
        StringBuilder builder = new StringBuilder();
        for (BaseDiscountImportEnum typeEnum : BaseDiscountImportEnum.values()) {
            if (columnNameSet.contains(typeEnum.getName())) continue;
            builder.append("\u3010" + typeEnum.getName() + "\u3011\u5217\u4e0d\u5b58\u5728\uff1b");
        }
        for (String s : columnNameSet) {
            if (BaseDiscountImportEnum.fromName((String)s) == null) {
                if (brandMap.get(s) == null) {
                    builder.append("\u54c1\u724c\u3010" + s + "\u3011\u4e0d\u5b58\u5728\uff1b");
                } else {
                    brandColumns.put(s, brandMap.get(s).getId());
                }
            }
            entityList.add(new ExcelExportEntity(s, (Object)s));
        }
        if (StringUtils.isNotBlank((CharSequence)builder.toString())) {
            throw new BizException("-1", builder.toString());
        }
        List customerCodeList = baseDiscountImportExportVoList.stream().map(e -> {
            String s = (String)e.get(BaseDiscountImportEnum.CUSTOMER_CODE.getName());
            return s;
        }).collect(Collectors.toList());
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setCodeInList(customerCodeList);
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        merchantIds.add(merchatId);
        searchReqDto.setMerchantIds(merchantIds);
        RestResponse customerListResp = this.customerQueryApi.queryPostByList(searchReqDto);
        List customerList = (List)RestResponseHelper.extractData((RestResponse)customerListResp);
        if (CollectionUtils.isEmpty((Collection)customerList)) {
            PriceCenterExceptionCode.ALL_CUSTOMERS_NOT_EXIST.throwException();
        }
        Map<String, CustomerRespDto> customerMap = customerList.stream().collect(Collectors.toMap(e -> e.getCode(), e -> e, (e1, e2) -> e1));
        HashMap<String, PrBaseDiscountAddEditReqDto> dicountMap = new HashMap<String, PrBaseDiscountAddEditReqDto>();
        BigDecimal maxDiscount = new BigDecimal("10000");
        String errColumnName = "\u5bfc\u5165\u5931\u8d25\u539f\u56e0";
        entityList.add(new ExcelExportEntity(errColumnName, (Object)errColumnName));
        for (Map vo : baseDiscountImportExportVoList) {
            String standardDiscountStr;
            StringBuilder errorMsg = new StringBuilder();
            String customerCode = (String)vo.get(BaseDiscountImportEnum.CUSTOMER_CODE.getName());
            CustomerRespDto customerRespDto = customerMap.get(customerCode);
            PrBaseDiscountAddEditReqDto addReqDto = new PrBaseDiscountAddEditReqDto();
            if (StringUtils.isBlank((CharSequence)customerCode) || customerRespDto == null) {
                errorMsg.append("\u3010\u5ba2\u6237\u7f16\u53f7\u3011\u4e0d\u5b58\u5728\uff1b \r\n");
            } else {
                addReqDto.setCustomerId(customerRespDto.getId());
                addReqDto.setCustomerCode(customerRespDto.getCode());
                addReqDto.setCustomerName(customerRespDto.getName());
                addReqDto.setMerchantId(merchatId);
                addReqDto.setOrgInfoId(customerRespDto.getOrgInfoId());
            }
            if (dicountMap.get(customerCode) != null) {
                errorMsg.append("\u8be5\u3010\u5ba2\u6237\u7f16\u53f7\u3011\u7684\u6570\u636e\u4e0e\u5176\u4ed6\u6570\u636e\u91cd\u590d\uff1b \r\n");
            } else {
                dicountMap.put(customerCode, addReqDto);
            }
            String string = standardDiscountStr = vo.get(BaseDiscountImportEnum.STANDARD_DISCOUNT.getName()) == null ? "" : String.valueOf(vo.get(BaseDiscountImportEnum.STANDARD_DISCOUNT.getName()));
            if (!NumberFormatUtils.numberCheck(standardDiscountStr, 0, 2, 7) || maxDiscount.compareTo(new BigDecimal(standardDiscountStr)) <= 0) {
                errorMsg.append("\u3010\u6807\u51c6\u6263\u7387\u3011\u5fc5\u987b\u4e3a\u5c0f\u4e8e10000\u7684\u6574\u6570\u6216\u4e24\u4f4d\u5c0f\u6570 \u5982\uff1a99, 100.1, 100.12\uff1b \r\n");
            } else {
                addReqDto.setStandardDiscount(new BigDecimal(standardDiscountStr));
            }
            ArrayList<PrBaseDiscountBrandReqDto> brandDiscountList = new ArrayList<PrBaseDiscountBrandReqDto>();
            for (String brandName : brandColumns.keySet()) {
                BrandRespDto brandRespDto = brandMap.get(brandName);
                PrBaseDiscountBrandReqDto brandReqDto = new PrBaseDiscountBrandReqDto();
                String brandDiscountStr = vo.get(brandName) == null ? "" : String.valueOf(vo.get(brandName));
                if (!StringUtils.isNotBlank((CharSequence)brandDiscountStr)) continue;
                if (!NumberFormatUtils.numberCheck(brandDiscountStr, 0, 2, 7) || maxDiscount.compareTo(new BigDecimal(brandDiscountStr)) <= 0) {
                    errorMsg.append("\u3010" + brandName + "\u3011\u54c1\u724c\u6263\u7387\u5fc5\u987b\u4e3a\u5c0f\u4e8e10000\u7684\u6574\u6570\u6216\u4e24\u4f4d\u5c0f\u6570 \u5982\uff1a99, 100.1, 100.12\uff1b \r\n");
                    continue;
                }
                brandReqDto.setBrandId(brandRespDto.getId());
                brandReqDto.setBrandName(brandRespDto.getName());
                brandReqDto.setBrandDiscount(new BigDecimal(brandDiscountStr));
                brandDiscountList.add(brandReqDto);
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                vo.put(errColumnName, errorMsg.toString());
                errorList.add(vo);
                continue;
            }
            if (CollectionUtils.isNotEmpty(brandDiscountList)) {
                addReqDto.setBrandDiscountList(brandDiscountList);
            }
            PrBaseDiscountEo searchEo = new PrBaseDiscountEo();
            searchEo.setCustomerId(addReqDto.getCustomerId());
            PrBaseDiscountEo existEo = (PrBaseDiscountEo)this.prBaseDiscountDas.selectOne((BaseEo)searchEo);
            if (ObjectUtils.isNotEmpty((Object)existEo)) {
                addReqDto.setId(existEo.getId());
                this.commonModify(addReqDto);
            } else {
                this.commonAdd(addReqDto);
            }
            ++successNum;
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            String excelName = "\u57fa\u7840\u6263\u7387\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            String suffix = ".xlsx";
            try {
                respDto.setFailNum(Integer.valueOf(errorList.size()));
                ExportParams params = new ExportParams(null, "", ".xls".equalsIgnoreCase(suffix) ? ExcelType.HSSF : ExcelType.XSSF);
                String exportUrl = EasyPoiExportUtil.exportByMap(excelName + suffix, params, entityList, errorList);
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e4) {
                this.logger.error("\u5bfc\u5165\u57fa\u7840\u6263\u7387-\u9519\u8bef: {}", (Object)e4.toString());
                throw new BizException("-1", "\u5bfc\u5165\u57fa\u7840\u6263\u7387-\u9519\u8bef:" + e4);
            }
        } else {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
        }
        respDto.setNum(Integer.valueOf(baseDiscountImportExportVoList.size()));
        respDto.setSuccessNum(Integer.valueOf(successNum));
        return respDto;
    }
}

