/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.utils;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.IdGenrator;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class NoGreateUtil {
    @Resource
    private ICacheService cacheService;
    private static final String AFTER_SALE_ORDER_PREFIX = "AF";

    private static String getOrderIdPrefix(LocalDateTime now, String format) {
        return now.format(DateTimeFormatter.ofPattern(format));
    }

    private long generate(String key, Date expireTime) {
        boolean exists = this.cacheService.exists(key);
        if (exists) {
            return this.cacheService.incr(key);
        }
        int expireSecond = DateUtil.getDifferMinute((Date)new Date(), (Date)expireTime) * 60;
        return this.cacheService.incr(key, (long)expireSecond);
    }

    public String generateOrderNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        String orderId = "DD" + orderIdPrefix + String.format("%1$06d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
        return orderId;
    }

    public String generateDefaultPlatformNo() {
        return String.format("PN%s", IdGenrator.getDistributedId());
    }

    public String generateCkspPlatformNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        return "cksp" + orderIdPrefix + String.format("%1$06d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
    }

    public String generateRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String ruleCode = "DR" + orderIdPrefix + String.format("%1$03d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
        return ruleCode;
    }

    public String generateTagNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String ruleCode = "TAG" + orderIdPrefix + String.format("%1$03d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
        return ruleCode;
    }

    public String generateLabelNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String ruleCode = "BS" + orderIdPrefix + String.format("%1$03d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
        return ruleCode;
    }

    public String generateRefundNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        String orderId = "RE" + orderIdPrefix + String.format("%1$06d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
        return orderId;
    }

    public String generateAfterSaleOrderNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        return AFTER_SALE_ORDER_PREFIX + orderIdPrefix + String.format("%1$06d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
    }

    public String generateNo(String prefix, Integer footLength) {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        String orderId = prefix + orderIdPrefix + String.format("%1$0" + footLength + "d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
        return orderId;
    }

    public static void main(String[] args) {
        Integer num = 4;
        System.out.println(String.format("%1$04d", 12));
        System.out.println(String.format("%1$0" + num + "d", 1));
    }

    private Date getExpireAtTime(LocalDateTime now) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = now.plusDays(1L);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public static Long getId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = IdGenrator.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }
}

