/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.excel;

import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExcelService {
    private static final Logger logger = LoggerFactory.getLogger(ExcelService.class);
    @Autowired
    private IObjectStorageService ossService;
    @Autowired
    private OssRegistryVo ossRegistryVo;

    public String getFileUrl(String title, Workbook workbook, String fileName) {
        ByteArrayOutputStream fos = null;
        fileName = fileName + ".xls";
        try {
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            this.ossService.put(this.ossRegistryVo.getBucketName(), fileName, (InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            logger.error(title + "\u5bfc\u51faexcel\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
            throw new BusinessRuntimeException(title + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        return this.ossRegistryVo.getEndpoint() + "/" + fileName;
    }
}

