/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateDetailDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateDetailEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.StdOrderEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.rebate.api.dto.response.RebateDetailExtRespDto;
import com.yx.tcbj.center.rebate.biz.service.IRebateDetailV2Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="IRebateDetailV2Service")
public class RebateDetailServiceImpl
implements IRebateDetailV2Service {
    private static final Logger logger = LoggerFactory.getLogger(RebateDetailServiceImpl.class);
    @Resource
    private RebateDetailDas rebateDetailDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private OrderDas orderDas;
    @Autowired
    private IShopQueryApi shopQueryApi;

    @Override
    public PageInfo<RebateDetailExtRespDto> queryRebateDetailByPage(RebateDetailQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        RebateDetailEo rebateDetailEo = new RebateDetailEo();
        PageInfo pageInfo = this.getRebateDetailEo(reqDto, rebateDetailEo);
        if (pageInfo != null) {
            return pageInfo;
        }
        PageInfo eoPageInfo = this.rebateDetailDas.selectPage((BaseEo)rebateDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, RebateDetailExtRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List customerIds = dtoList.stream().map(RebateDetailRespDto::getUserId).distinct().collect(Collectors.toList());
            RestResponse customerRespDtoResponse = this.customerExtQueryApi.queryListOnPostByCustomerIds(customerIds);
            List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)customerRespDtoResponse);
            Map<Long, List<CustomerRespDto>> customerMap = customerRespDtoList.stream().collect(Collectors.groupingBy(BaseRespDto::getId));
            dtoList.forEach(bean -> {
                List dtos = (List)customerMap.get(bean.getUserId());
                if (CollectionUtils.isNotEmpty((Collection)dtos)) {
                    bean.setCustomerCode(((CustomerRespDto)dtos.get(0)).getCode());
                } else {
                    bean.setCustomerCode("");
                }
            });
            List merchantIds = customerRespDtoList.stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList());
            ShopQueryDto shopQueryDto = new ShopQueryDto();
            shopQueryDto.setOrganizationIdList(merchantIds);
            List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopListNew(shopQueryDto));
            Map<Long, String> shopNameMap = shopDtos.stream().collect(Collectors.toMap(ShopDto::getOrganizationId, ShopDto::getName, (e1, e2) -> e1));
            Map<Long, Long> customerIdMerchantOrgIdMap = customerRespDtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, CustomerRespDto::getMerchantId));
            dtoList.forEach(bean -> {
                Long merchantId = (Long)customerIdMerchantOrgIdMap.get(bean.getUserId());
                bean.setMerchantName((String)shopNameMap.get(merchantId));
            });
            List<String> businessNos = dtoList.stream().filter(bean -> StringUtils.isNotEmpty((CharSequence)bean.getType()) && (RebateTypeEnum.ORDER_REBATE.getType().toString().equals(bean.getType()) || RebateTypeEnum.MANUAL_REBATE.getType().toString().equals(bean.getType()) || RebateTypeEnum.FAILURE.getType().toString().equals(bean.getType()) || RebateTypeEnum.ADJUSTMENT_EFFECT.getType().toString().equals(bean.getType()) || RebateTypeEnum.MANUAL_ADJUSTMENT_ADD.getType().toString().equals(bean.getType()) || RebateTypeEnum.MANUAL_ADJUSTMENT_SUB.getType().toString().equals(bean.getType())) && StringUtils.isNotEmpty((CharSequence)bean.getBusinessNo())).map(RebateDetailRespDto::getBusinessNo).collect(Collectors.toList());
            Map<String, List<OrderEo>> orderEoMap = this.queryRebateOrderByNos(businessNos);
            dtoList.stream().forEach(bean -> {
                List orderEos;
                if (StringUtils.isNotEmpty((CharSequence)bean.getBusinessNo()) && null != orderEoMap && CollectionUtils.isNotEmpty((Collection)(orderEos = (List)orderEoMap.get(bean.getBusinessNo())))) {
                    bean.setRebateOrderId(((OrderEo)orderEos.get(0)).getId());
                }
            });
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private PageInfo getRebateDetailEo(RebateDetailQueryReqDto reqDto, RebateDetailEo rebateDetailEo) {
        Long userOrganizationId;
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rebateDetailEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (null != reqDto.getBeginTime()) {
            sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)reqDto.getBeginTime()));
        }
        if (null != reqDto.getEndTime()) {
            sqlFilters.add(SqlFilter.le((String)"create_time", (Object)reqDto.getEndTime()));
        }
        rebateDetailEo.setSqlFilters(sqlFilters);
        rebateDetailEo.setOrderByDesc("create_time");
        if (StringUtils.isNotBlank((CharSequence)reqDto.getMerchantIdList())) {
            StringBuilder userIdList = new StringBuilder();
            RestResponse response = this.customerExtQueryApi.queryCurrentUserOrgId();
            Long userOrganizationId2 = (Long)RestResponseHelper.extractData((RestResponse)response);
            List customerList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds(Stream.of(reqDto.getMerchantIdList().split(",")).map(Long::parseLong).collect(Collectors.toList()), userOrganizationId2));
            logger.info("\u4ee3\u5ba2\u4e0b\u5355-\u5f52\u5c5e\uff1a{}", (Object)JSON.toJSONString((Object)customerList));
            if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                for (CustomerRespDto customerRespDto : customerList) {
                    userIdList.append(customerRespDto.getId());
                    userIdList.append(",");
                }
            } else {
                return new PageInfo();
            }
            if (userIdList.length() > 0) {
                reqDto.setUserIdList(userIdList.substring(0, userIdList.length() - 1));
            }
        }
        if (reqDto.getMerchantId() != null) {
            RestResponse response = this.customerExtQueryApi.queryCurrentUserOrgId();
            userOrganizationId = (Long)RestResponseHelper.extractData((RestResponse)response);
            RestResponse companyResponse = this.customerExtQueryApi.queryCustomerByOrgAndMerch(userOrganizationId, Long.valueOf(reqDto.getMerchantId()));
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)companyResponse);
            if (customerRespDto != null) {
                reqDto.setUserId(customerRespDto.getId());
            } else {
                return new PageInfo();
            }
        }
        if (reqDto.getUserId() != null && StringUtils.isBlank((CharSequence)reqDto.getUserIdList())) {
            sqlFilters.add(SqlFilter.like((String)"user_id", (Object)reqDto.getUserId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUserIdList())) {
            sqlFilters.add(SqlFilter.in((String)"user_id", (Object)StringUtils.join((Object[])new String[]{reqDto.getUserIdList(), ","})));
        }
        if (reqDto.getType() != null && StringUtils.isBlank((CharSequence)reqDto.getTypeList())) {
            sqlFilters.add(SqlFilter.eq((String)"type", (Object)reqDto.getUserId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTypeList())) {
            sqlFilters.add(SqlFilter.in((String)"type", (Object)StringUtils.join((Object[])new String[]{reqDto.getTypeList(), ","})));
        }
        CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
        userOrganizationId = reqDto.getOrganizationId();
        if (userOrganizationId == null) {
            RestResponse response = this.customerExtQueryApi.queryCurrentUserOrgId();
            userOrganizationId = (Long)RestResponseHelper.extractData((RestResponse)response);
        }
        customerSearchReqDto.setMerchantId(userOrganizationId);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getUserName())) {
            rebateDetailEo.setUserName(null);
            customerSearchReqDto.setKeyword(reqDto.getUserName());
        }
        RestResponse customerResponse = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)customerSearchReqDto));
        logger.info("\u4f59\u989d\u8d26\u6237\u641c\u7d22:{}", (Object)JSON.toJSONString((Object)customerResponse));
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)customerResponse);
        if (!CollectionUtils.isNotEmpty((Collection)customerRespDtoList)) {
            return new PageInfo();
        }
        sqlFilters.add(SqlFilter.in((String)"user_id", customerRespDtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList())));
        return null;
    }

    private Map<String, List<OrderEo>> queryRebateOrderByNos(List<String> businessNos) {
        if (CollectionUtils.isNotEmpty(businessNos)) {
            OrderEo orderEo = new OrderEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"rebate_no", businessNos));
            orderEo.setSqlFilters(sqlFilters);
            List orderEos = this.orderDas.select((BaseEo)orderEo);
            if (CollectionUtils.isNotEmpty((Collection)orderEos)) {
                return orderEos.stream().collect(Collectors.groupingBy(StdOrderEo::getRebateNo));
            }
        }
        return null;
    }
}

