/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.ChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.UserTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.OrderDetailVO;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.AttachmentAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceNegativeReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderAdjustmentReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateOrderCountReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderImportRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.exception.RebateExceptionCode;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IAttachmentService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.OrderServiceImpl;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.gateway.OrganizationGateway;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.DateUtil;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.RebateUtil;
import com.dtyunxi.yundt.cube.center.rebate.biz.vo.RebateOrderImportVo;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.AttachmentDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.BalanceDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.CategoryDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.PolicyDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateDetailDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateOrderAuditDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateUseLogDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.AttachmentEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.BalanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.CategoryEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PolicyEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PreSettlementEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateDetailEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateOrderAuditEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateUseLogEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.StdBalanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.StdOrderEo;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.rebate.api.dto.request.RebateOrderNoOffsetReqDto;
import com.yx.tcbj.center.rebate.api.exception.RebateV2ExceptionCode;
import com.yx.tcbj.center.rebate.biz.service.BalanceV2Service;
import com.yx.tcbj.center.rebate.biz.service.IOrderV2Service;
import com.yx.tcbj.center.rebate.dao.das.OrderV2Das;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OrderV2ServiceImpl
implements IOrderV2Service {
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(OrderV2ServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Resource
    private OrderV2Das orderV2Das;
    @Resource
    private AttachmentDas attachmentDas;
    @Resource
    private BalanceDas balanceDas;
    @Resource
    private RebateOrderAuditDas rebateOrderAuditDas;
    @Resource
    private IContext context;
    @Resource
    private RebateDetailDas rebateDetailDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private PolicyDas policyDas;
    @Resource
    private CategoryDas categoryDas;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private PlatformTransactionManager platformTransactionManager;
    @Resource
    private TransactionDefinition transactionDefinition;
    @Resource
    private OrganizationGateway organizationGateway;
    @Resource
    private IAttachmentService attachmentService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    private static final String TASK_NAME_PRE = "\u8fd4\u5229\u5355\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1_";
    @Resource
    private RebateUseLogDas rebateUseLogDas;
    @Resource
    private BalanceV2Service balanceV2Service;
    @Resource
    private ILockService lockService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOrder(OrderAddReqDto reqDto) {
        Assert.notNull((Object)reqDto.getRebateAmount(), (String)"100000", (String)"\u5145\u503c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqDto.getRebateAmount().compareTo(BigDecimal.ZERO) < 0 && !"1".equals(reqDto.getUseEffectType() + "")) {
            Assert.isTrue((boolean)false, (String)"100000", (String)"\u8d1f\u6570\u6298\u6263\u5355\u53ea\u80fd\u4e3a\u957f\u671f\u6709\u6548");
        }
        if (Integer.valueOf(2).equals(reqDto.getUseEffectType()) && reqDto.getEffectEndTime().before(new Date())) {
            throw new BizException("\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        OrderEo orderEo = new OrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)orderEo);
        BalanceEo queryBalanceEo = new BalanceEo();
        queryBalanceEo.setUserId(reqDto.getUserId());
        queryBalanceEo.setUserType(StringUtils.isNotEmpty((CharSequence)reqDto.getUserType()) ? reqDto.getUserType() : UserTypeEnum.CUSTOMER.toCode());
        BalanceEo balanceEo = (BalanceEo)this.balanceDas.selectOne((BaseEo)queryBalanceEo);
        if (null == balanceEo) {
            throw new BizException(RebateExceptionCode.REBATE_ACCOUNT_NOT_EXISTS.getCode(), RebateExceptionCode.REBATE_ACCOUNT_NOT_EXISTS.getMsg());
        }
        reqDto.setOrganizationId(this.organizationGateway.getOrganizationId());
        orderEo.setOrganizationId(reqDto.getOrganizationId());
        RestResponse orgAndOrgInfoRespDtoRestResponse = this.organizationQueryApi.queryOrgAndOrgInfo(reqDto.getOrganizationId());
        OrgAndOrgInfoRespDto orgAndOrgInfoRespData = (OrgAndOrgInfoRespDto)orgAndOrgInfoRespDtoRestResponse.getData();
        if (null != orgAndOrgInfoRespData && null != orgAndOrgInfoRespData.getOrganizationDto()) {
            orderEo.setOrganizationName(orgAndOrgInfoRespData.getOrganizationDto().getName());
        }
        if (Integer.valueOf(1).equals(reqDto.getUseEffectType())) {
            orderEo.setEffectEndTime((Date)null);
        }
        String rebateNo = RebateUtil.generateRebateAccountNo((String)"RB");
        orderEo.setRebateNo(rebateNo);
        orderEo.setRebateAccountNo(balanceEo.getRebateAccountNo());
        orderEo.setStatus(RebateOrderStatusEnum.WAIT_AUDIT.getCode());
        this.orderV2Das.insert((BaseEo)orderEo);
        this.saveAttachements(reqDto.getAttachements(), orderEo.getId());
        if (Integer.valueOf(2).equals(orderEo.getUseEffectType()) && orderEo.getEffectEndTime() != null) {
            this.createOrderTask(orderEo);
        }
        return orderEo.getId();
    }

    private void createOrderTask(OrderEo orderEo) {
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode("rebateExpiredExtScheduler");
        dto.setBizName("\u8fd4\u5229\u5355\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1" + orderEo.getId());
        dto.setParams("" + orderEo.getId());
        dto.setScheduleExpression(DateUtil.date2Cron((Date)orderEo.getEffectEndTime()));
        dto.setShardType("SINGLE");
        dto.setTaskBatchId((Long)null);
        dto.setTaskDesc("");
        dto.setTaskName(TASK_NAME_PRE + orderEo.getId());
        dto.setInstanceId(Long.valueOf(1254039287584232622L));
        dto.setTenantId(Long.valueOf(1L));
        Long id = (Long)this.taskApi.addWithBiz(dto).getData();
        this.taskApi.enableById(id, "{}");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOrder(OrderModifyReqDto reqDto) {
        boolean isUseOrder;
        Assert.notNull((Object)reqDto.getId(), (String)"100000", (String)"\u6298\u6263\u5145\u503c\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        if (Integer.valueOf(2).equals(reqDto.getUseEffectType()) && reqDto.getEffectEndTime() == null) {
            throw new BizException("\u622a\u81f3\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Integer.valueOf(2).equals(reqDto.getUseEffectType()) && reqDto.getEffectEndTime().before(new Date())) {
            throw new BizException("\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getId, (Object)reqDto.getId());
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        OrderEo oldOrderEo = (OrderEo)this.orderV2Das.getMapper().selectOne((Wrapper)queryWrapper);
        OrderEo orderEo = new OrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)orderEo);
        orderEo.setRebateNo(oldOrderEo.getRebateNo());
        if (null != reqDto.getOrganizationId() && StringUtils.isEmpty((CharSequence)reqDto.getOrganizationName())) {
            if (reqDto.getOrganizationId().equals(0L)) {
                orderEo.setOrganizationName("\u9ed8\u8ba4\u7ec4\u7ec7");
            } else {
                RestResponse orgAndOrgInfoRespDtoRestResponse = this.organizationQueryApi.queryOrgAndOrgInfo(reqDto.getOrganizationId());
                OrgAndOrgInfoRespDto orgAndOrgInfoRespData = (OrgAndOrgInfoRespDto)orgAndOrgInfoRespDtoRestResponse.getData();
                if (null != orgAndOrgInfoRespData && null != orgAndOrgInfoRespData.getOrganizationDto()) {
                    orderEo.setOrganizationName(orgAndOrgInfoRespData.getOrganizationDto().getName());
                }
            }
        }
        if (Integer.valueOf(1).equals(reqDto.getUseEffectType())) {
            orderEo.setEffectEndTime((Date)null);
        }
        if (RebateOrderStatusEnum.AUDIT_REJECT.getCode().equals(reqDto.getStatus())) {
            orderEo.setStatus(RebateOrderStatusEnum.WAIT_AUDIT.getCode());
        }
        boolean bl = isUseOrder = RebateOrderStatusEnum.EXPIRED.getCode().equals(oldOrderEo.getStatus()) && (Integer.valueOf(1).equals(reqDto.getUseEffectType()) || reqDto.getEffectEndTime().after(new Date()));
        if (isUseOrder) {
            orderEo.setStatus(RebateOrderStatusEnum.ISSUED.getCode());
        }
        this.orderV2Das.updateSelective((BaseEo)orderEo);
        AttachmentEo attachementEo = new AttachmentEo();
        attachementEo.setBusinessId(reqDto.getId());
        attachementEo.setBusinessType(BusinessTypeEnum.REBATE_ORDER.getType());
        this.attachmentDas.delete((BaseEo)attachementEo);
        this.saveAttachements(reqDto.getAttachements(), reqDto.getId());
        if (isUseOrder) {
            this.adjustmentEffect(orderEo);
        }
        if (Integer.valueOf(2).equals(orderEo.getUseEffectType()) && orderEo.getEffectEndTime() != null) {
            this.refreshOrderTask(orderEo);
        }
    }

    private void adjustmentEffect(OrderEo orderEo) {
        BigDecimal adjustmentAmount;
        BigDecimal bigDecimal = adjustmentAmount = orderEo.getBalance() != null ? orderEo.getBalance() : orderEo.getRebateAmount();
        if (adjustmentAmount.compareTo(BigDecimal.ZERO) == 0) {
            logger.info("[\u6548\u671f\u8c03\u6574],\u5145\u503c\u5355\u5269\u4f59\u91d1\u989d\u7b49\u4e8e0\uff0c\u4e0d\u5904\u7406");
        } else {
            BalanceEo balanceEo = this.balanceDas.queryCustomerAccountByUserId(orderEo.getUserId());
            Assert.notNull((Object)balanceEo, (String)"100000", (String)"\u6298\u6263\u8d26\u6237\u4e0d\u5b58\u5728");
            int row = this.balanceDas.releaseBalanceByCAS(balanceEo.getId(), balanceEo.getVersion(), adjustmentAmount);
            Assert.isTrue((row == 1 ? 1 : 0) != 0, (String)"100000", (String)"\u6298\u6263\u8d26\u6237\u66f4\u65b0\u5931\u8d25");
            RebateDetailEo rebateDetailEo = new RebateDetailEo();
            rebateDetailEo.setRebateAccountNo(balanceEo.getRebateAccountNo());
            rebateDetailEo.setUserId(balanceEo.getUserId());
            rebateDetailEo.setUserName(balanceEo.getUserName());
            rebateDetailEo.setUserType(balanceEo.getUserType());
            rebateDetailEo.setChangeAmount(adjustmentAmount);
            rebateDetailEo.setBalanceSnapshot(balanceEo.getBalance().add(adjustmentAmount));
            rebateDetailEo.setType(RebateTypeEnum.ADJUSTMENT_EFFECT.getType().toString());
            rebateDetailEo.setBusinessNo(orderEo.getRebateNo());
            this.rebateDetailDas.insert((BaseEo)rebateDetailEo);
        }
    }

    private void refreshOrderTask(OrderEo orderEo) {
        this.deleteRebateOrderTask(orderEo.getId());
        this.createOrderTask(orderEo);
    }

    private void deleteRebateOrderTask(Long id) {
        TaskQueryReqDto forQuery = new TaskQueryReqDto();
        forQuery.setTaskName(TASK_NAME_PRE + id);
        List taskList = ((PageInfo)this.taskQueryApi.queryByPage(JSON.toJSONString((Object)forQuery), Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            taskList.forEach(task -> {
                if (Objects.equals(task.getStatus(), TaskStatusEnum.ENABLE.getCode())) {
                    this.taskApi.disableById(task.getId(), "{}");
                }
                this.taskApi.removeById(task.getId(), "{}");
            });
        }
    }

    private void saveAttachements(List<AttachmentAddReqDto> attachments, Long businessId) {
        if (CollectionUtils.isNotEmpty(attachments)) {
            ArrayList attachmentEos = new ArrayList();
            DtoHelper.dtoList2EoList(attachments, attachmentEos, AttachmentEo.class);
            attachmentEos.forEach(bean -> {
                bean.setBusinessType(BusinessTypeEnum.REBATE_ORDER.getType());
                bean.setBusinessId(businessId);
            });
            this.attachmentDas.insertBatch(attachmentEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrder(List<Long> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BaseEo::getId, ids);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        List orderEos = this.orderV2Das.getMapper().selectList((Wrapper)queryWrapper);
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)orderEos), (String)"100000", (String)"\u6298\u6263\u5145\u503c\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
        for (OrderEo orderEo : orderEos) {
            Assert.isTrue((RebateOrderStatusEnum.WAIT_ISSUE.getCode().equals(orderEo.getStatus()) || RebateOrderStatusEnum.AUDIT_REJECT.getCode().equals(orderEo.getStatus()) ? 1 : 0) != 0, (String)"100000", (String)"\u5f85\u53d1\u653e/\u5ba1\u6838\u4e0d\u901a\u8fc7\u624d\u80fd\u5220\u9664");
            if (RebateOrderStatusEnum.WAIT_ISSUE.getCode().equals(orderEo.getStatus())) {
                this.deleteRebateOrderTask(orderEo.getId());
            }
            this.orderV2Das.logicDeleteById(orderEo.getId());
        }
    }

    @Override
    public OrderRespDto queryOrderById(Long id) {
        CategoryEo categoryEo;
        PolicyEo policyEo;
        OrderEo orderEo = (OrderEo)this.orderV2Das.selectByPrimaryKey(id);
        if (orderEo == null) {
            return null;
        }
        OrderRespDto orderRespDto = new OrderRespDto();
        DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)orderRespDto);
        if (null != orderRespDto.getPolicyId() && null != (policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(orderRespDto.getPolicyId()))) {
            orderRespDto.setPolicyName(policyEo.getName());
        }
        if (null != orderRespDto.getCategoryId() && null != (categoryEo = (CategoryEo)this.categoryDas.selectByPrimaryKey(orderRespDto.getCategoryId()))) {
            orderRespDto.setCategoryName(categoryEo.getName());
        }
        RebateOrderAuditEo queryRebateOrderAuditEo = new RebateOrderAuditEo();
        queryRebateOrderAuditEo.setRebateNo(orderEo.getRebateNo());
        queryRebateOrderAuditEo.setOrderByDesc("create_time");
        List rebateOrderAuditEos = this.rebateOrderAuditDas.select((BaseEo)queryRebateOrderAuditEo);
        if (CollectionUtils.isNotEmpty((Collection)rebateOrderAuditEos)) {
            orderRespDto.setAuditDesc(((RebateOrderAuditEo)rebateOrderAuditEos.get(0)).getAuditDesc());
        }
        orderRespDto.setAttachments(this.attachmentService.getPolicyAttachment(orderRespDto.getId(), BusinessTypeEnum.REBATE_ORDER.getType()));
        return orderRespDto;
    }

    @Override
    public PageInfo<OrderRespDto> queryOrderByPage(OrderQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        if (reqDto.getOrganizationId() == null) {
            reqDto.setOrganizationId(this.organizationGateway.getOrganizationId());
        }
        OrgAdvDetailRespDto orgAdvDetailRespDto = null;
        if (reqDto.getOrganizationId() != null) {
            orgAdvDetailRespDto = this.organizationGateway.queryOrgInfo(reqDto.getOrganizationId());
        }
        PageInfo dtoPageInfo = new PageInfo();
        List<Object> customerIds = new ArrayList();
        List<Object> policyIds = new ArrayList();
        ArrayList<SqlFilter> orderSqlFilters = new ArrayList<SqlFilter>();
        OrderEo orderEo = new OrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)orderEo);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getKeyword())) {
            JSONObject filter = new JSONObject();
            filter.put("keyword", (Object)reqDto.getKeyword());
            RestResponse pageInfoRestResponse = this.customerQueryApi.queryByPage(filter.toJSONString(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                customerIds = pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(customerIds)) {
                return dtoPageInfo;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getPolicyName())) {
            PolicyEo queryPolicyEo = new PolicyEo();
            ArrayList<SqlFilter> dtoSqlList = new ArrayList<SqlFilter>();
            dtoSqlList.add(SqlFilter.like((String)"name", (Object)("%" + reqDto.getPolicyName() + "%")));
            queryPolicyEo.setSqlFilters(dtoSqlList);
            List policyEos = this.policyDas.select((BaseEo)queryPolicyEo);
            if (CollectionUtils.isNotEmpty((Collection)policyEos)) {
                policyIds = policyEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(policyIds)) {
                return dtoPageInfo;
            }
        }
        if (CollectionUtils.isNotEmpty(customerIds)) {
            orderSqlFilters.add(SqlFilter.in((String)"user_id", customerIds));
            orderEo.setUserName((String)null);
        }
        if (CollectionUtils.isNotEmpty(policyIds)) {
            orderSqlFilters.add(SqlFilter.in((String)"policy_id", policyIds));
        }
        if (null != reqDto.getBeginTime()) {
            orderSqlFilters.add(SqlFilter.ge((String)"create_time", (Object)reqDto.getBeginTime()));
        }
        if (null != reqDto.getEndTime()) {
            orderSqlFilters.add(SqlFilter.le((String)"create_time", (Object)reqDto.getEndTime()));
        }
        if (reqDto.getCategoryId() != null) {
            ArrayList<Long> allCategoryId = new ArrayList<Long>();
            allCategoryId.add(reqDto.getCategoryId());
            this.categoryDas.selectSubCategoryIds(reqDto.getCategoryId(), allCategoryId);
            orderSqlFilters.add(SqlFilter.in((String)"category_id", allCategoryId));
            orderEo.setCategoryId((Long)null);
        }
        if (CollectionUtils.isNotEmpty(orderSqlFilters)) {
            orderEo.setSqlFilters(orderSqlFilters);
        }
        ArrayList dtoList = new ArrayList();
        orderEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.orderV2Das.selectPage((BaseEo)orderEo, pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            Map<Long, List<PolicyEo>> policyEosMap = null;
            Map<Long, List<CategoryEo>> categoryEosMap = null;
            List<Long> policyIdsResp = dtoList.stream().filter(beanx -> null != beanx.getPolicyId()).map(OrderRespDto::getPolicyId).distinct().collect(Collectors.toList());
            List<Long> categoryIdsResp = dtoList.stream().filter(beanx -> null != beanx.getCategoryId()).map(OrderRespDto::getCategoryId).distinct().collect(Collectors.toList());
            List customerIdList = dtoList.stream().map(OrderRespDto::getUserId).distinct().collect(Collectors.toList());
            Map<Object, Object> customerCodeMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(customerIdList)) {
                List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customerIdList));
                customerCodeMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, CustomerRespDto::getCode, (e1, e2) -> e1));
            }
            if (CollectionUtils.isNotEmpty(policyIdsResp)) {
                policyEosMap = this.queryPolicyEosByIds(policyIdsResp);
            }
            if (CollectionUtils.isNotEmpty(categoryIdsResp)) {
                categoryEosMap = this.queryCategoryEoByIds(categoryIdsResp);
            }
            for (OrderRespDto bean : dtoList) {
                if (orgAdvDetailRespDto != null) {
                    bean.setOrganizationName(orgAdvDetailRespDto.getName());
                }
                if (null != policyEosMap && CollectionUtils.isNotEmpty((Collection)policyEosMap.get(bean.getPolicyId()))) {
                    bean.setPolicyName(policyEosMap.get(bean.getPolicyId()).get(0).getName());
                }
                if (null != categoryEosMap && CollectionUtils.isNotEmpty((Collection)categoryEosMap.get(bean.getCategoryId()))) {
                    bean.setCategoryName(categoryEosMap.get(bean.getCategoryId()).get(0).getName());
                }
                bean.setCustomerCode((String)customerCodeMap.get(bean.getUserId()));
                BigDecimal usedBalance = BigDecimal.ZERO;
                if (bean.getBalance() != null) {
                    usedBalance = bean.getRebateAmount().subtract(bean.getBalance());
                }
                bean.setUsedbalance(usedBalance);
                String effectStatus = "\u5426";
                if (bean.getEffectEndTime() != null && bean.getEffectEndTime().before(new Date())) {
                    effectStatus = "\u662f";
                }
                bean.setEffectStatus(effectStatus);
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private Map<Long, List<CategoryEo>> queryCategoryEoByIds(List<Long> categoryIdsResp) {
        CategoryEo queryCategoryEo = new CategoryEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", categoryIdsResp));
        queryCategoryEo.setSqlFilters(sqlFilters);
        List categoryEos = this.categoryDas.select((BaseEo)queryCategoryEo);
        return CollectionUtils.isNotEmpty((Collection)categoryEos) ? categoryEos.stream().collect(Collectors.groupingBy(BaseEo::getId)) : null;
    }

    private Map<Long, List<PolicyEo>> queryPolicyEosByIds(List<Long> policyIdsResp) {
        PolicyEo queryPolicyEo = new PolicyEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", policyIdsResp));
        queryPolicyEo.setSqlFilters(sqlFilters);
        List policyEos = this.policyDas.select((BaseEo)queryPolicyEo);
        return CollectionUtils.isNotEmpty((Collection)policyEos) ? policyEos.stream().collect(Collectors.groupingBy(BaseEo::getId)) : null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditRebateOrder(OrderAuditReqDto reqDto) {
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderModifyReqDtos())) {
            reqDto.getOrderModifyReqDtos().stream().forEach(bean -> {
                OrderEo queryOrderEo = new OrderEo();
                queryOrderEo.setRebateNo(bean.getRebateNo());
                OrderEo orderEo = (OrderEo)this.orderV2Das.selectOne((BaseEo)queryOrderEo);
                if (null == orderEo) {
                    throw new BizException(RebateExceptionCode.REBATE_ORDER_NOT_EXISTS.getCode(), RebateExceptionCode.REBATE_ORDER_NOT_EXISTS.getMsg());
                }
                RebateOrderAuditEo rebateOrderAuditEo = new RebateOrderAuditEo();
                rebateOrderAuditEo.setAuditStatus(reqDto.getAuditStatus());
                rebateOrderAuditEo.setAuditDesc(reqDto.getAuditDesc());
                rebateOrderAuditEo.setAuditTime(new Date());
                rebateOrderAuditEo.setRebateNo(bean.getRebateNo());
                rebateOrderAuditEo.setAuditor(this.context.userName());
                this.rebateOrderAuditDas.insert((BaseEo)rebateOrderAuditEo);
                orderEo.setBalance(bean.getActualAmount());
                if (AuditStatusEnum.PASS.getCode().equals(reqDto.getAuditStatus())) {
                    orderEo.setActualAmount(null != bean.getActualAmount() ? bean.getActualAmount() : orderEo.getRebateAmount());
                    orderEo.setStatus(RebateOrderStatusEnum.WAIT_ISSUE.getCode());
                } else {
                    orderEo.setStatus(RebateOrderStatusEnum.AUDIT_REJECT.getCode());
                }
                orderEo.setAuditTime(new Date());
                this.orderV2Das.updateSelective((BaseEo)orderEo);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void issueRebate(String ids) {
        String[] idList;
        for (String id : idList = ids.split(",")) {
            Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), "rebate_balance_lock:" + id, 2000, 1000, TimeUnit.MILLISECONDS);
            try {
                OrderEo queryOrderEo = new OrderEo();
                queryOrderEo.setId(Long.valueOf(Long.parseLong(id)));
                OrderEo orderEo = (OrderEo)this.orderV2Das.selectOne((BaseEo)queryOrderEo);
                if (Objects.isNull(orderEo)) {
                    throw new BizException(RebateExceptionCode.REBATE_ORDER_NOT_EXISTS.getCode(), RebateExceptionCode.REBATE_ORDER_NOT_EXISTS.getMsg());
                }
                if (StringUtils.isEmpty((CharSequence)orderEo.getRebateAccountNo())) {
                    throw new BizException(RebateExceptionCode.REBATE_ACCOUNT_NOT_EXISTS.getCode(), RebateExceptionCode.REBATE_ACCOUNT_NOT_EXISTS.getMsg());
                }
                orderEo.setBalance(orderEo.getActualAmount());
                if (RebateOrderStatusEnum.ISSUED.getCode().equals(orderEo.getStatus())) continue;
                if (orderEo.getRebateAmount().compareTo(BigDecimal.ZERO) > 0) {
                    this.issueRebate(orderEo, true, orderEo.getType(), orderEo.getRebateNo());
                    continue;
                }
                if (orderEo.getRebateAmount().compareTo(BigDecimal.ZERO) >= 0) continue;
                if ("2".equals(orderEo.getUseEffectType() + "")) {
                    throw new BizException(RebateV2ExceptionCode.DEDUCTION_ORDER_ONLY_LONG_TIME.getCode(), RebateV2ExceptionCode.DEDUCTION_ORDER_ONLY_LONG_TIME.getMsg());
                }
                this.issueRebate(orderEo, false, orderEo.getType(), orderEo.getRebateNo());
            }
            finally {
                this.lockService.unlock(lock);
            }
        }
    }

    private List<OrderEo> dataGrooming(List<OrderEo> data, BigDecimal orderBalance) {
        for (OrderEo eo : data) {
            if (eo.getBalance().add(orderBalance).compareTo(BigDecimal.ZERO) != 0) continue;
            ArrayList<OrderEo> resList = new ArrayList<OrderEo>();
            resList.add(eo);
            return resList;
        }
        return data;
    }

    public void issueRebate(OrderEo orderEo, Boolean isIncrease, Integer rebateType, String rebateDetailBusinessNo) {
        log.info("issueRebate param: orderEo={}", (Object)JSONObject.toJSONString((Object)orderEo));
        List orderEos = this.orderV2Das.selectByUserId(orderEo.getUserId(), isIncrease, orderEo.getCategoryId());
        if (orderEos.size() > 0) {
            List<OrderEo> orderEosData = this.dataGrooming(orderEos, orderEo.getBalance());
            for (OrderEo eo : orderEosData) {
                BigDecimal changeBalance;
                BigDecimal orderEoBalance = orderEo.getBalance();
                BigDecimal lastBalance = orderEo.getBalance().add(eo.getBalance());
                BigDecimal balanceOld = eo.getBalance();
                if (isIncrease.booleanValue()) {
                    if (lastBalance.compareTo(BigDecimal.ZERO) > 0) {
                        orderEo.setBalance(lastBalance);
                        changeBalance = eo.getBalance();
                        eo.setBalance(BigDecimal.ZERO);
                    } else {
                        changeBalance = orderEo.getBalance();
                        orderEo.setBalance(BigDecimal.ZERO);
                        eo.setBalance(lastBalance);
                    }
                } else if (lastBalance.compareTo(BigDecimal.ZERO) > 0) {
                    changeBalance = orderEo.getBalance();
                    orderEo.setBalance(BigDecimal.ZERO);
                    eo.setBalance(lastBalance);
                } else {
                    changeBalance = eo.getBalance();
                    orderEo.setBalance(lastBalance);
                    eo.setBalance(BigDecimal.ZERO);
                }
                this.orderV2Das.update((BaseEo)eo);
                RebateUseLogEo rebateUseLogEo = new RebateUseLogEo();
                rebateUseLogEo.setRebateNo(eo.getRebateNo());
                rebateUseLogEo.setOrderNo(orderEo.getRebateNo());
                rebateUseLogEo.setRebateUseAmount(balanceOld.subtract(eo.getBalance()).negate());
                rebateUseLogEo.setBusinessNo(orderEo.getRebateNo());
                rebateUseLogEo.setChangeType(ChangeTypeEnum.OFFSET_DIKOU.toCode());
                rebateUseLogEo.setOldOrderBalance(balanceOld);
                rebateUseLogEo.setNewOrderBalance(eo.getBalance());
                rebateUseLogEo.setRemark("\u51b2\u62b5\u6298\u6263\u5145\u503c\u5355[" + rebateUseLogEo.getBusinessNo() + "]\u91d1\u989d[" + rebateUseLogEo.getRebateUseAmount() + "]\u5143");
                this.rebateUseLogDas.insert((BaseEo)rebateUseLogEo);
                RebateUseLogEo originalRebateUseLog = new RebateUseLogEo();
                originalRebateUseLog.setRebateNo(orderEo.getRebateNo());
                originalRebateUseLog.setOrderNo(eo.getRebateNo());
                originalRebateUseLog.setRebateUseAmount(orderEoBalance.subtract(orderEo.getBalance()).negate());
                originalRebateUseLog.setBusinessNo(eo.getRebateNo());
                originalRebateUseLog.setChangeType(ChangeTypeEnum.OFFSET_DIKOU.toCode());
                originalRebateUseLog.setOldOrderBalance(orderEoBalance);
                originalRebateUseLog.setNewOrderBalance(orderEo.getBalance());
                originalRebateUseLog.setRemark("\u51b2\u62b5\u6298\u6263\u5145\u503c\u5355[" + originalRebateUseLog.getBusinessNo() + "]\u91d1\u989d[" + originalRebateUseLog.getRebateUseAmount() + "]\u5143");
                this.rebateUseLogDas.insert((BaseEo)originalRebateUseLog);
                if (orderEo.getBalance().compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
        }
        BalanceEo queryBalanceEo = new BalanceEo();
        queryBalanceEo.setRebateAccountNo(orderEo.getRebateAccountNo());
        BalanceEo balanceEo = (BalanceEo)this.balanceDas.selectOne((BaseEo)queryBalanceEo);
        if (ObjectUtils.isEmpty((Object)balanceEo)) {
            throw new BizException(RebateExceptionCode.REBATE_ACCOUNT_NOT_EXISTS.getCode(), RebateExceptionCode.REBATE_ACCOUNT_NOT_EXISTS.getMsg());
        }
        BalanceEo upBalanceEo = new BalanceEo();
        upBalanceEo.setId(balanceEo.getId());
        upBalanceEo.setBalance(balanceEo.getBalance().add(orderEo.getActualAmount()));
        this.balanceDas.updateSelective((BaseEo)upBalanceEo);
        RebateDetailEo rebateDetailEo = new RebateDetailEo();
        rebateDetailEo.setBusinessNo(rebateDetailBusinessNo);
        rebateDetailEo.setRebateAccountNo(orderEo.getRebateAccountNo());
        rebateDetailEo.setUserId(orderEo.getUserId());
        rebateDetailEo.setUserType(orderEo.getUserType());
        rebateDetailEo.setUserName(orderEo.getUserName());
        rebateDetailEo.setChangeAmount(orderEo.getActualAmount());
        rebateDetailEo.setType(rebateType + "");
        if ("1".equals(orderEo.getUseEffectType() + "")) {
            rebateDetailEo.setExpiredTime((Date)null);
        } else {
            rebateDetailEo.setExpiredTime(orderEo.getEffectEndTime());
        }
        rebateDetailEo.setBalanceSnapshot(upBalanceEo.getBalance());
        this.rebateDetailDas.insert((BaseEo)rebateDetailEo);
        orderEo.setStatus(RebateOrderStatusEnum.ISSUED.getCode());
        Calendar now = Calendar.getInstance();
        orderEo.setEffectBeginTime(now.getTime());
        if ("1".equals(orderEo.getUseEffectType() + "")) {
            now.add(1, 100);
            orderEo.setEffectEndTime(DateUtil.setDateEnd((Date)now.getTime()));
        } else if ("2".equals(orderEo.getUseEffectType() + "") && null != orderEo.getUseEffectNum()) {
            now.add(2, orderEo.getUseEffectNum());
            orderEo.setEffectEndTime(DateUtil.setDateEnd((Date)now.getTime()));
        }
        orderEo.setIssueTime(new Date());
        this.orderV2Das.updateSelective((BaseEo)orderEo);
    }

    @Override
    public PageInfo<OrderDetailVO> queryOrderDetailById(Long id, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List result = this.orderV2Das.selectPageListById(id, this.context.tenantId(), this.context.instanceId());
        return new PageInfo(result);
    }

    @Override
    public OrderEo genNegativeOrder(PreSettlementEo preSettlementEo, BalanceNegativeReqDto nagitiveBalanceReqDto) {
        PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(preSettlementEo.getPolicyId());
        OrderEo orderEo = new OrderEo();
        String rebateNo = RebateUtil.generateRebateAccountNo((String)"RB");
        orderEo.setRebateNo(rebateNo);
        orderEo.setType(Integer.valueOf(1));
        orderEo.setStatus(RebateOrderStatusEnum.ISSUED.getCode());
        orderEo.setCategoryId(policyEo.getCategoryId());
        orderEo.setUserId(preSettlementEo.getUserId());
        orderEo.setUserName(preSettlementEo.getUserName());
        orderEo.setUserType(StringUtils.isEmpty((CharSequence)preSettlementEo.getUserType()) ? UserTypeEnum.CUSTOMER.toCode() : preSettlementEo.getUserType());
        orderEo.setUseEffectNum(policyEo.getUseEffectNum());
        orderEo.setUseEffectType(policyEo.getUseEffectType());
        orderEo.setOrganizationId(preSettlementEo.getOrgId());
        orderEo.setOrganizationName(preSettlementEo.getOrgName());
        Calendar now = Calendar.getInstance();
        orderEo.setEffectBeginTime(now.getTime());
        now.add(1, 100);
        if ("1".equals(orderEo.getUseEffectType() + "")) {
            now.add(1, 100);
        } else if ("2".equals(orderEo.getUseEffectType() + "") && null != orderEo.getUseEffectNum()) {
            now.add(2, orderEo.getUseEffectNum());
        }
        orderEo.setEffectEndTime(DateUtil.setDateEnd((Date)now.getTime()));
        orderEo.setRebateAmount(BigDecimal.ZERO.subtract(nagitiveBalanceReqDto.getPayAmount()));
        orderEo.setActualAmount(BigDecimal.ZERO.subtract(nagitiveBalanceReqDto.getPayAmount()));
        orderEo.setBalance(BigDecimal.ZERO.subtract(nagitiveBalanceReqDto.getPayAmount()));
        this.orderV2Das.insert((BaseEo)orderEo);
        return orderEo;
    }

    @Override
    public OrderImportRespDto importOrder(MultipartFile file) {
        List orderImportVoList;
        OrderImportRespDto orderImportResp = new OrderImportRespDto();
        boolean flag = true;
        ArrayList<String> msg = new ArrayList<String>();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setNeedVerfiy(false);
        HashMap<String, CustomerRespDto> customerRespDtoMap = new HashMap<String, CustomerRespDto>();
        HashMap<String, CategoryEo> categoryEoMap = new HashMap<String, CategoryEo>();
        ArrayList<OrderAddReqDto> orderAddReqDtoList = new ArrayList<OrderAddReqDto>();
        new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), RebateOrderImportVo.class, (ImportParams)importParams);
            orderImportVoList = result.getList();
            if (CollectionUtils.isEmpty((Collection)orderImportVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception var17) {
            var17.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        for (int i = 0; i < orderImportVoList.size(); ++i) {
            CategoryEo categoryEo;
            CustomerRespDto customerRespDto;
            RebateOrderImportVo orderImportVo = (RebateOrderImportVo)orderImportVoList.get(i);
            if (StringUtils.isBlank((CharSequence)orderImportVo.getUserCode())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u5ba2\u6237\u7f16\u53f7\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            } else if (!customerRespDtoMap.containsKey(orderImportVo.getUserCode())) {
                RestResponse customerRestResponse = this.customerQueryApi.queryByCode(orderImportVo.getUserCode());
                customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRestResponse);
                if (customerRespDto == null || !Objects.equals(orgId, customerRespDto.getMerchantId())) {
                    msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5ba2\u6237\u7f16\u53f7:" + orderImportVo.getUserCode() + "\u4e0d\u5b58\u5728\u3002");
                    flag = false;
                }
                customerRespDtoMap.put(orderImportVo.getUserCode(), customerRespDto);
            }
            if (StringUtils.isBlank((CharSequence)orderImportVo.getCategoryCode())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u5206\u7c7b\u7f16\u53f7\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            } else if (!categoryEoMap.containsKey(orderImportVo.getCategoryCode())) {
                CategoryEo categoryCondition = new CategoryEo();
                categoryCondition.setCode(orderImportVo.getCategoryCode());
                categoryEo = (CategoryEo)this.categoryDas.selectOne((BaseEo)categoryCondition);
                if (categoryEo == null) {
                    msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5206\u7c7b\u7f16\u53f7:" + orderImportVo.getCategoryCode() + "\u4e0d\u5b58\u5728\u3002");
                    flag = false;
                }
                categoryEoMap.put(orderImportVo.getCategoryCode(), categoryEo);
            }
            OrderAddReqDto orderAddReqDto = new OrderAddReqDto();
            if (StringUtils.isNotBlank((CharSequence)orderImportVo.getUserCode()) && (customerRespDto = (CustomerRespDto)customerRespDtoMap.get(orderImportVo.getUserCode())) != null) {
                orderAddReqDto.setUserId(customerRespDto.getId());
                orderAddReqDto.setUserName(customerRespDto.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)orderImportVo.getCategoryCode()) && (categoryEo = (CategoryEo)categoryEoMap.get(orderImportVo.getCategoryCode())) != null) {
                orderAddReqDto.setCategoryId(categoryEo.getId());
            }
            if (orderImportVo.getRebateAmount() == null) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u6298\u6263\u91d1\u989d\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            }
            if (flag && orderImportVo.getRebateAmount().compareTo(BigDecimal.ZERO) < 0) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u6298\u6263\u91d1\u989d\u4e0d\u5f97\u53d1\u653e\u8d1f\u6570\u3002");
                flag = false;
            }
            if (flag && orderImportVo.getRebateAmount().stripTrailingZeros().scale() > 2) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u6298\u6263\u91d1\u989d\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570\u3002");
                flag = false;
            }
            orderAddReqDto.setRebateAmount(orderImportVo.getRebateAmount());
            if (StringUtils.isBlank((CharSequence)orderImportVo.getEffectEndTime())) {
                orderAddReqDto.setUseEffectType(Integer.valueOf(1));
            } else {
                orderAddReqDto.setUseEffectType(Integer.valueOf(2));
                String date = orderImportVo.getEffectEndTime();
                Date effectEndTime = DateUtil.parseDate((String)(date + " 23:59:59"), (String)DateUtil.EXPORT_PATTERN);
                if (effectEndTime == null) {
                    msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u6309\u7167 yyyy-MM-dd \u6216 yyyy/MM/dd \u683c\u5f0f\u586b\u5199\u3002");
                    flag = false;
                } else {
                    if (effectEndTime.before(new Date())) {
                        msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8fc7\u671f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002");
                        flag = false;
                    }
                    orderAddReqDto.setEffectEndTime(effectEndTime);
                }
            }
            orderAddReqDto.setType(Integer.valueOf(2));
            orderAddReqDto.setRemark(orderImportVo.getRemark());
            orderAddReqDtoList.add(orderAddReqDto);
        }
        if (!flag) {
            orderImportResp.setFlag(Boolean.valueOf(false));
            orderImportResp.setMsg(msg);
            return orderImportResp;
        }
        TransactionStatus transactionStatus = this.platformTransactionManager.getTransaction(this.transactionDefinition);
        try {
            orderAddReqDtoList.forEach(this::addOrder);
            this.platformTransactionManager.commit(transactionStatus);
        }
        catch (BizException var16) {
            this.platformTransactionManager.rollback(transactionStatus);
            throw var16;
        }
        orderImportResp.setFlag(Boolean.valueOf(true));
        return orderImportResp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualAdjustment(OrderAdjustmentReqDto orderAdjustmentReqDto) {
        int balanceRow;
        int orderRow;
        Assert.isTrue((orderAdjustmentReqDto.getAdjustmentAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"100000", (String)"\u8c03\u6574\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getId, (Object)orderAdjustmentReqDto.getId());
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        OrderEo orderEo = (OrderEo)this.orderV2Das.getMapper().selectOne((Wrapper)queryWrapper);
        Assert.notNull((Object)orderEo, (String)"100000", (String)"\u6298\u6263\u5145\u503c\u5355\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)RebateOrderStatusEnum.ISSUED.getCode().equals(orderEo.getStatus()), (String)"100000", (String)"\u5df2\u53d1\u653e\u72b6\u6001\u6298\u6263\u5145\u503c\u5355\u624d\u80fd\u8c03\u6574");
        LambdaQueryWrapper balanceQueryWrapper = new LambdaQueryWrapper();
        balanceQueryWrapper.eq(StdBalanceEo::getRebateAccountNo, (Object)orderEo.getRebateAccountNo());
        balanceQueryWrapper.eq(BaseEo::getDr, (Object)0);
        BalanceEo balanceEo = (BalanceEo)this.balanceDas.getMapper().selectOne((Wrapper)balanceQueryWrapper);
        Assert.notNull((Object)balanceEo, (String)"100000", (String)"\u6298\u6263\u8d26\u6237\u4e0d\u5b58\u5728");
        this.checkAfterBalance(orderEo, balanceEo, orderAdjustmentReqDto);
        if (Objects.equals(orderAdjustmentReqDto.getChangeType(), 1)) {
            orderRow = this.orderV2Das.releaseBalanceById(orderEo.getId(), orderAdjustmentReqDto.getAdjustmentAmount(), orderEo.getVersion(), Integer.valueOf(2));
            balanceRow = this.balanceDas.releaseBalanceByCAS(balanceEo.getId(), balanceEo.getVersion(), orderAdjustmentReqDto.getAdjustmentAmount());
        } else {
            orderRow = this.orderV2Das.useBalanceByCAS(orderEo.getId(), orderEo.getVersion(), orderAdjustmentReqDto.getAdjustmentAmount(), Integer.valueOf(2));
            balanceRow = this.balanceDas.useBalanceByCAS(balanceEo.getUserId(), balanceEo.getVersion(), orderAdjustmentReqDto.getAdjustmentAmount());
        }
        Assert.isTrue((orderRow == 1 ? 1 : 0) != 0, (String)"100000", (String)"\u5145\u503c\u5355\u66f4\u65b0\u5931\u8d25");
        Assert.isTrue((balanceRow == 1 ? 1 : 0) != 0, (String)"100000", (String)"\u6298\u6263\u8d26\u6237\u66f4\u65b0\u5931\u8d25");
        this.saveLog(orderEo, balanceEo, orderAdjustmentReqDto);
    }

    private void saveLog(OrderEo orderEo, BalanceEo balanceEo, OrderAdjustmentReqDto orderAdjustmentReqDto) {
        BigDecimal adjustmentAmount = orderAdjustmentReqDto.getAdjustmentAmount();
        String changeType = ChangeTypeEnum.MANUAL_ADJUSTMENT_ADD.toCode();
        String type = RebateTypeEnum.MANUAL_ADJUSTMENT_ADD.getType() + "";
        if (Objects.equals(orderAdjustmentReqDto.getChangeType(), 2)) {
            adjustmentAmount = adjustmentAmount.negate();
            changeType = ChangeTypeEnum.MANUAL_ADJUSTMENT_SUB.toCode();
            type = RebateTypeEnum.MANUAL_ADJUSTMENT_SUB.getType() + "";
        }
        RebateUseLogEo rebateUseLogEo = new RebateUseLogEo();
        rebateUseLogEo.setRebateNo(orderEo.getRebateNo());
        rebateUseLogEo.setOrderNo("");
        rebateUseLogEo.setRebateUseAmount(adjustmentAmount);
        rebateUseLogEo.setBusinessNo("");
        rebateUseLogEo.setChangeType(changeType);
        rebateUseLogEo.setOldOrderBalance(orderEo.getBalance());
        rebateUseLogEo.setNewOrderBalance(orderEo.getBalance().add(adjustmentAmount));
        rebateUseLogEo.setRemark(orderAdjustmentReqDto.getRemark());
        this.rebateUseLogDas.insert((BaseEo)rebateUseLogEo);
        RebateDetailEo rebateDetailEo = new RebateDetailEo();
        rebateDetailEo.setRebateAccountNo(balanceEo.getRebateAccountNo());
        rebateDetailEo.setUserId(balanceEo.getUserId());
        rebateDetailEo.setUserName(balanceEo.getUserName());
        rebateDetailEo.setUserType(balanceEo.getUserType());
        rebateDetailEo.setChangeAmount(adjustmentAmount);
        rebateDetailEo.setBalanceSnapshot(balanceEo.getBalance().add(adjustmentAmount));
        rebateDetailEo.setType(type);
        rebateDetailEo.setBusinessNo(orderEo.getRebateNo());
        rebateDetailEo.setRemark(orderAdjustmentReqDto.getRemark());
        this.rebateDetailDas.insert((BaseEo)rebateDetailEo);
    }

    private void checkAfterBalance(OrderEo orderEo, BalanceEo balanceEo, OrderAdjustmentReqDto orderAdjustmentReqDto) {
        if (Objects.equals(orderAdjustmentReqDto.getChangeType(), 2)) {
            Assert.isTrue((orderEo.getBalance().compareTo(orderAdjustmentReqDto.getAdjustmentAmount()) >= 0 ? 1 : 0) != 0, (String)"100000", (String)"\u5145\u503c\u5355\u8c03\u6574\u540e\u5269\u4f59\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
            Assert.isTrue((balanceEo.getBalance().compareTo(orderAdjustmentReqDto.getAdjustmentAmount()) >= 0 ? 1 : 0) != 0, (String)"100000", (String)"\u6298\u6263\u8d26\u6237\u8c03\u6574\u540e\u5269\u4f59\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        }
    }

    @Override
    public RebateOrderCountRespDto queryOrderCount(RebateOrderCountReqDto reqDto) {
        RebateOrderCountRespDto rebateOrderCountRespDto = this.orderV2Das.queryOrderCount(reqDto);
        if (rebateOrderCountRespDto == null) {
            rebateOrderCountRespDto = new RebateOrderCountRespDto();
        }
        rebateOrderCountRespDto.setUsedBalance(rebateOrderCountRespDto.getOrderAmount().subtract(rebateOrderCountRespDto.getBalance()));
        return rebateOrderCountRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> dealNegateMoney(RebateOrderNoOffsetReqDto reqDto) {
        ArrayList<String> resList = new ArrayList<String>();
        logger.info("\u5f00\u59cb\u8fdb\u884c\u6298\u6263\u4fee\u6570:\u8bf7\u6c42\u53c2\u6570\u4e3a={}", (Object)reqDto);
        List waitDealEoList = this.orderV2Das.dealNegateMoney(reqDto);
        if (CollectionUtils.isEmpty((Collection)waitDealEoList)) {
            resList.add("\u672a\u8fc7\u671f\u7684\u8d1f\u6570\u91d1\u989d\u6298\u6263\u5355\u4f59\u989d\u5df2\u5168\u90e8\u5904\u7406\u5b8c\u6bd5\uff1b");
        }
        Map<Long, Map<String, List<OrderEo>>> userRelMap = waitDealEoList.stream().collect(Collectors.groupingBy(StdOrderEo::getUserId, Collectors.groupingBy(e -> {
            if (BigDecimal.ZERO.compareTo(e.getBalance()) > 0) {
                return "F";
            }
            return "Z";
        })));
        for (Map.Entry<Long, Map<String, List<OrderEo>>> entry : userRelMap.entrySet()) {
            Map<String, List<OrderEo>> zhenfuMap = entry.getValue();
            List<OrderEo> fuOrderEoList = zhenfuMap.get("F");
            List<OrderEo> zhenOrderEoList = zhenfuMap.get("Z");
            if (CollectionUtils.isEmpty(fuOrderEoList)) {
                resList.add("\u6298\u6263\u8d26\u6237userId\u3010 " + entry.getKey() + " \u3011\u4e0d\u5b58\u5728\u8d1f\u91d1\u989d\u5145\u503c\u5355\uff1b");
                break;
            }
            if (CollectionUtils.isEmpty(zhenOrderEoList)) {
                resList.add("\u6298\u6263\u8d26\u6237userId\u3010 " + entry.getKey() + " \u3011\u7684\u8d1f\u91d1\u989d\u5145\u503c\u5355\u65e0\u5bf9\u5e94\u6b63\u6570\u5145\u503c\u5355\u8fdb\u884c\u76f8\u62b5");
                break;
            }
            for (OrderEo fuEo : fuOrderEoList) {
                if (ObjectUtils.isEmpty((Object)fuEo.getBalance())) {
                    resList.add("\u6298\u6263\u8d26\u6237userId\u3010 " + entry.getKey() + " \u3011\u7684\u8d1f\u91d1\u989d\u5145\u503c\u5355\u3010" + fuEo.getRebateNo() + "\u3011\u5269\u4f59\u4f59\u989dbalance\u4e3a\u7a7a\uff0c\u5904\u7406\u5931\u8d25\u8bf7\u4eba\u5de5\u6392\u67e5");
                    continue;
                }
                List<OrderEo> dayuZeroList = zhenOrderEoList.stream().filter(e -> e.getBalance().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
                resList.add("\u6298\u6263\u8d26\u6237userId\u3010 " + entry.getKey() + " \u3011=" + this.balanceV2Service.judgeSumType(fuEo, dayuZeroList, resList));
            }
        }
        return resList;
    }
}

