package com.yx.tcbj.center.trade.api;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 厂家发货记录服务接口
*
* @author by_liusong
* @since 2022-04-21
*/
@Api(tags = {"厂家发货记录服务"})
@FeignClient(
    name = "yundt-cube-center-trade",
    path = "/v1/deliveryOrder",
    url = "${yundt.cube.center.trade.api:}"
)
public interface IDeliveryOrderApi {

    /**
    * 新增厂家发货记录
    *
    * @param addReqDto 厂家发货记录请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增厂家发货记录", notes = "新增厂家发货记录")
    RestResponse<Long> addDeliveryOrder(@RequestBody com.dtyunxi.tcbj.center.trade.api.dto.request.DeliveryOrderLogisticsReqDto addReqDto);

    /**
    * 修改厂家发货记录
    *
    * @param modifyReqDto 厂家发货记录请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改厂家发货记录", notes = "修改厂家发货记录")
    RestResponse<Void> modifyDeliveryOrder(@RequestBody com.dtyunxi.tcbj.center.trade.api.dto.request.DeliveryOrderLogisticsReqDto modifyReqDto);

    /**
    * 删除厂家发货记录
    *
    * @param ids        厂家发货记录删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除厂家发货记录", notes = "删除厂家发货记录")
    RestResponse<Void> removeDeliveryOrder(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
