/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdReturnEo;
import com.yx.tcbj.center.trade.api.dto.request.UpdateReturnReqDto;
import com.yx.tcbj.center.trade.api.dto.response.OrderV2025Dto;
import com.yx.tcbj.center.trade.biz.service.IReturnV2Service;
import com.yx.tcbj.center.trade.dao.eo.OrderV2025Eo;
import com.yx.tcbj.center.trade.dao.eo.ReturnV2025Eo;
import com.yx.tcbj.center.trade.dao.mapper.OrderV2025Mapper;
import com.yx.tcbj.center.trade.dao.mapper.ReturnV2025Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReturnV2ServiceImpl
implements IReturnV2Service {
    private static final Logger log = LoggerFactory.getLogger(ReturnV2ServiceImpl.class);
    @Autowired
    private ReturnV2025Mapper returnMapper;
    @Autowired
    private OrderV2025Mapper orderV2025Mapper;

    @Override
    public void updateByTradeNo(UpdateReturnReqDto reqDto) {
        log.info("\u3010\u66f4\u65b0\u9000\u8d27\u5355\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)reqDto);
        ReturnV2025Eo updatedReturnEo = new ReturnV2025Eo();
        updatedReturnEo.setWarehouseCode(reqDto.getWarehouseCode());
        updatedReturnEo.setJztDistributeFlag(reqDto.getJztDistributeFlag());
        this.returnMapper.update((Object)updatedReturnEo, (Wrapper)new LambdaQueryWrapper().eq(StdReturnEo::getReturnNo, (Object)reqDto.getTradeNo()));
        log.info("\u3010\u66f4\u65b0\u9000\u8d27\u5355\u5b8c\u6210\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)reqDto);
    }

    @Override
    public void updateOrderByTradeNo(OrderV2025Dto reqDto) {
        log.info("\u3010\u66f4\u65b0\u9500\u552e\u5355\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)reqDto);
        OrderV2025Eo updatedEo = new OrderV2025Eo();
        updatedEo.setJztDistributeFlag(reqDto.getJztDistributeFlag());
        this.orderV2025Mapper.update((Object)updatedEo, (Wrapper)new LambdaQueryWrapper().eq(StdOrderEo::getOrderNo, (Object)reqDto.getOrderNo()));
        log.info("\u3010\u66f4\u65b0\u9500\u552e\u5b8c\u6210\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)reqDto);
    }

    @Override
    public ReturnV2025Eo queryReturnByReturnNo(String returnNo) {
        log.info("\u3010\u67e5\u8be2\u9000\u8d27\u5355\u3011\u9000\u8d27\u5355\u53f7\uff1a{}", (Object)returnNo);
        ReturnV2025Eo returnEo = (ReturnV2025Eo)this.returnMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(StdReturnEo::getReturnNo, (Object)returnNo));
        log.info("\u3010\u67e5\u8be2\u9000\u8d27\u5355\u5b8c\u6210\u3011\u9000\u8d27\u5355\u53f7\uff1a{}\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)returnNo, (Object)JSONObject.toJSONString((Object)returnEo));
        return returnEo;
    }

    @Override
    public OrderV2025Eo queryOrderByOrderNo(String orderNo) {
        log.info("\u3010\u67e5\u8be2\u8ba2\u5355\u3011\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNo);
        OrderV2025Eo orderEo = (OrderV2025Eo)this.orderV2025Mapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(StdOrderEo::getOrderNo, (Object)orderNo));
        log.info("\u3010\u67e5\u8be2\u8ba2\u5355\u5b8c\u6210\u3011\u8ba2\u5355\u53f7\uff1a{}\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)orderNo, (Object)JSONObject.toJSONString((Object)orderEo));
        return orderEo;
    }
}

