/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.collector.executor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.client.collector.config.TransactionTrackCollectorConfigVo;
import com.dtyunxi.cube.component.track.client.collector.executor.TrackDataCollectorScheduleExecutor;
import com.dtyunxi.cube.component.track.client.collector.executor.TrackDataDistributeExecutor;
import com.dtyunxi.cube.component.track.client.collector.zipkin.api.ZipkinApi;
import com.dtyunxi.cube.component.track.client.collector.zipkin.vo.ZipKinSpanVoCollect;
import com.dtyunxi.cube.component.track.commons.constant.CollectExecutorMethodType;
import com.dtyunxi.cube.component.track.commons.vo.TransactionNodeRecordVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionNodeVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import com.dtyunxi.cube.component.track.commons.vo.collect.TrackCollectResultVo;
import com.dtyunxi.cube.component.track.commons.vo.collect.TransactionCollectBaseVo;
import com.dtyunxi.cube.module.track.service.ITransactionNodeRecordOptService;
import com.dtyunxi.cube.module.track.service.ITransactionNodeRegisterService;
import com.dtyunxi.cube.module.track.service.ITransactionRegisterService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.api.IPcpDictApi;
import com.yunxi.dg.base.center.basicdata.enums.DictEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public class AsyncTrackDataDistributeExecutor
implements TrackDataDistributeExecutor,
TrackDataCollectorScheduleExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AsyncTrackDataDistributeExecutor.class);
    private static List<TransactionCollectBaseVo> FAIL_LIST = new LinkedList<TransactionCollectBaseVo>();
    private static List<TransactionCollectBaseVo> TMP_FAIL_LIST = new LinkedList<TransactionCollectBaseVo>();
    private static Map<CollectExecutorMethodType, Queue<TransactionCollectBaseVo>> DATA_COLLECT_MAP = new ConcurrentHashMap<CollectExecutorMethodType, Queue<TransactionCollectBaseVo>>();
    @Resource
    private TransactionTrackCollectorConfigVo transactionTrackCollectorConfigVo;
    @Resource
    private TransactionTrackCollectorConfigVo transactionTrackConfigVo;
    @Resource
    private ITransactionRegisterService transactionRegisterService;
    @Resource
    private ITransactionNodeRegisterService transactionNodeRegisterService;
    @Resource
    private ITransactionNodeRecordOptService transactionNodeRecordOptService;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ZipkinApi zipkinApi;
    private static final ReentrantLock LOCK = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public <T extends TransactionCollectBaseVo> TrackCollectResultVo distributeData(T data) {
        if (data.getCollectExecutorMethodType() == null) {
            logger.debug("featureCollect\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570data={}", (Object)JSON.toJSONString(data));
            return null;
        }
        TrackCollectResultVo trackCollectResultVo = new TrackCollectResultVo();
        String config = this.loadConfig();
        if (!Objects.equals(config, "1")) {
            logger.info("\u65e5\u5fd7\u672a\u5f00\u542f:{}", (Object)config);
            return trackCollectResultVo;
        }
        Queue transactionCollectBaseVos = DATA_COLLECT_MAP.get(data.getCollectExecutorMethodType());
        if (transactionCollectBaseVos == null) {
            AsyncTrackDataDistributeExecutor asyncTrackDataDistributeExecutor = this;
            synchronized (asyncTrackDataDistributeExecutor) {
                transactionCollectBaseVos = DATA_COLLECT_MAP.computeIfAbsent(data.getCollectExecutorMethodType(), k -> new LinkedBlockingDeque(this.transactionTrackCollectorConfigVo.getTrackAsyncMaxCollectCount()));
            }
        }
        trackCollectResultVo.setData(data);
        transactionCollectBaseVos.add(data);
        return trackCollectResultVo;
    }

    private String loadConfig() {
        String key = DictEnum.OPENLOG_ENBALE.getGroupCode() + ":" + DictEnum.OPENLOG_ENBALE.getCode();
        return Optional.ofNullable(this.cacheService.getCache(DictEnum.OPENLOG_ENBALE.getGroupCode(), key, String.class)).filter(StringUtils::isNotBlank).orElseGet(() -> {
            String s = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode(DictEnum.OPENLOG_ENBALE.getGroupCode(), DictEnum.OPENLOG_ENBALE.getCode()).getData()).map(DictDto::getValue).orElse("");
            this.cacheService.setCache(DictEnum.OPENLOG_ENBALE.getGroupCode(), key, (Object)s);
            return s;
        });
    }

    public List<TransactionCollectBaseVo> pollTransactionBaseVo(CollectExecutorMethodType collectExecutorMethodType, int pollNum) {
        TransactionCollectBaseVo transactionCollectBaseVo;
        Queue<TransactionCollectBaseVo> transactionCollectBaseVos = DATA_COLLECT_MAP.get(collectExecutorMethodType);
        if (CollectionUtils.isEmpty(transactionCollectBaseVos)) {
            return null;
        }
        ArrayList transactionCollectBaseVoList = Lists.newArrayList();
        for (int i = 0; i < pollNum && (transactionCollectBaseVo = transactionCollectBaseVos.poll()) != null; ++i) {
            transactionCollectBaseVoList.add(transactionCollectBaseVo);
        }
        return transactionCollectBaseVoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void collectDataAndExecute() {
        block19: {
            boolean lockFlag = true;
            try {
                if (LOCK.tryLock()) {
                    List<TransactionCollectBaseVo> baseVos = this.collectData();
                    try {
                        if (CollectionUtils.isNotEmpty(FAIL_LIST)) {
                            for (TransactionCollectBaseVo baseVo : FAIL_LIST) {
                                try {
                                    this.executeTransferData(baseVo);
                                }
                                catch (Exception e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                    TMP_FAIL_LIST.add(baseVo);
                                }
                            }
                            FAIL_LIST.clear();
                        }
                        while (CollectionUtils.isNotEmpty(baseVos)) {
                            for (TransactionCollectBaseVo baseVo : baseVos) {
                                try {
                                    this.executeTransferData(baseVo);
                                }
                                catch (Exception e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                    TMP_FAIL_LIST.add(baseVo);
                                }
                            }
                            baseVos.clear();
                            baseVos = this.collectData();
                        }
                        break block19;
                    }
                    finally {
                        if (TMP_FAIL_LIST.size() > 0 && FAIL_LIST.size() + TMP_FAIL_LIST.size() <= this.transactionTrackConfigVo.getTrackAsyncFailCollectCount()) {
                            FAIL_LIST.addAll(TMP_FAIL_LIST);
                        }
                        TMP_FAIL_LIST.clear();
                    }
                }
                lockFlag = false;
                logger.debug("\u3010DefaultTrackDataCollectorExecutor\u3011\u6709\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u6682\u4e0d\u5904\u7406");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (lockFlag) {
                    LOCK.unlock();
                }
                logger.debug("\u3010DefaultTrackDataCollectorExecutor\u3011\u4e8b\u52a1\u8ddf\u8e2a\u94fe\u8def\u6570\u636e\u4efb\u52a1\u7ed3\u675f");
            }
        }
    }

    private void executeTransferData(TransactionCollectBaseVo transactionCollectBaseVo) {
        if (transactionCollectBaseVo == null) {
            logger.debug("executeTransferData\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
            return;
        }
        switch (transactionCollectBaseVo.getCollectExecutorMethodType()) {
            case TT_SAVE_API: {
                this.registerTransaction(transactionCollectBaseVo);
                break;
            }
            case TT_MODIFY_API: {
                this.modifyTransaction(transactionCollectBaseVo);
                break;
            }
            case TN_SAVE_API: {
                this.registerTransactionNode(transactionCollectBaseVo);
                break;
            }
            case TN_MODIFY_API: {
                this.modifyTransactionNode(transactionCollectBaseVo);
                break;
            }
            case TNR_SAVE_API: {
                this.saveTransactionNodeRecord(transactionCollectBaseVo);
                break;
            }
            case TNR_MODIFY_API: {
                this.modifyTransactionNodeRecord(transactionCollectBaseVo);
                break;
            }
            case ZIPKIN_POST_API: {
                this.spansPost(transactionCollectBaseVo);
                break;
            }
            default: {
                logger.error("executeTransferData\u65e0\u6548\u5f02\u6b65\u6267\u884c\u65b9\u6cd5\u7c7b\u578b");
            }
        }
    }

    public List<TransactionCollectBaseVo> collectData() {
        LinkedList transactionCollectBaseVos = Lists.newLinkedList();
        Arrays.stream(CollectExecutorMethodType.values()).sorted(Comparator.comparingInt(o -> o.code)).forEach(featureExecutorMethodType -> {
            List<TransactionCollectBaseVo> baseVos = this.pollTransactionBaseVo((CollectExecutorMethodType)featureExecutorMethodType, this.transactionTrackConfigVo.getTrackAsyncTransferCount());
            if (CollectionUtils.isNotEmpty(baseVos)) {
                transactionCollectBaseVos.addAll(baseVos);
            }
        });
        return transactionCollectBaseVos;
    }

    private void registerTransaction(TransactionCollectBaseVo transactionCollectBaseVo) {
        if (transactionCollectBaseVo.getData() instanceof TransactionVo) {
            this.transactionRegisterService.registerTransaction((TransactionVo)transactionCollectBaseVo.getData());
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", transactionCollectBaseVo.getClass(), TransactionVo.class);
        }
    }

    private void modifyTransaction(TransactionCollectBaseVo transactionCollectBaseVo) {
        if (transactionCollectBaseVo.getData() instanceof TransactionVo) {
            this.transactionRegisterService.modifyTransaction((TransactionVo)transactionCollectBaseVo.getData());
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", transactionCollectBaseVo.getClass(), TransactionVo.class);
        }
    }

    private void modifyTransactionNode(TransactionCollectBaseVo transactionCollectBaseVo) {
        if (transactionCollectBaseVo.getData() instanceof TransactionNodeVo) {
            this.transactionNodeRegisterService.modifyTransactionNode((TransactionNodeVo)transactionCollectBaseVo.getData());
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", transactionCollectBaseVo.getClass(), TransactionNodeVo.class);
        }
    }

    private void registerTransactionNode(TransactionCollectBaseVo transactionCollectBaseVo) {
        if (transactionCollectBaseVo.getData() instanceof TransactionNodeVo) {
            this.transactionNodeRegisterService.registerTransactionNode((TransactionNodeVo)transactionCollectBaseVo.getData());
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", transactionCollectBaseVo.getClass(), TransactionNodeVo.class);
        }
    }

    private void modifyTransactionNodeRecord(TransactionCollectBaseVo transactionCollectBaseVo) {
        if (transactionCollectBaseVo.getData() instanceof TransactionNodeRecordVo) {
            this.transactionNodeRecordOptService.modifyTransactionNodeRecord((TransactionNodeRecordVo)transactionCollectBaseVo.getData());
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", transactionCollectBaseVo.getClass(), TransactionNodeRecordVo.class);
        }
    }

    private void saveTransactionNodeRecord(TransactionCollectBaseVo transactionCollectBaseVo) {
        if (transactionCollectBaseVo.getData() instanceof TransactionNodeRecordVo) {
            this.transactionNodeRecordOptService.saveTransactionNodeRecord((TransactionNodeRecordVo)transactionCollectBaseVo.getData());
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", transactionCollectBaseVo.getClass(), TransactionNodeRecordVo.class);
        }
    }

    private void spansPost(TransactionCollectBaseVo transactionCollectBaseVo) {
        if (transactionCollectBaseVo instanceof ZipKinSpanVoCollect) {
            this.zipkinApi.spansPost(((ZipKinSpanVoCollect)transactionCollectBaseVo).getSpans());
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", transactionCollectBaseVo.getClass(), ZipKinSpanVoCollect.class);
        }
    }
}

