/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.executor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.client.build.TransactionNodeVoBuilder;
import com.dtyunxi.cube.component.track.client.config.TransactionTrackClientConfigVo;
import com.dtyunxi.cube.component.track.client.executor.TrackNodeExecuteUtils;
import com.dtyunxi.cube.component.track.client.executor.TransactionAsync;
import com.dtyunxi.cube.component.track.client.executor.TransactionTrackNodeExecutor;
import com.dtyunxi.cube.component.track.commons.constant.CollectExecutorMethodType;
import com.dtyunxi.cube.component.track.commons.constant.TransactionNodeStatusEnum;
import com.dtyunxi.cube.component.track.commons.constant.TransactionNodeTypeEnum;
import com.dtyunxi.cube.component.track.commons.exception.TransactionNodeException;
import com.dtyunxi.cube.component.track.commons.utils.CommonUtils;
import com.dtyunxi.cube.component.track.commons.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionBaseVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionNodeRecordVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionNodeVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionTrackNodeResult;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import com.dtyunxi.cube.module.track.service.ITransactionNodeRecordOptService;
import com.dtyunxi.cube.module.track.service.ITransactionNodeRegisterService;
import com.dtyunxi.rest.RestResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class DefaultTransactionTrackNodeExecutor
implements TransactionTrackNodeExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTransactionTrackNodeExecutor.class);
    @Resource
    private ITransactionNodeRegisterService transactionNodeRegisterService;
    @Resource
    private ITransactionNodeRecordOptService transactionNodeRecordService;
    @Resource
    private TransactionTrackClientConfigVo transactionTrackClientConfigVo;
    @Resource
    private TransactionAsync transactionAsync;
    @Value(value="${dtyunxi.env.module:myapp-name}")
    private String appName;
    @Value(value="${cube.global.profile:dev}")
    private String env;

    @Override
    public Object transactionNodeActionAround(ProceedingJoinPoint point, TransactionNodeTypeEnum transactionNodeTypeEnum) throws Throwable {
        logger.debug("\u3010transactionNodeActionAop.around\u3011class={}\uff0cmethod={}", (Object)point.getSignature().getDeclaringTypeName(), (Object)point.getSignature().getName());
        point.getArgs();
        TransactionTrackNodeResult transactionTrackNodeResult = this.transactionNodeAction(point, transactionNodeTypeEnum);
        if (transactionTrackNodeResult == null) {
            return point.proceed();
        }
        logger.debug(">>>>>>>>>>>>>>after.transactionNodeAction:{}", (Object)JSON.toJSONString((Object)ServerContextUtils.getKeys()));
        Object obj = null;
        Throwable exception = null;
        try {
            obj = point.proceed();
        }
        catch (Throwable throwable) {
            exception = throwable;
            throw throwable;
        }
        finally {
            this.transactionNodeEnd(point, transactionTrackNodeResult, obj, exception);
            logger.debug(">>>>>>>>>>>>>>after.transactionNodeEnd:{}", (Object)JSON.toJSONString((Object)ServerContextUtils.getKeys()));
        }
        return obj;
    }

    @Override
    public TransactionTrackNodeResult transactionNodeAction(ProceedingJoinPoint point, TransactionNodeTypeEnum transactionNodeTypeEnum) {
        logger.debug("\u3010TransactionTrackNodeExecutor.transactionNodeAction\u3011class.method={}.{}", (Object)point.getSignature().getDeclaringTypeName(), (Object)point.getSignature().getName());
        TransactionTrackNodeResult trackNodeResult = null;
        try {
            TransactionNodeVoBuilder builder = new TransactionNodeVoBuilder();
            TransactionVo overallTransaction = ServerContextUtils.loadTransactionVoByContext((String)"transaction.overall", (String)"transaction.overall.json");
            TransactionVo processTransaction = ServerContextUtils.loadTransactionVoByContext((String)"transaction.process", (String)"transaction.process.json");
            if (overallTransaction == null || processTransaction == null) {
                logger.debug("\u7f3a\u5c11\u5fc5\u8981\u4e0a\u4e0b\u6587\u6570\u636e\uff0c\u7ed3\u675f\u8ddf\u8e2a\u8fc7\u7a0b");
                return null;
            }
            TransactionNodeVo transactionNodeVo = builder.build(point, overallTransaction, processTransaction, transactionNodeTypeEnum, this.env, this.appName);
            logger.debug("\u3010TransactionTrackExecutor.builder.vo\u3011vo={}", (Object)JSON.toJSONString((Object)transactionNodeVo));
            if (this.transactionTrackClientConfigVo.isAsyncCollect()) {
                transactionNodeVo = (TransactionNodeVo)this.transactionAsync.registerTransactionExecuteVo(CollectExecutorMethodType.TN_SAVE_API, (TransactionBaseVo)transactionNodeVo);
            } else {
                this.transactionNodeRegisterService.registerTransactionNode(transactionNodeVo);
            }
            trackNodeResult = this.buildTransactionTrackNodeResultAndResetContext(transactionNodeVo, overallTransaction, processTransaction);
            this.saveTransactionNodeRecord(point, trackNodeResult);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return trackNodeResult;
    }

    private void saveTransactionNodeRecord(ProceedingJoinPoint point, TransactionTrackNodeResult trackNodeResult) throws NoSuchMethodException, IllegalAccessException {
        TransactionNodeRecordVo transactionNodeRecordVo = this.buildTransactionNodeRecordVo(point, trackNodeResult);
        if (this.transactionTrackClientConfigVo.isAsyncCollect()) {
            transactionNodeRecordVo = (TransactionNodeRecordVo)this.transactionAsync.registerTransactionExecuteVo(CollectExecutorMethodType.TNR_SAVE_API, (TransactionBaseVo)transactionNodeRecordVo);
        } else {
            Long recordId = this.transactionNodeRecordService.saveTransactionNodeRecord(transactionNodeRecordVo);
            transactionNodeRecordVo.setId(recordId);
        }
        trackNodeResult.setTransactionNodeRecordVo(transactionNodeRecordVo);
    }

    private TransactionTrackNodeResult buildTransactionTrackNodeResultAndResetContext(TransactionNodeVo transactionNodeVo, TransactionVo overallTransaction, TransactionVo processTransaction) {
        TransactionTrackNodeResult trackNodeResult = new TransactionTrackNodeResult();
        trackNodeResult.setTransactionNodeVo(transactionNodeVo);
        trackNodeResult.setOverallTransaction(overallTransaction);
        trackNodeResult.setProcessTransaction(processTransaction);
        trackNodeResult.setHadTransactionBefore(true);
        return trackNodeResult;
    }

    @Override
    public void transactionNodeEnd(ProceedingJoinPoint point, TransactionTrackNodeResult result, Object obj, Throwable throwable) {
        try {
            logger.debug("\u3010TransactionTrackNodeExecutor.transactionNodeEnd\u3011result={}\uff0cobj={}, isThrowable={}", new Object[]{JSON.toJSONString((Object)result), JSON.toJSONString((Object)obj), throwable != null});
            if (throwable != null) {
                logger.debug("\u3010TransactionTrackNodeExecutor.transactionNodeEnd\u3011throwable:" + throwable.getMessage(), throwable);
            }
            Date endTime = new Date();
            Long curTime = endTime.getTime() - result.getTransactionNodeVo().getAccessTime().getTime();
            TransactionNodeVo updateTransactionNodeVo = this.buildUpdateTransactionNodeVo(result.getTransactionNodeVo(), obj, throwable);
            if (this.transactionTrackClientConfigVo.isAsyncCollect()) {
                this.transactionAsync.modifyTransactionExecuteVo(CollectExecutorMethodType.TN_MODIFY_API, (TransactionBaseVo)updateTransactionNodeVo);
            } else {
                this.transactionNodeRegisterService.modifyTransactionNode(updateTransactionNodeVo);
            }
            this.modifyTransactionNodeExecuteRecord(updateTransactionNodeVo, point, result, obj, throwable, endTime, curTime);
        }
        catch (Throwable t1) {
            logger.error(t1.getMessage(), t1);
        }
    }

    private void modifyTransactionNodeExecuteRecord(TransactionNodeVo updateTransactionNodeVo, ProceedingJoinPoint point, TransactionTrackNodeResult result, Object returnObj, Throwable throwable, Date endTime, Long curTime) throws IOException, NoSuchFieldException, IllegalAccessException {
        TransactionNodeRecordVo updateTransactionNodeRecordVo = new TransactionNodeRecordVo();
        updateTransactionNodeRecordVo.setId(result.getTransactionNodeRecordVo().getId());
        updateTransactionNodeRecordVo.setNodeStatus(updateTransactionNodeVo.getNodeStatus());
        updateTransactionNodeRecordVo.setEndTime(endTime);
        if (returnObj != null) {
            try {
                updateTransactionNodeRecordVo.setNodeApiResponse(JSON.toJSONString((Object)returnObj));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                updateTransactionNodeRecordVo.setNodeApiResponse(Objects.toString(returnObj));
            }
        }
        if (throwable != null) {
            updateTransactionNodeRecordVo.setNodeApiExceptionMessage(throwable.getMessage());
            updateTransactionNodeRecordVo.setBizErrorException(throwable);
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                throwable.printStackTrace(new PrintStream(out));
                updateTransactionNodeRecordVo.setNodeApiExceptionStack(out.toString());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                updateTransactionNodeRecordVo.setNodeApiExceptionStack("stack\u8f6c\u6362\u5931\u8d25");
            }
            if (throwable instanceof TransactionNodeException) {
                updateTransactionNodeRecordVo.setBizErrorMessage(JSON.toJSONString((Object)((TransactionNodeException)throwable).getErrorObj()));
            }
        }
        TrackNodeExecuteUtils.catchAndSavePointMethodResultAnnotation(updateTransactionNodeRecordVo, point, returnObj);
        if (this.transactionTrackClientConfigVo.isAsyncCollect()) {
            this.transactionAsync.modifyTransactionExecuteVo(CollectExecutorMethodType.TNR_MODIFY_API, (TransactionBaseVo)updateTransactionNodeRecordVo);
        } else {
            this.transactionNodeRecordService.modifyTransactionNodeRecord(updateTransactionNodeRecordVo);
        }
    }

    private TransactionNodeRecordVo buildTransactionNodeRecordVo(ProceedingJoinPoint point, TransactionTrackNodeResult result) throws NoSuchMethodException, IllegalAccessException {
        TransactionNodeRecordVo transactionNodeRecordVo = new TransactionNodeRecordVo();
        transactionNodeRecordVo.setNodeStatus(Integer.valueOf(TransactionNodeStatusEnum.N_ACCEPT.getCode()));
        transactionNodeRecordVo.setNodeId(result.getTransactionNodeVo().getId());
        transactionNodeRecordVo.setNodeCode(result.getTransactionNodeVo().getNodeCode());
        transactionNodeRecordVo.setAccessTime(result.getTransactionNodeVo().getAccessTime());
        transactionNodeRecordVo.setEnv(result.getTransactionNodeVo().getEnv());
        TrackNodeExecuteUtils.catchAndSavePointMethodParamAnnotation(transactionNodeRecordVo, point);
        try {
            transactionNodeRecordVo.setNodeApiMethodParams(JSON.toJSONString((Object)point.getArgs()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            transactionNodeRecordVo.setNodeApiMethodParams(Objects.toString(point.getArgs()));
        }
        return transactionNodeRecordVo;
    }

    private TransactionNodeVo buildUpdateTransactionNodeVo(TransactionNodeVo transactionNodeVo, Object obj, Throwable throwable) {
        TransactionNodeVo updateTransactionVo = new TransactionNodeVo();
        updateTransactionVo.setId(transactionNodeVo.getId());
        if (throwable != null) {
            updateTransactionVo.setNodeStatus(Integer.valueOf(TransactionNodeStatusEnum.N_ERROR.getCode()));
        } else if (obj instanceof RestResponse) {
            if (CommonUtils.isSuccess((RestResponse)((RestResponse)obj))) {
                updateTransactionVo.setNodeStatus(Integer.valueOf(TransactionNodeStatusEnum.N_SUCCESS.getCode()));
            } else {
                updateTransactionVo.setNodeStatus(Integer.valueOf(TransactionNodeStatusEnum.N_FAIL.getCode()));
            }
        } else {
            updateTransactionVo.setNodeStatus(Integer.valueOf(TransactionNodeStatusEnum.N_SUCCESS.getCode()));
        }
        return updateTransactionVo;
    }
}

