/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.feign.filter;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.client.config.TransactionTrackClientConfigVo;
import com.dtyunxi.cube.component.track.commons.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

@ConditionalOnClass(value={RequestInterceptor.class})
public class TransactionTrackFeignFilter
implements RequestInterceptor {
    private final TransactionTrackClientConfigVo transactionTrackClientConfigVo;

    public TransactionTrackFeignFilter(TransactionTrackClientConfigVo transactionTrackClientConfigVo) {
        this.transactionTrackClientConfigVo = transactionTrackClientConfigVo;
    }

    public void apply(RequestTemplate requestTemplate) {
        TransactionVo overallTransaction = ServerContextUtils.loadTransactionVoByContext((String)"transaction.overall", (String)"transaction.overall.json");
        TransactionVo processTransaction = ServerContextUtils.loadTransactionVoByContext((String)"transaction.process", (String)"transaction.process.json");
        if (overallTransaction != null && processTransaction != null) {
            this.setHeader(requestTemplate, "x_transaction_track_header_over", JSON.toJSONString((Object)overallTransaction));
            this.setHeader(requestTemplate, "x_transaction_track_header_over_process", JSON.toJSONString((Object)processTransaction));
        }
    }

    private <T> void setHeader(RequestTemplate template, String header, String value) {
        if (value != null) {
            template.header(header, new String[]{value});
        }
    }
}

