/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.executor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.commons.aspect.annotation.OpenApiExecuteLog;
import com.dtyunxi.cube.component.track.commons.aspect.annotation.TrackLogNode;
import com.dtyunxi.cube.component.track.commons.aspect.annotation.TransactionParam;
import com.dtyunxi.cube.component.track.commons.constant.TrackLogBizMetaDataType;
import com.dtyunxi.cube.component.track.commons.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionNodeRecordVo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class TrackNodeExecuteUtils {
    private static final Logger logger = LoggerFactory.getLogger(TrackNodeExecuteUtils.class);
    private static final Map<String, List<Field>> CLASS_FIELD_MAP_CACHE = new ConcurrentHashMap<String, List<Field>>();
    private static final int CLASS_FIELD_MAP_CACHE_COUNT_MAX = 30000;
    private static final ExpressionParser parser = new SpelExpressionParser();
    private static final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    public static void catchAndSavePointMethodParamAnnotation(TransactionNodeRecordVo transactionNodeRecordVo, ProceedingJoinPoint point) throws NoSuchMethodException, IllegalAccessException {
        Map extensionMap = transactionNodeRecordVo.getBizParams();
        OpenApiExecuteLog openApiExecuteLog = TrackNodeExecuteUtils.getMethodAnnotationNode(point, (MethodSignature)point.getSignature(), OpenApiExecuteLog.class);
        if (openApiExecuteLog == null) {
            TrackLogNode trackLogNode = TrackNodeExecuteUtils.getMethodAnnotationNode(point, (MethodSignature)point.getSignature(), TrackLogNode.class);
            if (trackLogNode == null) {
                return;
            }
            HashMap<String, String> fieldDefineMap = new HashMap<String, String>();
            TrackNodeExecuteUtils.catchBizDataByMethodAnnotation(point, extensionMap);
            TrackNodeExecuteUtils.catchAndDefineBizDataByLogAnnotation(true, trackLogNode, extensionMap, fieldDefineMap, point);
            TrackNodeExecuteUtils.catchBizDataByMethodParam(point, extensionMap, fieldDefineMap);
            TrackNodeExecuteUtils.catchBizDataByContext(extensionMap, "transaction.track.biz.param");
            TrackNodeExecuteUtils.catchBizDataByLogAnnotation(true, trackLogNode, extensionMap);
            if (StringUtils.isNotBlank((CharSequence)trackLogNode.nodeBizCode())) {
                extensionMap.put("transaction.track.node.biz.code", trackLogNode.nodeBizCode());
            } else {
                extensionMap.put("transaction.track.node.biz.code", trackLogNode.nodeBizDefine().bizCode);
            }
        } else {
            extensionMap.put("apiCode", openApiExecuteLog.openapiDefine().getApiCode());
            extensionMap.put("apiTypeName", openApiExecuteLog.openapiDefine().getApiTypeName());
            extensionMap.put("apiBizTypeName", openApiExecuteLog.openapiDefine().getApiBizTypeName());
            extensionMap.put("apiSystemCode", openApiExecuteLog.openapiDefine().getApiSystem().getCode());
            extensionMap.put("apiSystemName", openApiExecuteLog.openapiDefine().getApiSystem().getDesc());
            extensionMap.put("apiNoType", openApiExecuteLog.openapiDefine().getApiNoType().getCode());
            extensionMap.put("apiNoTypeName", openApiExecuteLog.openapiDefine().getApiNoType().getDesc());
            extensionMap.put("apiOptType", openApiExecuteLog.openapiDefine().getApiOptType().getCode());
            if (openApiExecuteLog.apiBizNo().startsWith("#")) {
                extensionMap.put("apiBizNo", TrackNodeExecuteUtils.getParamBySpel(openApiExecuteLog.apiBizNo(), point, String.class));
            } else {
                extensionMap.put("apiBizNo", openApiExecuteLog.apiBizNo());
            }
            if (openApiExecuteLog.apiThirdBizNo().startsWith("#")) {
                extensionMap.put("apiThirdBizNo", TrackNodeExecuteUtils.getParamBySpel(openApiExecuteLog.apiThirdBizNo(), point, String.class));
            } else {
                extensionMap.put("apiThirdBizNo", openApiExecuteLog.apiThirdBizNo());
            }
            TrackNodeExecuteUtils.catchBizDataByContext(extensionMap, "transaction.track.biz.param");
            extensionMap.put("transaction.track.node.biz.code", openApiExecuteLog.bizDefine().bizCode);
        }
    }

    public static void catchAndSavePointMethodResultAnnotation(TransactionNodeRecordVo transactionNodeRecordVo, ProceedingJoinPoint point, Object resultObj) throws IllegalAccessException {
        Map resultMap = transactionNodeRecordVo.getBizResult();
        TrackLogNode trackLogNode = TrackNodeExecuteUtils.getMethodAnnotationNode(point, (MethodSignature)point.getSignature(), TrackLogNode.class);
        if (trackLogNode == null) {
            TrackNodeExecuteUtils.catchBizDataByContext(resultMap, "transaction.track.biz.result");
            return;
        }
        HashMap<String, String> fieldDefineMap = new HashMap<String, String>();
        TrackNodeExecuteUtils.catchAndDefineBizDataByLogAnnotation(false, trackLogNode, resultMap, fieldDefineMap, point);
        TrackNodeExecuteUtils.catchDataByFieldDefineMapInObj(resultMap, fieldDefineMap, resultObj);
        TrackNodeExecuteUtils.catchBizDataByContext(resultMap, "transaction.track.biz.result");
        TrackNodeExecuteUtils.catchBizDataByLogAnnotation(false, trackLogNode, resultMap);
        resultMap.put("transaction.track.node.biz.code", trackLogNode.nodeBizCode());
    }

    private static void catchBizDataByMethodAnnotation(ProceedingJoinPoint point, Map<String, Object> extensionMap) throws NoSuchMethodException {
        Class<?> classTarget = point.getTarget().getClass();
        Class[] par = ((MethodSignature)point.getSignature()).getParameterTypes();
        Method objMethod = classTarget.getMethod(point.getSignature().getName(), par);
        Annotation[][] annotations = objMethod.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Object param = point.getArgs()[i];
            Annotation[] paramAnn = annotations[i];
            if (param == null || paramAnn.length == 0) continue;
            for (Annotation annotation : paramAnn) {
                if (!annotation.annotationType().equals(TransactionParam.class)) continue;
                extensionMap.put(((TransactionParam)annotation).value(), param);
            }
        }
    }

    private static void catchBizDataByMethodParam(ProceedingJoinPoint point, Map<String, Object> extensionMap, Map<String, String> fieldDefineMap) throws IllegalAccessException {
        if (point.getArgs() == null) {
            return;
        }
        for (Object param : point.getArgs()) {
            TrackNodeExecuteUtils.catchDataByFieldDefineMapInObj(extensionMap, fieldDefineMap, param);
        }
    }

    private static void catchDataByFieldDefineMapInObj(Map<String, Object> extensionMap, Map<String, String> fieldDefineMap, Object obj) throws IllegalAccessException {
        if (obj == null) {
            return;
        }
        List<Field> cacheFields = CLASS_FIELD_MAP_CACHE.get(obj.getClass().getTypeName());
        if (cacheFields != null && !cacheFields.isEmpty()) {
            for (Field field : cacheFields) {
                TrackNodeExecuteUtils.catchPointParamAnnotation(null, extensionMap, obj, field);
                TrackNodeExecuteUtils.catchPointParamByFieldDefineMap(null, extensionMap, obj, field, fieldDefineMap);
            }
        } else {
            cacheFields = new ArrayList<Field>();
            Class<?> tmpCls = obj.getClass();
            while (tmpCls.getGenericSuperclass() != null) {
                for (Field field : tmpCls.getDeclaredFields()) {
                    TrackNodeExecuteUtils.catchPointParamAnnotation(cacheFields, extensionMap, obj, field);
                    TrackNodeExecuteUtils.catchPointParamByFieldDefineMap(cacheFields, extensionMap, obj, field, fieldDefineMap);
                }
                if (CLASS_FIELD_MAP_CACHE.size() >= 30000) {
                    CLASS_FIELD_MAP_CACHE.clear();
                }
                tmpCls = tmpCls.getSuperclass();
            }
            CLASS_FIELD_MAP_CACHE.put(obj.getClass().getTypeName(), cacheFields);
        }
    }

    private static void catchBizDataByContext(Map<String, Object> extensionMap, String contextKey) {
        Map tempMap = TransactionTrackContextUtils.getTrackLogDataMap((String)contextKey);
        if (tempMap != null) {
            extensionMap.putAll(tempMap);
        }
        ServerContextUtils.remove((String)contextKey);
    }

    private static void catchBizDataByLogAnnotation(boolean isParam, TrackLogNode trackLogNode, Map<String, Object> extensionMap) {
        String bizJson;
        String string = bizJson = isParam ? trackLogNode.nodeBizParamsJson() : trackLogNode.nodeBizResultJson();
        if (StringUtils.isNotBlank((CharSequence)bizJson)) {
            Map bizParamsMap = (Map)JSON.parseObject((String)bizJson, Map.class);
            extensionMap.putAll(bizParamsMap);
        }
    }

    private static void catchAndDefineBizDataByLogAnnotation(boolean isParam, TrackLogNode trackLogNode, Map<String, Object> extensionMap, Map<String, String> fieldDefineMap, ProceedingJoinPoint point) {
        String[] nodeBizKeys;
        String[] stringArray = nodeBizKeys = isParam ? trackLogNode.nodeBizParamsKeys() : trackLogNode.nodeBizResultKeys();
        if (nodeBizKeys.length > 0) {
            String[] nodeBizValues = isParam ? trackLogNode.nodeBizParamsValues() : trackLogNode.nodeBizResultValues();
            TrackLogBizMetaDataType[] nodeBizValueTypes = isParam ? trackLogNode.nodeBizParamsValueTypes() : trackLogNode.nodeBizResultValueTypes();
            Stream.iterate(0, i -> i + 1).limit(nodeBizKeys.length).forEach(i -> {
                if (nodeBizValueTypes.length < 1) {
                    if (nodeBizValues[i].startsWith("#")) {
                        extensionMap.put(nodeBizKeys[i], TrackNodeExecuteUtils.getParamBySpel(nodeBizValues[i], point, String.class));
                    } else {
                        extensionMap.put(nodeBizKeys[i], nodeBizValues[i]);
                    }
                } else if (i <= nodeBizValueTypes.length - 1 && i <= nodeBizValues.length - 1) {
                    switch (nodeBizValueTypes[i]) {
                        case FIELD_DATA: {
                            extensionMap.put(nodeBizKeys[i], nodeBizValues[i]);
                            break;
                        }
                        case FIELD_DEFINE: {
                            fieldDefineMap.put(nodeBizValues[i], nodeBizKeys[i]);
                            break;
                        }
                    }
                }
            });
        }
    }

    private static void catchPointParamAnnotation(List<Field> cacheFields, Map<String, Object> extensionMap, Object param, Field field) throws IllegalAccessException {
        TransactionParam transactionParam = field.getAnnotation(TransactionParam.class);
        if (transactionParam != null) {
            field.setAccessible(true);
            Object fieldValue = field.get(param);
            if (fieldValue != null) {
                extensionMap.put(transactionParam.value(), fieldValue);
                Optional.ofNullable(cacheFields).ifPresent(cache -> cache.add(field));
            }
        }
    }

    private static void catchPointParamByFieldDefineMap(List<Field> cacheFields, Map<String, Object> extensionMap, Object param, Field field, Map<String, String> fieldDefineMap) throws IllegalAccessException {
        String defineKey = fieldDefineMap.get(field.getName());
        if (StringUtils.isNotBlank((CharSequence)defineKey)) {
            field.setAccessible(true);
            Object fieldValue = field.get(param);
            if (fieldValue != null) {
                extensionMap.put(defineKey, fieldValue);
                Optional.ofNullable(cacheFields).ifPresent(cache -> cache.add(field));
            }
        }
    }

    public static <T extends Annotation> T getMethodAnnotationNode(ProceedingJoinPoint point, MethodSignature ms, Class<T> cls) {
        try {
            Method method = point.getTarget().getClass().getDeclaredMethod(ms.getName(), ms.getParameterTypes());
            Annotation an = AnnotationUtils.getAnnotation((Method)method, cls);
            if (an == null) {
                return point.getTarget().getClass().getAnnotation(cls);
            }
            return (T)an;
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static <T> T getParamBySpel(String spel, ProceedingJoinPoint point, Class<T> cls) {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Object[] arguments = point.getArgs();
        return TrackNodeExecuteUtils.getParamBySpel(spel, targetMethod, arguments, cls);
    }

    private static <T> T getParamBySpel(String spel, Method method, Object[] arguments, Class<T> tClass) {
        String[] params = discoverer.getParameterNames(method);
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (params == null || params.length == 0) {
            logger.debug("spel\u8868\u8fbe\u5f0f\u89e3\u6790\u5bf9\u8c61\u5bf9\u7a7a\uff01");
            return null;
        }
        for (int len = 0; len < params.length; ++len) {
            context.setVariable(params[len], arguments[len]);
        }
        try {
            Expression expression = parser.parseExpression(spel);
            return (T)expression.getValue((EvaluationContext)context, tClass);
        }
        catch (Exception var7) {
            logger.error("spel\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38\uff01", (Throwable)var7);
            return null;
        }
    }
}

