package com.yx.tcbj.center.dao.eo;



import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 供应商和产品的供货价格
 */
@Table(name = "it_item")
public class ItemSellerSkuPriceEo extends CubeBaseEo {
    /**
     * id
     */
    @Column(name = "id")
    private Long id;

    /**
     * 显示名
     */
    @Column(name = "display_name")
    private String displayName;

    /**
     * 品牌名称
     */
    @Column(name = "brand")
    private String brand;

    /**
     * 编码
     */
    @Column(name = "code")
    private String code;

    /**
     * 商品子类型，1-产品，2-赠品，3-物料
     */
    @Column(name = "sub_type")
    private Integer subType;

    /**
     * 规格
     */
    private String attr;

    /**
     * 零售价
     */
    private String price;

    /**
     * 供货价
     */
    private String supplyPrice;

    /**
     *  商品图片链接
     */
    private String imgPath;

    /**
     *  商品sku
     */
    private String skuIds;

    /**
     * 目录id
     */
    private Long dirId;

    /**
     *  卖家（商家/大B）ID
     */
    private Long sellerId;

    /**
     * 店铺id
     */
    private Long shopId;

    /**
     * 商铺名称
     */
    private String shopName;

    /**
     *  买家（客户/小B）ID
     */
    private Long customerId;

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getSupplyPrice() {
        return supplyPrice;
    }

    public void setSupplyPrice(String supplyPrice) {
        this.supplyPrice = supplyPrice;
    }

    public String getImgPath() {
        return imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getSkuIds() {
        return skuIds;
    }

    public void setSkuIds(String skuIds) {
        this.skuIds = skuIds;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }
}
