/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaAnalysisService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.analysis.WxMaRetainInfo;
import cn.binarywang.wx.miniapp.bean.analysis.WxMaSummaryTrend;
import cn.binarywang.wx.miniapp.bean.analysis.WxMaUserPortrait;
import cn.binarywang.wx.miniapp.bean.analysis.WxMaVisitDistribution;
import cn.binarywang.wx.miniapp.bean.analysis.WxMaVisitPage;
import cn.binarywang.wx.miniapp.bean.analysis.WxMaVisitTrend;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.lang3.time.DateFormatUtils;

public class WxMaAnalysisServiceImpl
implements WxMaAnalysisService {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private WxMaService wxMaService;

    @Override
    public List<WxMaSummaryTrend> getDailySummaryTrend(Date beginDate, Date endDate) throws WxErrorException {
        return this.getAnalysisResultAsList("https://api.weixin.qq.com/datacube/getweanalysisappiddailysummarytrend", beginDate, endDate, new TypeToken<List<WxMaSummaryTrend>>(){}.getType());
    }

    @Override
    public List<WxMaVisitTrend> getDailyVisitTrend(Date beginDate, Date endDate) throws WxErrorException {
        return this.getAnalysisResultAsList("https://api.weixin.qq.com/datacube/getweanalysisappiddailyvisittrend", beginDate, endDate, new TypeToken<List<WxMaVisitTrend>>(){}.getType());
    }

    @Override
    public List<WxMaVisitTrend> getWeeklyVisitTrend(Date beginDate, Date endDate) throws WxErrorException {
        return this.getAnalysisResultAsList("https://api.weixin.qq.com/datacube/getweanalysisappidweeklyvisittrend", beginDate, endDate, new TypeToken<List<WxMaVisitTrend>>(){}.getType());
    }

    @Override
    public List<WxMaVisitTrend> getMonthlyVisitTrend(Date beginDate, Date endDate) throws WxErrorException {
        return this.getAnalysisResultAsList("https://api.weixin.qq.com/datacube/getweanalysisappidmonthlyvisittrend", beginDate, endDate, new TypeToken<List<WxMaVisitTrend>>(){}.getType());
    }

    @Override
    public WxMaVisitDistribution getVisitDistribution(Date beginDate, Date endDate) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/datacube/getweanalysisappidvisitdistribution", WxMaAnalysisServiceImpl.toJson(beginDate, endDate));
        return WxMaVisitDistribution.fromJson(responseContent);
    }

    @Override
    public WxMaRetainInfo getDailyRetainInfo(Date beginDate, Date endDate) throws WxErrorException {
        return this.getRetainInfo(beginDate, endDate, "https://api.weixin.qq.com/datacube/getweanalysisappiddailyretaininfo");
    }

    @Override
    public WxMaRetainInfo getWeeklyRetainInfo(Date beginDate, Date endDate) throws WxErrorException {
        return this.getRetainInfo(beginDate, endDate, "https://api.weixin.qq.com/datacube/getweanalysisappidweeklyretaininfo");
    }

    @Override
    public WxMaRetainInfo getMonthlyRetainInfo(Date beginDate, Date endDate) throws WxErrorException {
        return this.getRetainInfo(beginDate, endDate, "https://api.weixin.qq.com/datacube/getweanalysisappidmonthlyretaininfo");
    }

    @Override
    public List<WxMaVisitPage> getVisitPage(Date beginDate, Date endDate) throws WxErrorException {
        return this.getAnalysisResultAsList("https://api.weixin.qq.com/datacube/getweanalysisappidvisitpage", beginDate, endDate, new TypeToken<List<WxMaVisitPage>>(){}.getType());
    }

    @Override
    public WxMaUserPortrait getUserPortrait(Date beginDate, Date endDate) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/datacube/getweanalysisappiduserportrait", WxMaAnalysisServiceImpl.toJson(beginDate, endDate));
        return WxMaUserPortrait.fromJson(responseContent);
    }

    private WxMaRetainInfo getRetainInfo(Date beginDate, Date endDate, String url) throws WxErrorException {
        String responseContent = this.wxMaService.post(url, WxMaAnalysisServiceImpl.toJson(beginDate, endDate));
        return WxMaRetainInfo.fromJson(responseContent);
    }

    private <T> List<T> getAnalysisResultAsList(String url, Date beginDate, Date endDate, Type returnType) throws WxErrorException {
        String responseContent = this.wxMaService.post(url, WxMaAnalysisServiceImpl.toJson(beginDate, endDate));
        JsonObject response = JSON_PARSER.parse(responseContent).getAsJsonObject();
        boolean hasList = response.has("list");
        if (hasList) {
            return (List)WxMaGsonBuilder.create().fromJson((JsonElement)response.getAsJsonArray("list"), returnType);
        }
        return null;
    }

    private static String toJson(Date beginDate, Date endDate) {
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", DateFormatUtils.format((Date)beginDate, (String)"yyyyMMdd"));
        param.addProperty("end_date", DateFormatUtils.format((Date)endDate, (String)"yyyyMMdd"));
        return param.toString();
    }

    public WxMaAnalysisServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

