/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceChangeListener;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceDiscoverHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={Knife4jGatewayProperties.class})
@ComponentScan(basePackageClasses={Knife4jGatewayAutoConfiguration.class})
@ConditionalOnProperty(name={"knife4j.gateway.enabled"}, havingValue="true")
public class Knife4jGatewayAutoConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={Knife4jGatewayProperties.class})
    @ConditionalOnProperty(name={"knife4j.gateway.strategy"}, havingValue="discover")
    public static class Knife4jDiscoverConfiguration {
        @Bean
        public ServiceDiscoverHandler serviceDiscoverHandler(Knife4jGatewayProperties knife4jGatewayProperties) {
            return new ServiceDiscoverHandler(knife4jGatewayProperties);
        }

        @Bean
        public ServiceChangeListener serviceChangeListener(DiscoveryClient discoveryClient, ServiceDiscoverHandler serviceDiscoverHandler) {
            return new ServiceChangeListener(discoveryClient, serviceDiscoverHandler);
        }
    }
}

