/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.AbstractBucketClient;
import com.obs.services.AbstractClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.BaseBucketRequest;
import com.obs.services.model.BucketDirectColdAccess;
import com.obs.services.model.BucketEncryption;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketPolicyResponse;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.DeleteBucketLifecycleRequest;
import com.obs.services.model.GetBucketLifecycleRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.SetBucketDirectColdAccessRequest;
import com.obs.services.model.SetBucketEncryptionRequest;
import com.obs.services.model.SetBucketLifecycleRequest;
import com.obs.services.model.SetBucketNotificationRequest;
import com.obs.services.model.SetBucketPolicyRequest;
import com.obs.services.model.SetBucketReplicationRequest;
import com.obs.services.model.SetBucketTaggingRequest;
import com.obs.services.model.SetBucketWebsiteRequest;
import com.obs.services.model.WebsiteConfiguration;
import com.obs.services.model.bpa.DeleteBucketPublicAccessBlockRequest;
import com.obs.services.model.bpa.GetBucketPolicyPublicStatusRequest;
import com.obs.services.model.bpa.GetBucketPolicyPublicStatusResult;
import com.obs.services.model.bpa.GetBucketPublicAccessBlockRequest;
import com.obs.services.model.bpa.GetBucketPublicAccessBlockResult;
import com.obs.services.model.bpa.GetBucketPublicStatusRequest;
import com.obs.services.model.bpa.GetBucketPublicStatusResult;
import com.obs.services.model.bpa.PutBucketPublicAccessBlockRequest;
import com.obs.services.model.crr.GetCrrProgressRequest;
import com.obs.services.model.crr.GetCrrProgressResult;
import com.obs.services.model.fs.GetBucketFSStatusRequest;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import com.obs.services.model.fs.SetBucketFSStatusRequest;
import com.obs.services.model.trash.DeleteBucketTrashRequest;
import com.obs.services.model.trash.GetBucketTrashRequest;
import com.obs.services.model.trash.GetBucketTrashResult;
import com.obs.services.model.trash.SetBucketTrashRequest;

public abstract class AbstractBucketAdvanceClient
extends AbstractBucketClient {
    @Override
    public LifecycleConfiguration getBucketLifecycle(String bucketName) throws ObsException {
        return this.getBucketLifecycle(new BaseBucketRequest(bucketName));
    }

    @Override
    public LifecycleConfiguration getBucketLifecycle(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketLifecycleConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<LifecycleConfiguration>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public LifecycleConfiguration action() throws ServiceException {
                return this.this$0.getBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Override
    public LifecycleConfiguration getBucketLifecycle(final GetBucketLifecycleRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetBucketLifecycleRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketLifecycleConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<LifecycleConfiguration>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public LifecycleConfiguration action() throws ServiceException {
                return this.this$0.getBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketLifecycle(String bucketName, LifecycleConfiguration lifecycleConfig) throws ObsException {
        return this.setBucketLifecycle(new SetBucketLifecycleRequest(bucketName, lifecycleConfig));
    }

    @Override
    public HeaderResponse setBucketLifecycle(final SetBucketLifecycleRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketLifecycleRequest is null");
        ServiceUtils.assertParameterNotNull(request.getLifecycleConfig(), "LifecycleConfiguration is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketLifecycleConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketLifecycle(String bucketName) throws ObsException {
        return this.deleteBucketLifecycle(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketLifecycle(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketLifecycleConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketLifecycle(final DeleteBucketLifecycleRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "DeleteBucketLifecycleRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketLifecycleConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Override
    public String getBucketPolicy(String bucketName) throws ObsException {
        return this.getBucketPolicyV2(new BaseBucketRequest(bucketName)).getPolicy();
    }

    @Override
    public String getBucketPolicy(BaseBucketRequest request) throws ObsException {
        return this.getBucketPolicyV2(request).getPolicy();
    }

    @Override
    public BucketPolicyResponse getBucketPolicyV2(String bucketName) throws ObsException {
        return this.getBucketPolicyV2(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketPolicyResponse getBucketPolicyV2(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketPolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketPolicyResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketPolicyResponse action() throws ServiceException {
                return this.this$0.getBucketPolicyImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketPolicy(String bucketName, String policy) throws ObsException {
        return this.setBucketPolicy(new SetBucketPolicyRequest(bucketName, policy));
    }

    @Override
    public HeaderResponse setBucketPolicy(final SetBucketPolicyRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketPolicyRequest is null");
        ServiceUtils.assertParameterNotNull(request.getPolicy(), "policy is null");
        return this.doActionWithResult("setBucketPolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketPolicyImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketPolicy(String bucketName) throws ObsException {
        return this.deleteBucketPolicy(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketPolicy(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketPolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketPolicyImpl(request);
            }
        });
    }

    @Override
    public WebsiteConfiguration getBucketWebsite(String bucketName) throws ObsException {
        return this.getBucketWebsite(new BaseBucketRequest(bucketName));
    }

    @Override
    public WebsiteConfiguration getBucketWebsite(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketWebsiteConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<WebsiteConfiguration>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public WebsiteConfiguration action() throws ServiceException {
                return this.this$0.getBucketWebsiteConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketWebsite(String bucketName, WebsiteConfiguration websiteConfig) throws ObsException {
        return this.setBucketWebsite(new SetBucketWebsiteRequest(bucketName, websiteConfig));
    }

    @Override
    public HeaderResponse setBucketWebsite(final SetBucketWebsiteRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketWebsiteRequest is null");
        ServiceUtils.assertParameterNotNull(request.getWebsiteConfig(), "WebsiteConfiguration is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketWebsiteConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketWebsiteConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketWebsite(String bucketName) throws ObsException {
        return this.deleteBucketWebsite(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketWebsite(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketWebsiteConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketWebsiteConfigurationImpl(request);
            }
        });
    }

    @Override
    public BucketTagInfo getBucketTagging(String bucketName) throws ObsException {
        return this.getBucketTagging(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketTagInfo getBucketTagging(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketTagging", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketTagInfo>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketTagInfo action() throws ServiceException {
                return this.this$0.getBucketTaggingImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketTagging(String bucketName, BucketTagInfo bucketTagInfo) throws ObsException {
        return this.setBucketTagging(new SetBucketTaggingRequest(bucketName, bucketTagInfo));
    }

    @Override
    public HeaderResponse setBucketTagging(final SetBucketTaggingRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketTaggingRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketTagging", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketTaggingImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketTagging(String bucketName) throws ObsException {
        return this.deleteBucketTagging(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketTagging(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketTagging", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketTaggingImpl(request);
            }
        });
    }

    @Override
    public BucketEncryption getBucketEncryption(String bucketName) throws ObsException {
        return this.getBucketEncryption(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketEncryption getBucketEncryption(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketEncryption", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketEncryption>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketEncryption action() throws ServiceException {
                return this.this$0.getBucketEncryptionImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketEncryption(String bucketName, BucketEncryption bucketEncryption) throws ObsException {
        return this.setBucketEncryption(new SetBucketEncryptionRequest(bucketName, bucketEncryption));
    }

    @Override
    public HeaderResponse setBucketEncryption(final SetBucketEncryptionRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketEncryptionRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketEncryption(), "SetBucketEncryptionRequest.bucketEncryption is null");
        return this.doActionWithResult("setBucketEncryption", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketEncryptionImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketEncryption(String bucketName) throws ObsException {
        return this.deleteBucketEncryption(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketEncryption(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("deleteBucketEncryption", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketEncryptionImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketReplication(String bucketName, ReplicationConfiguration replicationConfiguration) throws ObsException {
        return this.setBucketReplication(new SetBucketReplicationRequest(bucketName, replicationConfiguration));
    }

    @Override
    public HeaderResponse setBucketReplication(final SetBucketReplicationRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketReplicationRequest is null");
        ServiceUtils.assertParameterNotNull(request.getReplicationConfiguration(), "ReplicationConfiguration is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketReplication", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketReplicationConfigurationImpl(request);
            }
        });
    }

    @Override
    public ReplicationConfiguration getBucketReplication(String bucketName) throws ObsException {
        return this.getBucketReplication(new BaseBucketRequest(bucketName));
    }

    @Override
    public ReplicationConfiguration getBucketReplication(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketReplicationConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ReplicationConfiguration>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public ReplicationConfiguration action() throws ServiceException {
                return this.this$0.getBucketReplicationConfigurationImpl(request);
            }
        });
    }

    @Override
    public GetCrrProgressResult getCrrProgress(final GetCrrProgressRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetCrrProgressRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getRuleId(), "ruleId is null");
        return this.doActionWithResult("getCrrProgress", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<GetCrrProgressResult>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public GetCrrProgressResult action() throws ServiceException {
                return this.this$0.getCrrProgressImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = this.this$0.getProviderCredentials().getLocalAuthType().get(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = this.this$0.getApiVersion(request.getBucketName());
                    this.this$0.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                }
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketReplication(String bucketName) throws ObsException {
        return this.deleteBucketReplication(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketReplication(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketReplicationConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketReplicationConfigurationImpl(request);
            }
        });
    }

    @Override
    public BucketNotificationConfiguration getBucketNotification(String bucketName) throws ObsException {
        return this.getBucketNotification(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketNotificationConfiguration getBucketNotification(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketNotification", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketNotificationConfiguration>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketNotificationConfiguration action() throws ServiceException {
                return this.this$0.getBucketNotificationConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketNotification(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration) throws ObsException {
        return this.setBucketNotification(new SetBucketNotificationRequest(bucketName, bucketNotificationConfiguration));
    }

    @Override
    public HeaderResponse setBucketNotification(final SetBucketNotificationRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketNotificationRequest is null");
        return this.doActionWithResult("setBucketNotification", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                if (null == request.getBucketNotificationConfiguration()) {
                    request.setBucketNotificationConfiguration(new BucketNotificationConfiguration());
                }
                return this.this$0.setBucketNotificationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketFSStatus(final SetBucketFSStatusRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketFileInterfaceRequest is null");
        return this.doActionWithResult("setBucketFSStatus", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketFSStatusImpl(request);
            }
        });
    }

    @Override
    public GetBucketFSStatusResult getBucketFSStatus(final GetBucketFSStatusRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetBucketFSStatusRequest is null");
        return this.doActionWithResult("getBucketFSStatus", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<GetBucketFSStatusResult>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public GetBucketFSStatusResult action() throws ServiceException {
                return this.this$0.getBucketMetadataImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketDirectColdAccess(String bucketName, BucketDirectColdAccess access) throws ObsException {
        return this.setBucketDirectColdAccess(new SetBucketDirectColdAccessRequest(bucketName, access));
    }

    @Override
    public HeaderResponse setBucketDirectColdAccess(final SetBucketDirectColdAccessRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketDirectColdAccessRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull(request.getAccess(), "bucketDirectColdAccess is null");
        return this.doActionWithResult("setBucketDirectColdAccess", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketDirectColdAccessImpl(request);
            }
        });
    }

    @Override
    public BucketDirectColdAccess getBucketDirectColdAccess(String bucketName) throws ObsException {
        return this.getBucketDirectColdAccess(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketDirectColdAccess getBucketDirectColdAccess(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketDirectColdAccess", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketDirectColdAccess>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketDirectColdAccess action() throws ServiceException {
                return this.this$0.getBucketDirectColdAccessImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketDirectColdAccess(String bucketName) throws ObsException {
        return this.deleteBucketDirectColdAccess(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse setBucketTrash(final SetBucketTrashRequest setBucketTrashRequest) throws ObsException {
        ServiceUtils.assertParameterNotNull(setBucketTrashRequest, "SetBucketTrashRequest is null");
        ServiceUtils.assertParameterNotNull(setBucketTrashRequest.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketTrash", setBucketTrashRequest.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketTrashImpl(setBucketTrashRequest);
            }
        });
    }

    @Override
    public GetBucketTrashResult getBucketTrash(final GetBucketTrashRequest getBucketTrashRequest) throws ObsException {
        ServiceUtils.assertParameterNotNull(getBucketTrashRequest, "GetBucketTrashRequest is null");
        ServiceUtils.assertParameterNotNull(getBucketTrashRequest.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketTrash", getBucketTrashRequest.getBucketName(), new AbstractClient.ActionCallbackWithResult<GetBucketTrashResult>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public GetBucketTrashResult action() throws ServiceException {
                return this.this$0.getBucketTrashImpl(getBucketTrashRequest);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketTrash(final DeleteBucketTrashRequest deleteBucketTrashRequest) throws ObsException {
        ServiceUtils.assertParameterNotNull(deleteBucketTrashRequest, "DeleteBucketTrashRequest is null");
        ServiceUtils.assertParameterNotNull(deleteBucketTrashRequest.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketTrash", deleteBucketTrashRequest.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketTrashImpl(deleteBucketTrashRequest);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketDirectColdAccess(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketDirectColdAccess", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketDirectColdAccessImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse putBucketPublicAccessBlock(final PutBucketPublicAccessBlockRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "PutBucketPublicAccessBlockRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("putBucketPublicAccessBlock", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.putBucketPublicAccessBlockImpl(request);
            }
        });
    }

    @Override
    public GetBucketPublicAccessBlockResult getBucketPublicAccessBlock(final GetBucketPublicAccessBlockRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetBucketPublicAccessBlockRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketPublicAccessBlock", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<GetBucketPublicAccessBlockResult>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public GetBucketPublicAccessBlockResult action() throws ServiceException {
                return this.this$0.getBucketPublicAccessBlockImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketPublicAccessBlock(final DeleteBucketPublicAccessBlockRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "DeleteBucketPublicAccessBlockRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketPublicAccessBlock", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketPublicAccessBlockImpl(request);
            }
        });
    }

    @Override
    public GetBucketPolicyPublicStatusResult getBucketPolicyPublicStatus(final GetBucketPolicyPublicStatusRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetBucketPolicyPublicStatusRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketPolicyPublicStatus", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<GetBucketPolicyPublicStatusResult>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public GetBucketPolicyPublicStatusResult action() throws ServiceException {
                return this.this$0.getBucketPolicyPublicStatusImpl(request);
            }
        });
    }

    @Override
    public GetBucketPublicStatusResult getBucketPublicStatus(final GetBucketPublicStatusRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetBucketPublicStatusRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketPublicStatus", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<GetBucketPublicStatusResult>(this){
            final /* synthetic */ AbstractBucketAdvanceClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public GetBucketPublicStatusResult action() throws ServiceException {
                return this.this$0.getBucketPublicStatusImpl(request);
            }
        });
    }
}

