/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import oracle.jdbc.AccessToken;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.diagnostics.DefaultTraceEventListenerProvider;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import org.ietf.jgss.GSSCredential;

public abstract class AbstractConnectionBuilder<T extends AbstractConnectionBuilder<T, U>, U> {
    private final T self = this;
    private boolean isImmutable = false;
    private String user = null;
    private OpaqueString password = null;
    private String serviceName = null;
    private String instanceName = null;
    private OracleShardingKey shardingKey = null;
    private OracleShardingKey superShardingKey = null;
    private GSSCredential gssCredential = null;
    private SSLContext sslContext = null;
    private Function<byte[], byte[]> radiusCRHandler;
    private TraceEventListener traceEventListener = null;
    private boolean allowSingleShardTransaction = false;
    private boolean readOnlyInstanceAllowed = false;
    private OracleHostnameResolver hostnameResolver = null;
    private Executor executor = null;
    private Supplier<? extends AccessToken> tokenSupplier = null;

    protected AbstractConnectionBuilder() {
    }

    public final T password(@Blind String password) {
        return this.password(OpaqueString.newOpaqueString(password));
    }

    public T password(OpaqueString password) {
        this.ensureMutableState();
        this.password = password == null ? OpaqueString.NULL : password;
        return this.self;
    }

    public final T user(String user) {
        this.ensureMutableState();
        this.user = user;
        return this.self;
    }

    public final T serviceName(String serviceName) {
        this.ensureMutableState();
        this.serviceName = serviceName;
        return this.self;
    }

    public final T instanceName(String instanceName) {
        this.ensureMutableState();
        this.instanceName = instanceName;
        return this.self;
    }

    public final T shardingKey(OracleShardingKey shardingKey) {
        this.ensureMutableState();
        this.shardingKey = shardingKey;
        return this.self;
    }

    public final T superShardingKey(OracleShardingKey superShardingKey) {
        this.ensureMutableState();
        this.superShardingKey = superShardingKey;
        if (superShardingKey != null) {
            ((OracleShardingKeyImpl)superShardingKey).markSuperShardingKey(true);
        }
        return this.self;
    }

    public final T gssCredential(GSSCredential credential) {
        this.ensureMutableState();
        if (credential == null) {
            throw new NullPointerException("Argument to gssCredential(GSSCredential) is null");
        }
        this.gssCredential = credential;
        return this.self;
    }

    public final T sslContext(SSLContext sslContext) {
        this.ensureMutableState();
        this.sslContext = sslContext;
        return this.self;
    }

    public final T radiusChallengeResponseHandler(Function<byte[], byte[]> radiusCRHandler) {
        this.ensureMutableState();
        this.radiusCRHandler = radiusCRHandler;
        return this.self;
    }

    public final T traceEventListener(TraceEventListener traceEventListener) {
        this.ensureMutableState();
        this.traceEventListener = traceEventListener == null ? DefaultTraceEventListenerProvider.NO_OP_TRACE_EVENT_LISTENER : traceEventListener;
        return this.self;
    }

    public final T singleShardTransactionSupport(boolean allow) {
        this.ensureMutableState();
        this.allowSingleShardTransaction = allow;
        return this.self;
    }

    public final T readOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
        this.ensureMutableState();
        this.readOnlyInstanceAllowed = readOnlyInstanceAllowed;
        return this.self;
    }

    public final T hostnameResolver(OracleHostnameResolver hostnameResolver) {
        this.ensureMutableState();
        this.hostnameResolver = hostnameResolver;
        return this.self;
    }

    public final String getUser() {
        return this.user;
    }

    public final OpaqueString getPassword() {
        return this.password;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getInstanceName() {
        return this.instanceName;
    }

    public final OracleShardingKeyImpl getShardingKey() {
        return (OracleShardingKeyImpl)this.shardingKey;
    }

    public final OracleShardingKeyImpl getSuperShardingKey() {
        return (OracleShardingKeyImpl)this.superShardingKey;
    }

    @Blind
    public final GSSCredential getGSSCredential() {
        return this.gssCredential;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    public final TraceEventListener getTraceEventListener() {
        return this.traceEventListener;
    }

    public final Function<byte[], byte[]> getRadiusChallengeResponseHandler() {
        return this.radiusCRHandler;
    }

    public final boolean getAllowSingleShardTransaction() {
        return this.allowSingleShardTransaction;
    }

    public final boolean getReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed;
    }

    public final OracleHostnameResolver getHostnameResolver() {
        return this.hostnameResolver;
    }

    @Blind
    public final Supplier<? extends AccessToken> getTokenSupplier() {
        return this.tokenSupplier;
    }

    public final T copy(AbstractConnectionBuilder<?, ?> other) {
        this.ensureMutableState();
        this.user = other.user;
        this.password = other.password;
        this.instanceName = other.instanceName;
        this.serviceName = other.serviceName;
        this.shardingKey = other.shardingKey;
        this.superShardingKey = other.superShardingKey;
        this.sslContext = other.sslContext;
        this.hostnameResolver = other.hostnameResolver;
        this.allowSingleShardTransaction = other.allowSingleShardTransaction;
        this.executor = other.executor;
        this.tokenSupplier = other.tokenSupplier;
        if (this.gssCredential != null) {
            this.gssCredential = other.gssCredential;
        }
        return this.self;
    }

    public final T executorOracle(Executor exec) {
        this.ensureMutableState();
        this.executor = exec;
        return this.self;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public final T accessToken(@Blind AccessToken accessToken) {
        Objects.requireNonNull(accessToken, "Value of accessToken is null");
        this.setTokenSupplier(() -> accessToken);
        return this.self;
    }

    public final void setTokenSupplier(@Blind Supplier<? extends AccessToken> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    public final void verifyBuildConfiguration() throws SQLException {
        boolean isUserOrPasswordSet;
        boolean bl = isUserOrPasswordSet = this.getUser() != null || this.getPassword() != null && !this.getPassword().isNull();
        if (this.getGSSCredential() != null && isUserOrPasswordSet) {
            throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
        }
        if (this.tokenSupplier != null && isUserOrPasswordSet) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Builder is configured with both an access token and a user name or password").fillInStackTrace();
        }
    }

    public abstract U build() throws SQLException;

    protected final void setImmutable() {
        this.isImmutable = true;
    }

    protected final void ensureMutableState() {
        if (this.isImmutable) {
            throw new IllegalStateException("This builder is immutable");
        }
    }

    public static <T extends AbstractConnectionBuilder<T, U>, U> AbstractConnectionBuilder<T, U> unconfigured() {
        return new AbstractConnectionBuilder<T, U>(){

            @Override
            public U build() throws SQLException {
                throw new IllegalStateException();
            }
        };
    }
}

