/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.logging.Level;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlob;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableBlob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.sql.BlobDBAccess;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.DatumWithConnection;
import oracle.xdb.XMLType;

public class BLOB
extends DatumWithConnection
implements oracle.jdbc.internal.OracleBlob,
OracleConcreteProxy {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_INVALID = -1;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    public static final int OLD_WRONG_DURATION_SESSION = 1;
    public static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    protected OracleBlob target = null;
    private oracle.jdbc.internal.OracleBlob ojiOracleBlob = null;

    protected BLOB() {
        OracleBlob b = new OracleBlob();
        this.setTarget(null, b, null, false);
    }

    public OracleBlob getTarget() {
        return this.target;
    }

    private void setTarget(oracle.jdbc.OracleConnection conn, OracleBlob b, byte[] lob_descriptor, boolean recordConstructor) {
        Class<TxnReplayableBlob> proxyClass = TxnReplayableBlob.class;
        this.ojiOracleBlob = ConcreteProxyUtil.getProxyObject(conn, b, proxyClass, this);
        this.target = b;
        this.setShareBytes(this.target.shareBytes());
        this.targetDatumWithConnection = this.target;
        this.targetDatum = this.target;
        if (this.ojiOracleBlob != null) {
            try {
                Object proxyObj = ConcreteProxyUtil.checkAndGetACProxyConnection(conn);
                if (proxyObj != null && recordConstructor) {
                    ((TxnReplayableConnection)proxyObj).BLOBConstructorRecording(lob_descriptor, this);
                }
            }
            catch (SQLException sqe) {
                CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, "oracle/sql/BLOB", "setTarget", sqe.getMessage(), null, null);
            }
            this.ojiOracleDatumWithConnection = this.ojiOracleBlob;
        } else {
            this.ojiOracleBlob = this.target;
        }
    }

    public void createAndSetShardingLobProxy(Class proxyClass, Object creator) {
        this.ojiOracleBlob = ConcreteProxyUtil.getProxyObject(this.ojiOracleBlob, proxyClass, creator);
        this.ojiOracleDatumWithConnection = this.ojiOracleBlob;
    }

    @Override
    public TxnReplayableBase getConcreteProxy() {
        if (this.ojiOracleBlob instanceof TxnReplayableBase) {
            return (TxnReplayableBase)((Object)this.ojiOracleBlob);
        }
        return null;
    }

    protected BLOB(OracleBlob b) {
        this.setTarget(null, b, null, false);
    }

    public BLOB(oracle.jdbc.OracleConnection conn) throws SQLException {
        this(conn, null);
    }

    public BLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor, boolean fromObject) throws SQLException {
        this(conn, lob_descriptor);
        this.target.setFromobject(fromObject);
    }

    public BLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        oracle.jdbc.OracleConnection delegateConn = null;
        delegateConn = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate(conn);
        if (delegateConn != null) {
            conn = delegateConn;
        }
        OracleBlob b = new OracleBlob(conn, lob_descriptor);
        this.setTarget(conn, b, lob_descriptor, delegateConn != null);
    }

    @Override
    public long length() throws SQLException {
        return this.ojiOracleBlob.length();
    }

    @Override
    public final long lengthInternal() throws SQLException {
        return this.ojiOracleBlob.lengthInternal();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return this.ojiOracleBlob.getBytes(pos, length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.ojiOracleBlob.getBinaryStream();
    }

    public InputStream getBinaryStream(boolean isInternal) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.getBinaryStream(isInternal);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        return this.ojiOracleBlob.position(pattern, start);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.ojiOracleBlob.position(pattern, start);
    }

    @Override
    public int getBytes(long pos, int length, byte[] buf) throws SQLException {
        return this.ojiOracleBlob.getBytes(pos, length, buf);
    }

    @Override
    public int putBytes(long pos, byte[] bytes) throws SQLException {
        return this.ojiOracleBlob.putBytes(pos, bytes);
    }

    @Override
    public int putBytes(long pos, byte[] bytes, int length) throws SQLException {
        return this.ojiOracleBlob.putBytes(pos, bytes, length);
    }

    @Override
    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.ojiOracleBlob.getBinaryOutputStream();
    }

    @Override
    public byte[] getLocator() {
        return this.ojiOracleBlob.getLocator();
    }

    @Override
    public void setLocator(byte[] locator) {
        this.ojiOracleBlob.setLocator(locator);
    }

    @Override
    public int getChunkSize() throws SQLException {
        return this.ojiOracleBlob.getChunkSize();
    }

    @Override
    public int getBufferSize() throws SQLException {
        return this.ojiOracleBlob.getBufferSize();
    }

    public static BLOB empty_lob() throws SQLException {
        return BLOB.getEmptyBLOB();
    }

    public static BLOB getEmptyBLOB() throws SQLException {
        byte[] locator = new byte[86];
        locator[1] = 84;
        locator[5] = 24;
        BLOB blob = new BLOB();
        blob.setShareBytes(locator);
        OracleBlob target = blob.getTarget();
        target.setShareBytes(locator);
        return blob;
    }

    @Override
    public boolean isEmptyLob() throws SQLException {
        return this.ojiOracleBlob.isEmptyLob();
    }

    @Override
    public boolean isSecureFile() throws SQLException {
        return this.ojiOracleBlob.isSecureFile();
    }

    @Override
    public OutputStream getBinaryOutputStream(long pos) throws SQLException {
        return this.ojiOracleBlob.getBinaryOutputStream(pos);
    }

    @Override
    public InputStream getBinaryStream(long pos) throws SQLException {
        return this.ojiOracleBlob.getBinaryStream(pos);
    }

    @Override
    public void trim(long newlen) throws SQLException {
        this.ojiOracleBlob.trim(newlen);
    }

    public static BLOB createTemporary(Connection conn, boolean cache, int _duration) throws SQLException {
        int duration = _duration;
        if (_duration == 1) {
            duration = 10;
        }
        if (_duration == 2) {
            duration = 12;
        }
        if (conn == null || duration != 10 && duration != 12) {
            throw (SQLException)DatabaseError.createSqlException(68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or to DURATION_CALL").fillInStackTrace();
        }
        OracleConnection physConn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        return BLOB.getDBAccess(physConn).createTemporaryBlob(physConn, cache, duration);
    }

    public static void freeTemporary(BLOB temp_lob) throws SQLException {
        if (temp_lob == null) {
            return;
        }
        temp_lob.freeTemporary();
    }

    public static boolean isTemporary(BLOB lob) throws SQLException {
        if (lob == null) {
            return false;
        }
        return lob.isTemporary();
    }

    public static short getDuration(BLOB lob) throws SQLException {
        if (lob == null) {
            return -1;
        }
        return lob.getDuration();
    }

    @Override
    public void freeTemporary() throws SQLException {
        this.ojiOracleBlob.freeTemporary();
    }

    @Override
    public boolean isTemporary() throws SQLException {
        return this.ojiOracleBlob.isTemporary();
    }

    @Override
    public short getDuration() throws SQLException {
        return this.ojiOracleBlob.getDuration();
    }

    @Override
    public void openLob(LargeObjectAccessMode mode) throws SQLException {
        this.ojiOracleBlob.openLob(mode);
    }

    @Deprecated
    public void open(int mode) throws SQLException {
        this.openLob(mode);
    }

    public void openLob(int mode) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        this.target.openLob(mode);
    }

    @Override
    public void closeLob() throws SQLException {
        this.ojiOracleBlob.closeLob();
    }

    @Override
    public boolean isOpenLob() throws SQLException {
        return this.ojiOracleBlob.isOpenLob();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.ojiOracleBlob.setBytes(pos, bytes);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return this.ojiOracleBlob.setBytes(pos, bytes, offset, len);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        return this.ojiOracleBlob.setBinaryStream(pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.ojiOracleBlob.truncate(len);
    }

    @Override
    public Object toJdbc() throws SQLException {
        this.ojiOracleBlob.toJdbc();
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        return this.ojiOracleBlob.isConvertibleTo(jClass);
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.ojiOracleBlob.characterStreamValue();
    }

    public Reader characterStreamValue(boolean isInternal) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.characterStreamValue(isInternal);
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.ojiOracleBlob.asciiStreamValue();
    }

    public InputStream asciiStreamValue(boolean isInternal) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.asciiStreamValue(isInternal);
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.ojiOracleBlob.binaryStreamValue();
    }

    @Override
    public InputStream binaryStreamValue(boolean isInternal) throws SQLException {
        return this.ojiOracleBlob.binaryStreamValue(isInternal);
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return this.ojiOracleBlob.makeJdbcArray(arraySize);
    }

    @Override
    public BlobDBAccess getDBAccess() throws SQLException {
        return this.ojiOracleBlob.getDBAccess();
    }

    public static BlobDBAccess getDBAccess(Connection conn) throws SQLException {
        try (Monitor.CloseableLock lock = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().acquireCloseableLock();){
            BlobDBAccess blobDBAccess = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().createBlobDBAccess();
            return blobDBAccess;
        }
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return this.ojiOracleBlob.getJavaSqlConnection();
    }

    @Override
    public final void setLength(long _length) {
        this.ojiOracleBlob.setLength(_length);
    }

    @Override
    public final void setChunkSize(int _dbChunkSize) {
        this.ojiOracleBlob.setChunkSize(_dbChunkSize);
    }

    public final void setPrefetchedData(byte[] _prefetchData) {
        this.setPrefetchedData(_prefetchData, _prefetchData == null ? 0 : _prefetchData.length);
    }

    public final void setPrefetchedData(byte[] _prefetchData, int _size) {
        this.setPrefetchData(_prefetchData == null ? null : OracleLargeObject.PrefetchData.wrapArray(_prefetchData, _size));
    }

    @Override
    public final void setPrefetchData(OracleLargeObject.PrefetchData<byte[]> prefetchData) {
        this.ojiOracleBlob.setPrefetchData(prefetchData);
    }

    @Override
    public final OracleLargeObject.PrefetchData<byte[]> getPrefetchData() {
        return this.ojiOracleBlob.getPrefetchData();
    }

    public final byte[] getPrefetchedData() {
        OracleLargeObject.PrefetchData prefetchData = this.ojiOracleBlob.getPrefetchData();
        return prefetchData == null ? null : (byte[])prefetchData.share();
    }

    public final int getPrefetchedDataSize() {
        OracleLargeObject.PrefetchData prefetchData = this.ojiOracleBlob.getPrefetchData();
        return prefetchData == null ? 0 : prefetchData.length();
    }

    @Override
    public final void setActivePrefetch(boolean _activePrefetch) {
        this.ojiOracleBlob.setActivePrefetch(_activePrefetch);
    }

    @Override
    public final void clearCachedData() {
        this.ojiOracleBlob.clearCachedData();
    }

    @Override
    public final boolean isActivePrefetch() {
        return this.ojiOracleBlob.isActivePrefetch();
    }

    @Override
    public boolean canReadBasicLobDataInLocator() throws SQLException {
        return this.ojiOracleBlob.canReadBasicLobDataInLocator();
    }

    @Override
    public void freeLOB() throws SQLException {
        this.free();
    }

    @Override
    public void free() throws SQLException {
        this.ojiOracleBlob.free();
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return this.ojiOracleBlob.getBinaryStream(pos, length);
    }

    @Override
    public void setBytes(byte[] locator) {
        this.ojiOracleBlob.setBytes(locator);
    }

    @Override
    public void setACProxy(Object w) {
        this.ojiOracleBlob.setACProxy(w);
    }

    @Override
    public Object getACProxy() {
        return this.ojiOracleBlob.getACProxy();
    }

    public oracle.jdbc.internal.OracleBlob getInternal() {
        return this.ojiOracleBlob;
    }

    @Override
    public SQLXML toSQLXML() throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.toSQLXML(this.getPhysicalConnection().getDbCsId());
    }

    @Override
    public SQLXML toSQLXML(int csid) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return new XMLType((Connection)this.getPhysicalConnection(), this, csid);
    }

    @Override
    public final boolean isFree() {
        return this.ojiOracleBlob.isFree();
    }
}

