/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.layout.controller;

import com.wego168.exception.WegoException;
import com.wego168.layout.domain.LayoutAppComponent;
import com.wego168.layout.service.LayoutAppComponentService;
import com.wego168.util.Checker;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LayoutAppComponentController
extends SimpleController {
    @Autowired
    private LayoutAppComponentService layoutAppComponentService;

    @GetMapping(value={"/api/v1.0/layout-app-component/get"})
    public RestResponse get(String layoutAppId, String fileId) {
        try {
            Checker.checkBlankAndLength((String)layoutAppId, (String)"\u9875\u9762\u5e94\u7528id", (int)32);
            Checker.checkBlankAndLength((String)fileId, (String)"\u9875\u9762id", (int)64);
            LayoutAppComponent appComponent = this.layoutAppComponentService.selectByFileId(layoutAppId, fileId);
            return RestResponse.success((Object)((Object)appComponent));
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

