/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.layout.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.domain.BaseDomain;
import com.wego168.exception.WegoException;
import com.wego168.layout.config.ProjectFileConfig;
import com.wego168.layout.domain.LayoutApp;
import com.wego168.layout.domain.LayoutAppComponent;
import com.wego168.layout.enums.BuildStatusEnum;
import com.wego168.layout.next.FileUtil;
import com.wego168.layout.service.LayoutAppComponentService;
import com.wego168.layout.service.LayoutAppService;
import com.wego168.layout.task.RunBuildTask;
import com.wego168.layout.util.BuildUtil;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LayoutAppController
extends SimpleController {
    @Autowired
    private LayoutAppService layoutAppService;
    @Autowired
    private LayoutAppComponentService layoutAppComponentService;
    @Autowired
    private ProjectFileConfig projectFileConfig;
    @Autowired
    private RunBuildTask runBuildTask;
    private Logger logger = LoggerFactory.getLogger(LayoutAppController.class);

    @PostMapping(value={"/api/v1.1/layout-app/insert"})
    public RestResponse createApp2(@RequestParam(required=false, name="json") String jsonString, String projectName, String projectApi, String wechatAppId, String cosHost, String id, String homePath) {
        try {
            String operatingUser = this.layoutAppService.getNpmBuildingUser();
            Checker.checkCondition((boolean)StringUtil.isNotBlank((String)operatingUser), (String)"\u7cfb\u7edf\u6b63\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            Checker.checkBlank((String)jsonString, (String)"\u9875\u9762\u5185\u5bb9");
            Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
            Checker.checkBlankAndLength((String)projectName, (String)"\u9879\u76ee\u540d", (int)64);
            Checker.checkBlankAndLength((String)projectApi, (String)"\u9879\u76eeapi", (int)256);
            Checker.checkBlankAndLength((String)wechatAppId, (String)"appid", (int)64);
            Checker.checkBlankAndLength((String)cosHost, (String)"\u5b58\u50a8\u670d\u52a1\u5668\u4e3b\u673a", (int)256);
            Checker.checkBlank((String)homePath, (String)"\u9996\u9875\u8def\u5f84");
            String window = null;
            String tabBar = null;
            String pages = null;
            String theme = null;
            JSONArray templates = null;
            JSONArray images = null;
            try {
                JSONObject json = JSONObject.parseObject((String)jsonString);
                JSONObject appJson = json.getJSONObject("app");
                JSONObject windowJson = appJson.getJSONObject("window");
                window = windowJson.toString();
                JSONObject tabBarJson = appJson.getJSONObject("tabbar");
                tabBar = tabBarJson.toString();
                JSONArray pagesJson = appJson.getJSONArray("pages");
                pages = pagesJson.toString();
                templates = json.getJSONArray("templates");
                images = json.getJSONArray("images");
                theme = json.getString("theme");
            }
            catch (Exception e) {
                e.printStackTrace();
                Checker.checkCondition((boolean)true, (String)"\u9875\u9762\u5185\u5bb9\u89e3\u6790\u5931\u8d25");
            }
            String appId = this.getAppId();
            ArrayList<LayoutAppComponent> appComponents = new ArrayList<LayoutAppComponent>(templates.size());
            int i = 0;
            while (i < templates.size()) {
                JSONObject template = templates.getJSONObject(i);
                String indexJsDirName = template.getString("file");
                LayoutAppComponent appComponent = new LayoutAppComponent();
                BaseDomainUtil.initBaseDomain((BaseDomain)appComponent, (String)appId);
                appComponent.setJson(template.getJSONArray("components").toString());
                appComponent.setLayoutAppId(id);
                appComponent.setSortNumber(i + 1);
                appComponent.setUserId(appId);
                appComponent.setFileId(indexJsDirName);
                appComponents.add(appComponent);
                ++i;
            }
            String firstIndexDirName = null;
            String indexJsDir = this.projectFileConfig.getIndexJsDir();
            int i2 = 0;
            while (i2 < templates.size()) {
                JSONObject template = templates.getJSONObject(i2);
                String indexJsDirName = template.getString("file");
                if (i2 == 0) {
                    firstIndexDirName = indexJsDirName;
                }
                String indexJsDirPath = String.valueOf(indexJsDir) + "/" + indexJsDirName;
                FileUtil.deleteIndexJsAndDir(indexJsDirPath);
                ++i2;
            }
            LayoutApp layoutApp = (LayoutApp)((Object)this.layoutAppService.selectById(id));
            if (layoutApp == null) {
                layoutApp = new LayoutApp();
                BaseDomainUtil.initBaseDomain((BaseDomain)layoutApp, (String)appId);
                layoutApp.setId(id);
                layoutApp.setBuildStatus(BuildStatusEnum.BUILDING.value());
                layoutApp.setJson(jsonString);
                layoutApp.setModule(projectName);
                layoutApp.setVersion("1.0.0");
                layoutApp.setUserId(appId);
                layoutApp.setDownloadUrl("http://shareprint-1255600302.cosgz.myqcloud.com/test/" + firstIndexDirName + ".zip");
                this.layoutAppService.insert((Object)layoutApp);
            } else {
                layoutApp.setJson(jsonString);
                layoutApp.setBuildStatus(BuildStatusEnum.BUILDING.value());
                layoutApp.setModule(projectName);
                layoutApp.setVersion("1.0.0");
                layoutApp.setCreateTime(new Date());
                layoutApp.setDownloadUrl("http://shareprint-1255600302.cosgz.myqcloud.com/test/" + firstIndexDirName + ".zip");
                this.layoutAppService.updateSelective((Object)layoutApp);
                this.layoutAppComponentService.delete(JpaCriteria.builder().eq("layoutAppId", (Object)id));
            }
            this.layoutAppComponentService.insertBatch(appComponents);
            try {
                String buildResultOutputLocation = this.projectFileConfig.getBuildResultOutputLocation(id);
                File buildResultFile = new File(buildResultOutputLocation);
                if (buildResultFile.exists()) {
                    buildResultFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.runBuildTask.runBuildAsync(id, projectName, wechatAppId, projectApi, homePath, cosHost, theme, templates, images, pages, window, tabBar, appId);
            this.logger.error("\u98de\u8f6e\u9b54\u76d2\u63d0\u4ea4\u6210\u529f\uff0cid\uff1a{}", (Object)id);
            return RestResponse.success((Object)firstIndexDirName, (String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (WegoException e) {
            e.printStackTrace();
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1.1/layout-app/query-build-result"})
    public RestResponse queryBuildResult(String id) {
        Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
        String buildResultOutputLocation = this.projectFileConfig.getBuildResultOutputLocation(id);
        File buildResultFile = new File(buildResultOutputLocation);
        Bootmap bootmap = new Bootmap();
        bootmap.put((Object)"message", (Object)"\u6b63\u5728\u7f16\u8bd1\u4e2d....");
        bootmap.put((Object)"status", (Object)"building");
        if (!buildResultFile.exists()) {
            return RestResponse.success((Object)bootmap);
        }
        String buildStatus = BuildStatusEnum.FAIL.value();
        List<String> buildResult = BuildUtil.analysisBuildResult(buildResultFile);
        boolean buildResultHasError = BuildUtil.buildResultHasError(buildResult);
        if (buildResultHasError) {
            bootmap.put((Object)"message", (Object)"\u7f16\u8bd1\u5931\u8d25");
            bootmap.put((Object)"status", (Object)buildStatus);
            bootmap.put((Object)"trace", buildResult);
            this.layoutAppService.updateBuildStatus(id, buildStatus);
            return RestResponse.error((Object)bootmap);
        }
        buildStatus = BuildStatusEnum.FINISH.value();
        bootmap.put((Object)"message", (Object)"\u7f16\u8bd1\u6210\u529f");
        bootmap.put((Object)"status", (Object)buildStatus);
        this.layoutAppService.updateBuildStatus(id, buildStatus);
        return RestResponse.success((Object)bootmap);
    }

    @GetMapping(value={"/api/v1.0/layout-app/page"})
    public RestResponse selectPage(HttpServletRequest request) {
        Page page = this.buildPage(request);
        String userId = this.getAppId();
        page.eq("userId", (Object)userId);
        page.eq("isDeleted", (Object)false);
        page.orderBy("createTime desc");
        page.select("id,module,version,createTime,updateTime,downloadUrl,buildStatus, status, userDesc, userVersion, path, auditMsg");
        List list = this.layoutAppService.selectPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1.0/layout-app/get"})
    public RestResponse get(String id) {
        LayoutApp layoutApp = (LayoutApp)((Object)this.layoutAppService.selectById(id));
        return RestResponse.success((Object)((Object)layoutApp));
    }

    @PostMapping(value={"/api/v1.0/layout-app/delete"})
    public RestResponse delete(String id) {
        Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
        this.layoutAppService.updateDelete(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/v1.0/layout-app/update"})
    public RestResponse update(String id) {
        Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
        this.layoutAppService.updateDelete(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/v1.0/clean"})
    public RestResponse clean() {
        String user = this.layoutAppService.getNpmBuildingUser();
        this.layoutAppService.cleanNpmBuildingUser();
        return RestResponse.success((String)user);
    }

    @PostMapping(value={"/api/v1.2/layout-app/insert"})
    public RestResponse createApp3(@RequestParam(required=false, name="json") String jsonString, String id, String extJson, String status, String userVersion, String userDesc, String path) {
        String operatingUser = this.layoutAppService.getNpmBuildingUser();
        Checker.checkCondition((boolean)StringUtil.isNotBlank((String)operatingUser), (String)"\u7cfb\u7edf\u6b63\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        Checker.checkBlank((String)jsonString, (String)"\u9875\u9762\u5185\u5bb9");
        Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
        JSONArray templates = null;
        try {
            JSONObject json = JSONObject.parseObject((String)jsonString);
            templates = json.getJSONArray("templates");
        }
        catch (Exception e) {
            e.printStackTrace();
            Checker.checkCondition((boolean)true, (String)"\u9875\u9762\u5185\u5bb9\u89e3\u6790\u5931\u8d25");
        }
        String appId = this.getAppId();
        ArrayList<LayoutAppComponent> appComponents = new ArrayList<LayoutAppComponent>(templates.size());
        int i = 0;
        while (i < templates.size()) {
            JSONObject template = templates.getJSONObject(i);
            String indexJsDirName = template.getString("file");
            LayoutAppComponent appComponent = new LayoutAppComponent();
            BaseDomainUtil.initBaseDomain((BaseDomain)appComponent, (String)appId);
            appComponent.setJson(template.getJSONArray("components").toString());
            appComponent.setLayoutAppId(id);
            appComponent.setSortNumber(i + 1);
            appComponent.setUserId(appId);
            appComponent.setFileId(indexJsDirName);
            appComponents.add(appComponent);
            ++i;
        }
        LayoutApp layoutApp = (LayoutApp)((Object)this.layoutAppService.selectById(id));
        if (layoutApp == null) {
            layoutApp = new LayoutApp();
            BaseDomainUtil.initBaseDomain((BaseDomain)layoutApp, (String)appId);
            layoutApp.setId(id);
            layoutApp.setBuildStatus(BuildStatusEnum.BUILDING.value());
            layoutApp.setJson(jsonString);
            layoutApp.setModule(this.getAppId());
            layoutApp.setVersion("1.0.0");
            layoutApp.setUserId(appId);
            layoutApp.setDownloadUrl(this.getAppId());
            layoutApp.setExtJson(extJson);
            layoutApp.setStatus(status);
            layoutApp.setUserDesc(userDesc);
            layoutApp.setUserVersion(userVersion);
            layoutApp.setPath(path);
            this.layoutAppService.insert((Object)layoutApp);
        } else {
            layoutApp.setJson(jsonString);
            layoutApp.setBuildStatus(BuildStatusEnum.BUILDING.value());
            layoutApp.setModule(this.getAppId());
            layoutApp.setVersion("1.0.0");
            layoutApp.setCreateTime(new Date());
            layoutApp.setDownloadUrl(this.getAppId());
            layoutApp.setExtJson(extJson);
            layoutApp.setStatus(status);
            layoutApp.setUserDesc(userDesc);
            layoutApp.setUserVersion(userVersion);
            layoutApp.setPath(path);
            this.layoutAppService.updateSelective((Object)layoutApp);
            this.layoutAppComponentService.delete(JpaCriteria.builder().eq("layoutAppId", (Object)id));
        }
        this.layoutAppComponentService.insertBatch(appComponents);
        return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/api/v1.2/layout-app/get"})
    public RestResponse get3(String id) {
        return RestResponse.success((Object)this.layoutAppService.selectById(id));
    }

    @PostMapping(value={"/api/v1.2/layout-app/updateStatus"})
    public RestResponse updateStatus(String id, String status, String auditMsg) {
        LayoutApp layoutApp = (LayoutApp)((Object)this.layoutAppService.selectById(id));
        layoutApp.setStatus(status);
        layoutApp.setAuditMsg(auditMsg);
        this.layoutAppService.updateSelective((Object)layoutApp);
        return RestResponse.success((Object)((Object)layoutApp));
    }
}

