/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.layout.controller;

import com.simple.mybatis.JpaCriteria;
import com.wego168.domain.BaseDomain;
import com.wego168.layout.domain.LayoutAppStatus;
import com.wego168.layout.service.LayoutAppStatusService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.ServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminLayoutAppStatusController")
public class LayoutAppStatusController
extends SimpleController {
    @Autowired
    private LayoutAppStatusService service;
    @Autowired
    private WxAppService wxAppService;

    @GetMapping(value={"/api/admin/v1/layout-app-status/get"})
    public RestResponse get(String purpose, String status, String code) {
        WxApp app = this.getWxApp(purpose);
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("orgId", (Object)app.getOrgId());
        criteria.eq("code", (Object)code);
        if (StringUtil.isNotBlank((String)status)) {
            criteria.eq("status", (Object)status);
        }
        criteria.orderBy("updateTime DESC");
        List list = this.service.selectList(criteria);
        if (Checker.listIsEmpty((List)list)) {
            return RestResponse.success(null);
        }
        return RestResponse.success(list.get(0));
    }

    @PostMapping(value={"/api/admin/v1/layout-app-status/saveOrUpdate"})
    public RestResponse saveOrUpdate(@RequestBody LayoutAppStatus layoutAppStatus) {
        String id = layoutAppStatus.getId();
        if (StringUtil.isNotBlank((String)id)) {
            return this.update(layoutAppStatus);
        }
        return this.insert(layoutAppStatus);
    }

    private WxApp getWxApp(String purpose) {
        if (StringUtil.isBlank((String)purpose)) {
            return this.wxAppService.ensureMiniProgramApp(super.getAppId());
        }
        int serviceType = ServiceTypeEnum.PROGRAM.id();
        WxApp wxApp = this.wxAppService.selectByPurpose(super.getAppId(), serviceType, purpose);
        Checker.checkCondition((wxApp == null ? 1 : 0) != 0, (String)"\u5c0f\u7a0b\u5e8f\u672a\u914d\u7f6e");
        return wxApp;
    }

    private RestResponse update(LayoutAppStatus layoutAppStatus) {
        layoutAppStatus.setUpdateTime(new Date());
        this.service.updateSelective((Object)layoutAppStatus);
        return RestResponse.success((String)"ok");
    }

    private RestResponse insert(LayoutAppStatus layoutAppStatus) {
        BaseDomainUtil.initBaseDomain((BaseDomain)layoutAppStatus, (String)this.getAppId());
        String purpose = layoutAppStatus.getPurpose();
        WxApp app = this.getWxApp(purpose);
        layoutAppStatus.setWxAppId(app.getWxAppId());
        layoutAppStatus.setOrgId(app.getOrgId());
        this.service.insert((Object)layoutAppStatus);
        return RestResponse.success((String)"ok");
    }
}

