/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.layout.enums;

import com.wego168.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum LayoutAppStatusEnum {
    AUDIT_SUCCESS("AUDIT_SUCCESS", "\u5ba1\u6838\u901a\u8fc7"),
    AUDIT_FAIL("AUDIT_FAIL", "\u5ba1\u6838\u4e0d\u901a\u8fc7"),
    AUDIT_GOING("AUDIT_GOING", "\u5ba1\u6838\u4e2d"),
    AUDIT_UNDO("AUDIT_UNDO", "\u64a4\u9500\u5ba1\u6838"),
    AUDIT_DELAY("AUDIT_DELAY", "\u5ba1\u6838\u5ef6\u540e"),
    AUDIT_RELEASE("AUDIT_RELEASE", "\u6b63\u5f0f\u53d1\u5e03");

    private String value;
    private String description;
    private static final Map<String, String> valueMapping;
    private static final Map<String, LayoutAppStatusEnum> objectMapping;

    static {
        valueMapping = new ConcurrentHashMap<String, String>();
        objectMapping = new HashMap<String, LayoutAppStatusEnum>();
        LayoutAppStatusEnum[] layoutAppStatusEnumArray = LayoutAppStatusEnum.values();
        int n = layoutAppStatusEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutAppStatusEnum item = layoutAppStatusEnumArray[n2];
            valueMapping.put(item.value(), item.description());
            objectMapping.put(item.value(), item);
            ++n2;
        }
    }

    private LayoutAppStatusEnum(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String value() {
        return this.value;
    }

    public String description() {
        return this.description;
    }

    public static boolean isValid(String value) {
        return valueMapping.containsKey(value);
    }

    public static LayoutAppStatusEnum get(String key) {
        return objectMapping.get(key);
    }

    public static LayoutAppStatusEnum weChatEventTranslation(String event) {
        if (StringUtil.equalsIgnoreCase((String)"weapp_audit_success", (String)event)) {
            return AUDIT_SUCCESS;
        }
        if (StringUtil.equalsIgnoreCase((String)"weapp_audit_fail", (String)event)) {
            return AUDIT_FAIL;
        }
        if (StringUtil.equalsIgnoreCase((String)"weapp_audit_delay", (String)event)) {
            return AUDIT_DELAY;
        }
        return null;
    }
}

