/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.layout.service;

import com.wego168.layout.domain.LayoutApp;
import com.wego168.layout.persistence.LayoutAppMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.BaseService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutAppService
extends BaseService<LayoutApp> {
    @Autowired
    private LayoutAppMapper layoutAppMapper;
    @Autowired
    private SimpleRedisTemplate redisTemplate;

    public CrudMapper<LayoutApp> getMapper() {
        return this.layoutAppMapper;
    }

    public void setNpmBuildingStart(String userId) {
        this.redisTemplate.setString("npm_building", userId);
    }

    public void setNpmBuildingEnd() {
        this.redisTemplate.delete(new String[]{"npm_building"});
    }

    public String getNpmBuildingUser() {
        return this.redisTemplate.getString("npm_building");
    }

    public void cleanNpmBuildingUser() {
        this.redisTemplate.delete(new String[]{"npm_building"});
    }

    public void updateBuildStatus(String id, String buildStatus) {
        LayoutApp param = new LayoutApp();
        param.setId(id);
        param.setUpdateTime(new Date());
        param.setBuildStatus(buildStatus);
        this.layoutAppMapper.updateSelective((Object)param);
    }
}

