/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.layout.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.layout.domain.LayoutAppStatus;
import com.wego168.layout.enums.LayoutAppStatusEnum;
import com.wego168.layout.persistence.LayoutAppStatusMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.StringUtil;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.persistence.WxAppMapper;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutAppStatusService
extends BaseService<LayoutAppStatus> {
    @Autowired
    private LayoutAppStatusMapper mapper;
    @Autowired
    private WxAppMapper wxAppMapper;
    private static final Logger logger = LoggerFactory.getLogger(LayoutAppStatusService.class);

    public CrudMapper<LayoutAppStatus> getMapper() {
        return this.mapper;
    }

    public LayoutAppStatus selectByCode(String wxAppId, String code) {
        JpaCriteria criteria = JpaCriteria.builder().eq("code", (Object)code).eq("wxAppId", (Object)wxAppId);
        return (LayoutAppStatus)((Object)this.mapper.select(criteria));
    }

    public void doWeAppAudit(Map<String, String> msg) {
        String code;
        logger.error("\u5c0f\u7a0b\u5e8f\u5ba1\u6838\u4e8b\u4ef6\uff0c{}", msg);
        String orgId = msg.get("ToUserName");
        WxApp wxApp = (WxApp)this.wxAppMapper.select(JpaCriteria.builder().eq("orgId", (Object)orgId));
        if (wxApp == null) {
            logger.error("\u627e\u4e0d\u5230\u5bf9\u63a5\u5c0f\u7a0b\u5e8f\uff0c\u5c0f\u7a0b\u5e8f\u539f\u59cbid\u4e3a{}", (Object)orgId);
            return;
        }
        String appId = wxApp.getAppId();
        String wxAppId = wxApp.getWxAppId();
        LayoutAppStatus layoutAppStatus = this.selectByCode(wxAppId, code = "audit");
        if (layoutAppStatus == null) {
            layoutAppStatus = (LayoutAppStatus)((Object)this.select(JpaCriteria.builder().eq("code", (Object)"audit").eq("appId", (Object)appId)));
        }
        layoutAppStatus.setStatus(LayoutAppStatusEnum.weChatEventTranslation(msg.get("Event")).value());
        if (StringUtil.isNotBlank((String)msg.get("Reason"))) {
            layoutAppStatus.setReason(msg.get("Reason"));
        }
        if (StringUtil.isNotBlank((String)msg.get("ScreenShot"))) {
            layoutAppStatus.setScreenShot(msg.get("ScreenShot"));
        }
        if (StringUtil.isNotBlank((String)msg.get("SuccTime"))) {
            layoutAppStatus.setSuccTime(new Date(Long.valueOf(msg.get("SuccTime")) * 1000L));
        }
        if (StringUtil.isNotBlank((String)msg.get("FailTime"))) {
            layoutAppStatus.setFailTime(new Date(Long.valueOf(msg.get("FailTime")) * 1000L));
        }
        if (StringUtil.isNotBlank((String)msg.get("DelayTime"))) {
            layoutAppStatus.setDelayTime(new Date(Long.valueOf(msg.get("DelayTime")) * 1000L));
        }
        layoutAppStatus.setUpdateTime(new Date());
        this.updateSelective((Object)layoutAppStatus);
    }
}

