/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.layout.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.domain.BaseDomain;
import com.wego168.layout.config.ProjectFileConfig;
import com.wego168.layout.controller.LayoutAppController;
import com.wego168.layout.domain.LayoutAppComponent;
import com.wego168.layout.next.CmdUtil;
import com.wego168.layout.next.FileUtil;
import com.wego168.layout.service.LayoutAppService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class RunBuildTask {
    @Autowired
    private ProjectFileConfig projectFileConfig;
    @Autowired
    private LayoutAppService layoutAppService;
    private Logger logger = LoggerFactory.getLogger(LayoutAppController.class);

    @Async
    public void runBuildAsync(String id, String projectName, String wechatAppId, String projectApi, String homePath, String cosHost, String theme, JSONArray templates, JSONArray images, String pages, String window, String tabBar, String appId) {
        String project = this.projectFileConfig.getProjectRootDir();
        this.layoutAppService.setNpmBuildingStart(appId);
        this.logger.error("\u98de\u8f6e\u9b54\u76d2\u5f00\u59cb\u7f16\u8bd1\uff0cid\uff1a{}", (Object)id);
        if (images != null && images.size() > 0) {
            File[] imageFiles;
            String imageDirPath = this.projectFileConfig.getImageDir();
            File imagesDir = new File(imageDirPath);
            if (!imagesDir.exists()) {
                imagesDir.mkdirs();
            }
            if ((imageFiles = imagesDir.listFiles()) != null && imageFiles.length > 0) {
                File[] fileArray = imageFiles;
                int n = imageFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File imageFile = fileArray[n2];
                    imageFile.delete();
                    ++n2;
                }
            }
            int i = 0;
            while (i < images.size()) {
                JSONObject imageJson = images.getJSONObject(i);
                String imageCosUrl = imageJson.getString("url");
                Checker.checkBlank((String)imageCosUrl, (String)"\u56fe\u7247\u5730\u5740");
                String imageName = imageJson.getString("name");
                Checker.checkBlank((String)imageName, (String)"\u56fe\u7247\u540d\u79f0");
                com.wego168.base.util.FileUtil.downloadFile((String)imageCosUrl, (String)imageName, (String)imageDirPath);
                ++i;
            }
        }
        this.logger.error("\u98de\u8f6e\u9b54\u76d2\u56fe\u7247\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210\uff0cid\uff1a{}", (Object)id);
        VelocityContext templateAppJsContext = new VelocityContext();
        templateAppJsContext.put("pages", (Object)("\"pages\":" + pages));
        templateAppJsContext.put("window", (Object)("\"window\":" + window));
        templateAppJsContext.put("tabBar", (Object)("\"tabBar\":" + tabBar));
        String templateAppJsLocation = this.projectFileConfig.getTemplateAppJsLocation();
        String appJsLocation = this.projectFileConfig.getAppJsLocation();
        FileUtil.replaceTemplate(templateAppJsLocation, appJsLocation, templateAppJsContext);
        VelocityContext projectConfigJsonContext = new VelocityContext();
        projectConfigJsonContext.put("projectName", (Object)projectName);
        projectConfigJsonContext.put("wechatAppId", (Object)wechatAppId);
        String templateProjectConfigJsonLocation = this.projectFileConfig.getTemplateProjectConfigJsonLocation();
        String projectConfigJsonLocation = this.projectFileConfig.getProjectConfigJsonLocation();
        FileUtil.replaceTemplate(templateProjectConfigJsonLocation, projectConfigJsonLocation, projectConfigJsonContext);
        VelocityContext indexTsContext = new VelocityContext();
        indexTsContext.put("projectApi", (Object)projectApi);
        indexTsContext.put("cosHost", (Object)cosHost);
        indexTsContext.put("HOME_PATH", (Object)homePath);
        String templateIndexTsLocation = this.projectFileConfig.getTemplateIndexTsLocation();
        String indexTsLocation = this.projectFileConfig.getIndexTsLocation();
        FileUtil.replaceTemplate(templateIndexTsLocation, indexTsLocation, indexTsContext);
        VelocityContext themeScssContext = new VelocityContext();
        themeScssContext.put("theme", (Object)theme);
        String templateThemeScssLocation = this.projectFileConfig.getTemplateThemeScssLocation();
        String themeScssLocation = this.projectFileConfig.getThemeScssLocation();
        FileUtil.replaceTemplate(templateThemeScssLocation, themeScssLocation, themeScssContext);
        this.logger.error("\u98de\u8f6e\u9b54\u76d2\u6a21\u7248\u6587\u4ef6\u66ff\u6362\u5b8c\u6210\uff0cid\uff1a{}", (Object)id);
        ArrayList<LayoutAppComponent> appComponents = new ArrayList<LayoutAppComponent>(templates.size());
        String indexJsDir = this.projectFileConfig.getIndexJsDir();
        int i = 0;
        while (i < templates.size()) {
            JSONObject template = templates.getJSONObject(i);
            String indexJsDirName = template.getString("file");
            String indexJsCode = template.getString("code");
            String indexJsDirPath = String.valueOf(indexJsDir) + "/" + indexJsDirName;
            FileUtil.createIndexJs(indexJsCode, indexJsDirPath);
            this.logger.error("\u98de\u8f6e\u9b54\u76d2\u521b\u5efa\u6587\u4ef6\uff1a{}", (Object)indexJsDirPath);
            LayoutAppComponent appComponent = new LayoutAppComponent();
            BaseDomainUtil.initBaseDomain((BaseDomain)appComponent, (String)appId);
            appComponent.setJson(template.getJSONArray("components").toString());
            appComponent.setLayoutAppId(id);
            appComponent.setSortNumber(i + 1);
            appComponent.setUserId(appId);
            appComponent.setFileId(indexJsDirName);
            appComponents.add(appComponent);
            ++i;
        }
        List<String> cmds = CmdUtil.cdIntoDir(project);
        cmds.add("build.bat");
        cmds.add("exit");
        CmdUtil.executeCmd(cmds);
        this.logger.error("\u98de\u8f6e\u9b54\u76d2npm build\u5b8c\u6210\uff0cid\uff1a{}", (Object)id);
        String firstIndexDirName = null;
        int i2 = 0;
        while (i2 < templates.size()) {
            JSONObject template = templates.getJSONObject(i2);
            String indexJsDirName = template.getString("file");
            if (i2 == 0) {
                firstIndexDirName = indexJsDirName;
            }
            ++i2;
        }
        String buildResultLocation = this.projectFileConfig.getBuildResultLocation();
        String buildResultOutputLocation = this.projectFileConfig.getBuildResultOutputLocation(id);
        FileUtil.replaceTemplate(buildResultLocation, buildResultOutputLocation, new VelocityContext());
        this.layoutAppService.setNpmBuildingEnd();
        String distDir = this.projectFileConfig.getDistDir();
        String distZipDir = this.projectFileConfig.getDistZipDir();
        this.packageFileAndUpload(distDir, distZipDir, firstIndexDirName);
        this.logger.error("\u98de\u8f6e\u9b54\u76d2\u4ee3\u7801\u4e0a\u4f20\u5b8c\u6210\uff0cid\uff1a{}", (Object)id);
    }

    public void packageFileAndUpload(String distDirPath, String distOutputZipDirPath, String zipName) {
        File distDir = new File(distDirPath);
        File distZip = new File(String.valueOf(distOutputZipDirPath) + "/" + zipName + ".zip");
        ZipUtil.doCompress((File)distDir, (File)distZip);
        FileServer server = new FileServer();
        server.setArea("ap-guangzhou");
        server.setBucket("shareprint");
        server.setHostAppId("1255600302");
        server.setUsername("AKIDNfDdx9wz2MacTCx6GE0b5QZVhmjUwwsk");
        server.setPassword("1veosmU0KSO7ez8A1iEanphMo47ze7RZ");
        FileUploadUtil.upload2Cos((File)distZip, (String)"test", (String)(String.valueOf(zipName) + ".zip"), (FileServer)server);
    }
}

