/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.taobao.pandora.boot.loader.JarLauncher;
import com.taobao.pandora.boot.loader.LaunchedURLClassLoader;
import com.taobao.pandora.boot.loader.SarLoaderUtils;
import com.taobao.pandora.boot.loader.jmx.mbean.Health;
import com.taobao.pandora.boot.loader.util.AnsiLog;
import com.taobao.pandora.boot.loader.util.SystemPrintUtil;
import com.taobao.pandora.loader.archive.Archive;
import com.taobao.pandora.loader.archive.ExplodedArchive;
import com.taobao.pandora.loader.archive.JarFileArchive;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;

public class SarLauncher
extends JarLauncher {
    private static final String SAR_FILE = "BOOT-INF/lib/taobao-hsf.sar-all";
    private static long t1 = System.nanoTime();
    private String mainClass = null;

    public SarLauncher() {
    }

    protected SarLauncher(Archive archive) {
        super(archive);
    }

    @Override
    public ClassLoader createClassLoader(URL[] urls) throws Exception {
        Archive sar = this.findSar(urls);
        if (sar == null) {
            AnsiLog.warn("[PANDORA WARNING] Can NOT find pandora.sar or taobao-hsf.sar.");
        }
        ClassLoader classLoader = super.createClassLoader(this.excludeSar(urls, sar));
        this.loadSar(sar, classLoader);
        return classLoader;
    }

    public ClassLoader createClassLoaderWithParent(URL[] urls, ClassLoader parent) throws Exception {
        Archive sar = this.findSar(urls);
        if (sar == null) {
            AnsiLog.warn("[PANDORA WARNING] Can NOT find pandora.sar or taobao-hsf.sar.");
        }
        LaunchedURLClassLoader classLoader = new LaunchedURLClassLoader(this.excludeSar(urls, sar), parent);
        this.loadSar(sar, classLoader);
        return classLoader;
    }

    @Override
    protected boolean isNestedArchive(Archive.Entry entry) {
        return super.isNestedArchive(entry) && !entry.getName().startsWith(SAR_FILE);
    }

    private void loadSar(Archive sar, ClassLoader classLoader) throws Exception {
        if (sar != null && classLoader instanceof LaunchedURLClassLoader) {
            Map<String, Class<?>> classCache = SarLoaderUtils.getClassCache(sar, classLoader);
            ((LaunchedURLClassLoader)classLoader).setClassCache(classCache);
            SarLoaderUtils.markSarLoaderUtils(classLoader, "sarLoaded", true);
            ((LaunchedURLClassLoader)classLoader).collectStaticClassInfo();
        } else {
            SarLoaderUtils.markSarLoaderUtils(classLoader, "sarLoaded", false);
        }
        SarLoaderUtils.markSarLoaderUtils(classLoader, "t1", t1);
    }

    private Archive findSar(URL[] urls) throws Exception {
        Archive sar = SarLoaderUtils.findExternalSar();
        if (sar == null) {
            sar = SarLoaderUtils.findEmbeddedSar(this.getArchive());
        }
        if (sar == null) {
            sar = SarLoaderUtils.findFromClassPath(urls);
        }
        if (sar == null && (sar = SarLoaderUtils.findFromSystemClassLoader()) != null) {
            AnsiLog.warn("[PANDORA WARNING] Load pandora.sar/taobao-hsf.sar from system classloader's urls.");
        }
        return sar;
    }

    private URL[] excludeSar(URL[] urls, Archive sar) throws MalformedURLException {
        if (sar == null || sar.getUrl() == null) {
            return urls;
        }
        ArrayList<URL> others = new ArrayList<URL>();
        for (URL url : urls) {
            if (url.equals(sar.getUrl()) || ("jar:" + url + "!/").equals(sar.getUrl().toString())) continue;
            others.add(url);
        }
        return others.toArray(new URL[others.size()]);
    }

    @Override
    protected String getMainClass() throws Exception {
        if (this.mainClass != null) {
            return this.mainClass;
        }
        return super.getMainClass();
    }

    private static SarLauncher getSarLauncherInstance(String location) throws IOException {
        if (location == null) {
            return new SarLauncher();
        }
        File root = new File(location);
        if (root.exists()) {
            return root.isDirectory() ? new SarLauncher((Archive)new ExplodedArchive(root)) : new SarLauncher((Archive)new JarFileArchive(root));
        }
        throw new IllegalArgumentException("location is not either a valid directory or a valid jar file");
    }

    public static void main(String[] args) {
        try {
            if (SarLauncher.argsConatinPandoraLocation(args)) {
                AnsiLog.error("[ERROR] Please don't set -Dpandora.location in Program arguments, set in VM arguments. Google 'Program arguments VM arguments'.");
            }
            t1 = System.nanoTime();
            SystemPrintUtil.switchSystemPrint();
            SarLauncher sarLauncher = SarLauncher.getSarLauncher();
            sarLauncher.launch(SarLauncher.detectMainClassFromArgs(args, sarLauncher));
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }

    private static String[] detectMainClassFromArgs(String[] args, SarLauncher sarLauncher) {
        ArrayList<String> newArgs = new ArrayList<String>();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("--mainClass") && i + 1 < args.length) {
                    sarLauncher.mainClass = args[++i];
                    continue;
                }
                newArgs.add(args[i]);
            }
        }
        return newArgs.toArray(new String[newArgs.size()]);
    }

    private static SarLauncher getSarLauncher() throws IOException {
        String location = System.getProperty("app.location");
        return SarLauncher.getSarLauncherInstance(location);
    }

    private static boolean argsConatinPandoraLocation(String[] args) {
        if (args != null) {
            for (String arg : args) {
                if (!arg.contains("-Dpandora.location")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Health.registMBean();
    }
}

