/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.maven.sar;

import com.taobao.pandora.loader.archive.ExplodedArchive;
import com.taobao.pandora.loader.archive.JarFileArchive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;

public class SarArtifact
extends DefaultArtifact {
    static final String SAR_GROUP_ID = "com.taobao.pandora";
    static final String SAR_ARTIFACT_ID = "taobao-hsf.sar";
    static final String SAR_CONTAINER_ARTIFACT_ID = "taobao-hsf.sar-container";
    static final String SAR__ALL_ARTIFACT_ID = "taobao-hsf.sar-all";
    static final String SAR_PLUGIN_GROUPID = "com.taobao.pandora.plugin";

    public SarArtifact(File location) throws IOException {
        super(SAR_GROUP_ID, SAR_ARTIFACT_ID, "DEFAULT", "runtime", "sar", null, (ArtifactHandler)new DefaultArtifactHandler());
        this.setFile(location);
        this.setVersion(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVersion(File location) throws IOException {
        if (!location.exists()) {
            return;
        }
        JarFileArchive archive = location.isFile() ? new JarFileArchive(location) : new ExplodedArchive(location);
        URL url = archive.getResource("version.properties");
        Properties p = new Properties();
        InputStream is = null;
        try {
            is = url.openStream();
            p.load(is);
            String version = (String)p.get("sar");
            this.setVersion(version);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

