/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AggregatePostConnectProcessor
implements PostConnectProcessor {
    private final List<PostConnectProcessor> processors;

    public AggregatePostConnectProcessor(PostConnectProcessor ... processors) {
        this(StaticUtils.toList(processors));
    }

    public AggregatePostConnectProcessor(Collection<? extends PostConnectProcessor> processors) {
        this.processors = processors == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PostConnectProcessor>(processors));
    }

    @Override
    public void processPreAuthenticatedConnection(LDAPConnection connection) throws LDAPException {
        for (PostConnectProcessor p : this.processors) {
            p.processPreAuthenticatedConnection(connection);
        }
    }

    @Override
    public void processPostAuthenticatedConnection(LDAPConnection connection) throws LDAPException {
        for (PostConnectProcessor p : this.processors) {
            p.processPostAuthenticatedConnection(connection);
        }
    }
}

