/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.operation.relate.EdgeEndBundle;
import com.vividsolutions.jts.operation.relate.RelateNode;
import com.vividsolutions.jts.operation.relate.RelateNodeGraph;
import java.util.Iterator;

public class ConsistentAreaTester {
    private final LineIntersector li = new RobustLineIntersector();
    private GeometryGraph geomGraph;
    private RelateNodeGraph nodeGraph = new RelateNodeGraph();
    private Coordinate invalidPoint;

    public ConsistentAreaTester(GeometryGraph geomGraph) {
        this.geomGraph = geomGraph;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public boolean isNodeConsistentArea() {
        SegmentIntersector intersector = this.geomGraph.computeSelfNodes(this.li, true);
        if (intersector.hasProperIntersection()) {
            this.invalidPoint = intersector.getProperIntersectionPoint();
            return false;
        }
        this.nodeGraph.build(this.geomGraph);
        return this.isNodeEdgeAreaLabelsConsistent();
    }

    private boolean isNodeEdgeAreaLabelsConsistent() {
        Iterator nodeIt = this.nodeGraph.getNodeIterator();
        while (nodeIt.hasNext()) {
            RelateNode node = (RelateNode)nodeIt.next();
            if (node.getEdges().isAreaLabelsConsistent(this.geomGraph)) continue;
            this.invalidPoint = (Coordinate)node.getCoordinate().clone();
            return false;
        }
        return true;
    }

    public boolean hasDuplicateRings() {
        Iterator nodeIt = this.nodeGraph.getNodeIterator();
        while (nodeIt.hasNext()) {
            RelateNode node = (RelateNode)nodeIt.next();
            Iterator i = node.getEdges().iterator();
            while (i.hasNext()) {
                EdgeEndBundle eeb = (EdgeEndBundle)i.next();
                if (eeb.getEdgeEnds().size() <= 1) continue;
                this.invalidPoint = eeb.getEdge().getCoordinate(0);
                return true;
            }
        }
        return false;
    }
}

