/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.AndOrConditionException;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.BooleanConditionTypeEnum;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.List;

public class AndOrCondition
extends Condition {
    private BooleanConditionTypeEnum booleanConditionType;

    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        List<Executable> itemList = this.getItem();
        if (CollUtil.isEmpty(itemList)) {
            throw new AndOrConditionException("boolean item list is null");
        }
        boolean[] booleanArray = new boolean[itemList.size()];
        for (int i = 0; i < itemList.size(); ++i) {
            Executable item = itemList.get(i);
            item.setCurrChainId(this.getCurrChainId());
            item.execute(slotIndex);
            booleanArray[i] = (Boolean)item.getItemResultMetaValue(slotIndex);
        }
        BooleanConditionTypeEnum booleanConditionType = this.getBooleanConditionType();
        Slot slot = DataBus.getSlot(slotIndex);
        String resultKey = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{this.getClass().getName(), this.hashCode()});
        switch (booleanConditionType) {
            case AND: {
                slot.setAndOrResult(resultKey, BooleanUtil.and((boolean[])booleanArray));
                break;
            }
            case OR: {
                slot.setAndOrResult(resultKey, BooleanUtil.or((boolean[])booleanArray));
                break;
            }
            default: {
                throw new AndOrConditionException("condition type must be 'AND' or 'OR'");
            }
        }
    }

    public Boolean getItemResultMetaValue(Integer slotIndex) {
        Slot slot = DataBus.getSlot(slotIndex);
        String resultKey = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{this.getClass().getName(), this.hashCode()});
        return slot.getAndOrResult(resultKey);
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_AND_OR_OPT;
    }

    public void addItem(Executable item) {
        this.addExecutable("AND_OR_ITEM", item);
    }

    public List<Executable> getItem() {
        return this.getExecutableList("AND_OR_ITEM");
    }

    public BooleanConditionTypeEnum getBooleanConditionType() {
        return this.booleanConditionType;
    }

    public void setBooleanConditionType(BooleanConditionTypeEnum booleanConditionType) {
        this.booleanConditionType = booleanConditionType;
    }
}

