/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.elasticsearch;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.config.SapGlobalConfigProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import com.dtyunxi.sap.interceptor.enums.EsOperator;
import com.dtyunxi.sap.interceptor.util.FieldNameConverter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Aspect
@RefreshScope
public class SapEsInterceptor
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(SapEsInterceptor.class);
    private final SapConfigProperties sapConfigProperties;
    private final SapServiceContextProvider serviceContextProvider;
    private final SapGlobalConfigProvider globalConfigProvider;
    private final Map<String, SapConfigProperties.IndexMapping> indexMappingCache = new ConcurrentHashMap<String, SapConfigProperties.IndexMapping>();
    private static final ThreadLocal<Map<String, Integer>> LOCAL_STACK_MAP = new ThreadLocal();

    public SapEsInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider, SapGlobalConfigProvider globalConfigProvider) {
        this.sapConfigProperties = sapConfigProperties;
        this.serviceContextProvider = serviceContextProvider;
        this.globalConfigProvider = globalConfigProvider;
        this.refreshIndexMappingCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* com.dtyunxi.huieryun.opensearch.api.IOpenSearchService.search(..)) || execution(* *..*ElasticsearchService.search(..)) || execution(* *..*EsService.search(..))")
    public Object interceptEsSearch(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.isEsEnabled()) {
            logger.debug("SAP ES\u62e6\u622a\u5668\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7ES\u67e5\u8be2\u62e6\u622a\u5904\u7406");
            return joinPoint.proceed();
        }
        if (!this.isGloballyEnabled()) {
            logger.debug("SAP\u5168\u5c40\u5f00\u5173\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7ES\u67e5\u8be2\u62e6\u622a\u5904\u7406");
            return joinPoint.proceed();
        }
        Object[] args = joinPoint.getArgs();
        if (args.length == 0) {
            logger.debug("ES\u641c\u7d22\u65b9\u6cd5\u65e0\u53c2\u6570\uff0c\u8df3\u8fc7\u5904\u7406");
            return joinPoint.proceed();
        }
        Object searchVo = args[0];
        logger.debug("\u8fdb\u5165SAP ES\u5207\u9762\u62e6\u622a: {}", (Object)searchVo.getClass().getSimpleName());
        String indexName = this.extractIndexName(searchVo);
        if (StringUtils.isEmpty((Object)indexName)) {
            logger.debug("\u65e0\u6cd5\u63d0\u53d6\u7d22\u5f15\u540d\u79f0\uff0c\u8df3\u8fc7\u5904\u7406");
            return joinPoint.proceed();
        }
        logger.info("\u8fdb\u5165SAP ES\u5207\u9762! \u7d22\u5f15\u540d\u79f0: {}", (Object)indexName);
        String sapFlag = (String)this.serviceContextProvider.getAttachment("sap-flag");
        if (StringUtils.isEmpty((Object)sapFlag)) {
            logger.debug("\u672a\u68c0\u6d4b\u5230sap-flag\uff0c\u8df3\u8fc7ES\u67e5\u8be2\u62e6\u622a\u5904\u7406");
            return joinPoint.proceed();
        }
        logger.debug("\u68c0\u6d4b\u5230sap-flag: {}\uff0c\u5f00\u59cb\u5904\u7406ES\u67e5\u8be2\u62e6\u622a", (Object)sapFlag);
        String tableName = this.getMappingTableName(indexName);
        if (StringUtils.isEmpty((Object)tableName)) {
            logger.debug("\u65e0\u6cd5\u83b7\u53d6\u8868\u540d\u6620\u5c04\uff0c\u8df3\u8fc7\u5904\u7406");
            return joinPoint.proceed();
        }
        try {
            if (this.shouldProcessTable(tableName, sapFlag)) {
                logger.info("\u8868\u540d: {}, \u6620\u5c04\u7684\u7d22\u5f15: {} \u9700\u8981\u8fdb\u884cSAP\u9650\u5236\u5904\u7406", (Object)tableName, (Object)indexName);
                if (this.isAlreadyControlled(tableName)) {
                    this.processSapLimitConditions(searchVo, tableName, sapFlag, indexName);
                } else {
                    logger.debug("\u8868 {} \u5df2\u88ab\u5904\u7406\u8fc7\uff0c\u8df3\u8fc7\u91cd\u590d\u5904\u7406", (Object)tableName);
                }
            } else {
                logger.debug("\u8868 {} \u4e0d\u9700\u8981\u8fdb\u884cSAP\u9650\u5236\u5904\u7406", (Object)tableName);
            }
        }
        finally {
            this.clearStack(tableName);
        }
        Object result = joinPoint.proceed(args);
        return result;
    }

    private String extractIndexName(Object searchVo) {
        try {
            if (this.hasMethod(searchVo, "getIndexName")) {
                Object indexName = this.invokeMethod(searchVo, "getIndexName");
                return indexName != null ? indexName.toString() : null;
            }
            if (this.hasMethod(searchVo, "getIndex")) {
                Object index = this.invokeMethod(searchVo, "getIndex");
                return index != null ? index.toString() : null;
            }
            if (searchVo instanceof String) {
                return (String)searchVo;
            }
            return null;
        }
        catch (Exception e) {
            logger.warn("\u63d0\u53d6\u7d22\u5f15\u540d\u79f0\u5931\u8d25: {}", (Object)e.getMessage());
            return null;
        }
    }

    private String getMappingTableName(String indexName) {
        try {
            String prefix;
            SapConfigProperties.ElasticsearchConfig esConfig = this.sapConfigProperties.getElasticsearch();
            if (esConfig != null && !StringUtils.isEmpty((Object)esConfig.getIndexPrefix()) && indexName.startsWith(prefix = esConfig.getIndexPrefix())) {
                String tableName = indexName.substring(prefix.length());
                if (tableName.startsWith("_") || tableName.startsWith("-")) {
                    tableName = tableName.substring(1);
                }
                return tableName;
            }
            return indexName;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8868\u540d\u6620\u5c04\u5f02\u5e38: {}", (Object)e.getMessage());
            return indexName;
        }
    }

    private boolean shouldProcessTable(String tableName, String sapFlag) {
        String[] parts = sapFlag.split("\\.");
        if (parts.length != 2) {
            logger.warn("sap-flag\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3atable.field\u683c\u5f0f: {}", (Object)sapFlag);
            return false;
        }
        String targetTable = parts[0];
        return this.matchesTargetTable(tableName, targetTable);
    }

    private boolean matchesTargetTable(String tableName, String targetTable) {
        if (tableName == null || targetTable == null) {
            return false;
        }
        if (targetTable.contains("*")) {
            String regex = targetTable.replace("*", ".*");
            return tableName.matches(regex);
        }
        return tableName.equals(targetTable);
    }

    private void processSapLimitConditions(Object searchVo, String tableName, String sapFlag, String indexName) {
        SapConfigProperties.IndexMapping indexMapping;
        String[] parts = sapFlag.split("\\.");
        String fieldName = parts[1];
        Map<String, Object> conditionMap = this.buildSapConditions(tableName, fieldName, indexMapping = this.findIndexMappingByPattern(indexName));
        if (!CollectionUtils.isEmpty(conditionMap)) {
            logger.info("\u83b7\u53d6\u5230SAP\u9650\u5236\u89c4\u5219: {}", conditionMap);
            this.applySapConditions(searchVo, conditionMap);
        } else {
            logger.info("\u8868 {} \u6ca1\u6709\u83b7\u53d6\u5230SAP\u9650\u5236\u89c4\u5219", (Object)tableName);
        }
    }

    private Map<String, Object> buildSapConditions(String tableName, String fieldName, SapConfigProperties.IndexMapping indexMapping) {
        String conditionValue;
        EsOperator operator;
        if (indexMapping != null) {
            if (!StringUtils.isEmpty((Object)indexMapping.getOperator())) {
                operator = EsOperator.fromName(indexMapping.getOperator());
                logger.debug("\u4f7f\u7528\u7d22\u5f15\u6620\u5c04\u64cd\u4f5c\u7b26\uff1a\u8868 {}, \u64cd\u4f5c\u7b26 {}", (Object)tableName, (Object)operator);
            } else {
                operator = this.getDefaultEsOperator();
                logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u64cd\u4f5c\u7b26\uff1a\u8868 {}, \u64cd\u4f5c\u7b26 {}", (Object)tableName, (Object)operator);
            }
            if (!StringUtils.isEmpty((Object)indexMapping.getConditionValue())) {
                conditionValue = indexMapping.getConditionValue();
                logger.debug("\u4f7f\u7528\u7d22\u5f15\u6620\u5c04\u6761\u4ef6\u503c\uff1a\u8868 {}, \u6761\u4ef6\u503c {}", (Object)tableName, (Object)conditionValue);
            } else {
                conditionValue = this.getDefaultConditionValue();
                logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u6761\u4ef6\u503c\uff1a\u8868 {}, \u6761\u4ef6\u503c {}", (Object)tableName, (Object)conditionValue);
            }
            if (!StringUtils.isEmpty((Object)indexMapping.getField())) {
                fieldName = indexMapping.getField();
                logger.debug("\u4f7f\u7528\u7d22\u5f15\u6620\u5c04\u5b57\u6bb5\u540d: {}", (Object)fieldName);
            }
            fieldName = this.convertFieldName(fieldName, indexMapping);
            logger.debug("\u5b57\u6bb5\u540d\u8f6c\u6362\u540e: {}", (Object)fieldName);
        } else {
            operator = this.getDefaultEsOperator();
            conditionValue = this.getDefaultConditionValue();
            logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\uff1a\u8868 {}, \u64cd\u4f5c\u7b26 {}, \u6761\u4ef6\u503c {}", new Object[]{tableName, operator, conditionValue});
        }
        if (StringUtils.isEmpty((Object)conditionValue)) {
            logger.debug("\u6761\u4ef6\u503c\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u6761\u4ef6\u6784\u5efa");
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        String conditionKey = fieldName + "_" + operator.getOperatorName();
        conditionMap.put(conditionKey, conditionValue);
        logger.debug("\u6784\u5efa\u7684SAP\u6761\u4ef6\uff1a{}", conditionMap);
        return conditionMap;
    }

    private void applySapConditions(Object searchVo, Map<String, Object> conditionMap) {
        conditionMap.forEach((field, data) -> {
            String[] parts = field.split("_");
            if (parts.length >= 2) {
                String fieldName = parts[0];
                String operatorName = parts[1];
                this.applySingleCondition(searchVo, fieldName, operatorName, data);
            }
        });
    }

    private void applySingleCondition(Object searchVo, String fieldName, String operatorName, Object value) {
        try {
            switch (operatorName.toLowerCase()) {
                case "gte": 
                case ">=": {
                    this.invokeRangeFilter(searchVo, fieldName, value.toString(), null);
                    break;
                }
                case "lte": 
                case "<=": {
                    this.invokeRangeFilter(searchVo, fieldName, null, value.toString());
                    break;
                }
                case "gt": 
                case ">": {
                    this.invokeRangeFilter(searchVo, fieldName, value.toString(), null);
                    break;
                }
                case "lt": 
                case "<": {
                    this.invokeRangeFilter(searchVo, fieldName, null, value.toString());
                    break;
                }
                case "eq": 
                case "=": {
                    this.invokeEqualFilter(searchVo, fieldName, value.toString());
                    break;
                }
                case "ne": 
                case "!=": {
                    this.invokeNotEqualFilter(searchVo, fieldName, value.toString());
                    break;
                }
                default: {
                    logger.warn("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26: {}", (Object)operatorName);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528SAP\u6761\u4ef6\u5931\u8d25: field={}, operator={}, value={}, error={}", new Object[]{fieldName, operatorName, value, e.getMessage()});
        }
    }

    private boolean isEsEnabled() {
        SapConfigProperties.ElasticsearchConfig esConfig = this.sapConfigProperties.getElasticsearch();
        if (esConfig == null) {
            logger.debug("ES\u914d\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u542f\u7528");
            return true;
        }
        boolean enabled = esConfig.isEnabled();
        logger.debug("SAP ES\u62e6\u622a\u5668\u5f00\u5173\u72b6\u6001: {}", (Object)enabled);
        return enabled;
    }

    private boolean isGloballyEnabled() {
        return this.globalConfigProvider.isGlobalEnabled();
    }

    private SapConfigProperties.IndexMapping findIndexMappingByPattern(String indexName) {
        SapConfigProperties.IndexMapping cached = this.indexMappingCache.get(indexName);
        if (cached != null) {
            return cached;
        }
        SapConfigProperties.ElasticsearchConfig esConfig = this.sapConfigProperties.getElasticsearch();
        if (esConfig == null) {
            return null;
        }
        List<SapConfigProperties.IndexMapping> indexMappings = esConfig.getIndexMapping();
        if (CollectionUtils.isEmpty(indexMappings)) {
            return null;
        }
        for (SapConfigProperties.IndexMapping mapping : indexMappings) {
            if (!mapping.matchesIndex(indexName) || !mapping.isEffective(this.sapConfigProperties.getGlobal(), this.globalConfigProvider)) continue;
            this.indexMappingCache.put(indexName, mapping);
            return mapping;
        }
        return null;
    }

    private EsOperator getDefaultEsOperator() {
        SapConfigProperties.ElasticsearchConfig esConfig = this.sapConfigProperties.getElasticsearch();
        if (esConfig != null && !StringUtils.isEmpty((Object)esConfig.getDefaultOperator())) {
            return EsOperator.fromName(esConfig.getDefaultOperator());
        }
        return EsOperator.GTE;
    }

    private String getDefaultConditionValue() {
        SapConfigProperties.ElasticsearchConfig esConfig = this.sapConfigProperties.getElasticsearch();
        if (esConfig != null && !StringUtils.isEmpty((Object)esConfig.getDefaultConditionValue())) {
            return esConfig.getDefaultConditionValue();
        }
        String sapLimitTime = this.sapConfigProperties.getLimitTime();
        if (!StringUtils.isEmpty((Object)sapLimitTime)) {
            return sapLimitTime;
        }
        return null;
    }

    private String convertFieldName(String fieldName, SapConfigProperties.IndexMapping indexMapping) {
        SapConfigProperties.ElasticsearchConfig esConfig;
        if (StringUtils.isEmpty((Object)fieldName)) {
            return fieldName;
        }
        String conversionStrategy = indexMapping.getFieldNameConversion();
        if (StringUtils.isEmpty((Object)conversionStrategy) && (esConfig = this.sapConfigProperties.getElasticsearch()) != null) {
            conversionStrategy = esConfig.getFieldNameConversion();
        }
        if (StringUtils.isEmpty((Object)conversionStrategy)) {
            conversionStrategy = "CAMEL_CASE";
        }
        try {
            FieldNameConverter.FieldFormat targetFormat = FieldNameConverter.FieldFormat.valueOf(conversionStrategy.toUpperCase());
            String convertedFieldName = FieldNameConverter.convertFieldName(fieldName, targetFormat);
            logger.debug("\u5b57\u6bb5\u540d\u8f6c\u6362: {} -> {} (\u7b56\u7565: {})", new Object[]{fieldName, convertedFieldName, conversionStrategy});
            return convertedFieldName;
        }
        catch (IllegalArgumentException e) {
            logger.warn("\u65e0\u6548\u7684\u5b57\u6bb5\u540d\u8f6c\u6362\u7b56\u7565: {}, \u4f7f\u7528\u9ed8\u8ba4\u7b56\u7565", (Object)conversionStrategy);
            return FieldNameConverter.underscoreToCamelCase(fieldName);
        }
    }

    private boolean isAlreadyControlled(String tableName) {
        Map<String, Integer> stackMap = LOCAL_STACK_MAP.get();
        if (stackMap == null) {
            stackMap = new HashMap<String, Integer>(16);
            stackMap.put(tableName, 1);
            LOCAL_STACK_MAP.set(stackMap);
            return true;
        }
        Integer count = stackMap.get(tableName);
        if (count == null || count == 0) {
            stackMap.put(tableName, 1);
            return true;
        }
        stackMap.put(tableName, count + 1);
        return false;
    }

    private void clearStack(String key) {
        Map<String, Integer> stackMap = LOCAL_STACK_MAP.get();
        if (stackMap != null) {
            Integer count = stackMap.get(key);
            if (count != null) {
                if (count > 1) {
                    stackMap.put(key, count - 1);
                } else {
                    stackMap.remove(key);
                }
            }
            if (stackMap.isEmpty()) {
                LOCAL_STACK_MAP.remove();
            }
        }
    }

    public void refreshIndexMappingCache() {
        this.indexMappingCache.clear();
        logger.debug("\u7d22\u5f15\u6620\u5c04\u7f13\u5b58\u5df2\u6e05\u7a7a");
    }

    private boolean hasMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        try {
            obj.getClass().getMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean hasMethod(Object obj, String methodName) {
        try {
            Method[] methods;
            for (Method method : methods = obj.getClass().getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.debug("\u68c0\u67e5\u65b9\u6cd5\u5b58\u5728\u6027\u5931\u8d25: {}", (Object)e.getMessage());
            return false;
        }
    }

    private Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object ... args) throws Exception {
        return obj.getClass().getMethod(methodName, parameterTypes).invoke(obj, args);
    }

    private Object invokeMethod(Object obj, String methodName) throws Exception {
        return obj.getClass().getMethod(methodName, new Class[0]).invoke(obj, new Object[0]);
    }

    private void invokeRangeFilter(Object searchVo, String fieldName, String gte, String lte) throws Exception {
        try {
            Object result = this.invokeMethodSafely(searchVo, "addRangeFilter", fieldName, gte, lte);
            if (result != null) {
                logger.debug("\u6210\u529f\u8c03\u7528addRangeFilter\u65b9\u6cd5: field={}, gte={}, lte={}", new Object[]{fieldName, gte, lte});
            }
        }
        catch (Exception e) {
            logger.warn("\u8c03\u7528addRangeFilter\u65b9\u6cd5\u5931\u8d25\uff0c\u5c1d\u8bd5\u5907\u7528\u65b9\u6848: {}", (Object)e.getMessage());
            try {
                Class<?> logicalSymbolClass = null;
                try {
                    logicalSymbolClass = Class.forName("com.dtyunxi.cis.search.constant.LogicalSymbol");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (logicalSymbolClass != null) {
                    this.invokeMethodSafely(searchVo, "addRangeFilter", fieldName, gte, lte, null);
                    logger.debug("\u4f7f\u7528LogicalSymbol\u7c7b\u578b\u8c03\u7528\u56db\u53c2\u6570addRangeFilter\u65b9\u6cd5");
                } else {
                    this.invokeMethodSafely(searchVo, "addRangeFilter", fieldName, gte, lte, null);
                    logger.debug("\u4f7f\u7528Object\u7c7b\u578b\u8c03\u7528\u56db\u53c2\u6570addRangeFilter\u65b9\u6cd5");
                }
            }
            catch (Exception fallbackException) {
                logger.error("\u6240\u6709addRangeFilter\u65b9\u6cd5\u8c03\u7528\u90fd\u5931\u8d25: {}", (Object)fallbackException.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug("\u641c\u7d22\u5bf9\u8c61\u65b9\u6cd5\u4fe1\u606f:\n{}", (Object)this.getAvailableMethods(searchVo));
                }
                throw new RuntimeException("\u65e0\u6cd5\u8c03\u7528addRangeFilter\u65b9\u6cd5\uff0c\u641c\u7d22\u5bf9\u8c61\u7c7b\u578b: " + searchVo.getClass().getName(), fallbackException);
            }
        }
    }

    private void invokeEqualFilter(Object searchVo, String fieldName, String value) throws Exception {
        try {
            Object result = this.invokeMethodSafely(searchVo, "addEqualFilter", fieldName, value);
            if (result != null) {
                logger.debug("\u6210\u529f\u8c03\u7528addEqualFilter\u65b9\u6cd5: field={}, value={}", (Object)fieldName, (Object)value);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528addEqualFilter\u65b9\u6cd5\u5931\u8d25: field={}, value={}, error={}", new Object[]{fieldName, value, e.getMessage()});
            throw new RuntimeException("\u65e0\u6cd5\u8c03\u7528addEqualFilter\u65b9\u6cd5\uff0c\u641c\u7d22\u5bf9\u8c61\u7c7b\u578b: " + searchVo.getClass().getName(), e);
        }
    }

    private void invokeNotEqualFilter(Object searchVo, String fieldName, String value) throws Exception {
        try {
            Object result = this.invokeMethodSafely(searchVo, "addNotEqualFilter", fieldName, value);
            if (result != null) {
                logger.debug("\u6210\u529f\u8c03\u7528addNotEqualFilter\u65b9\u6cd5: field={}, value={}", (Object)fieldName, (Object)value);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528addNotEqualFilter\u65b9\u6cd5\u5931\u8d25: field={}, value={}, error={}", new Object[]{fieldName, value, e.getMessage()});
            throw new RuntimeException("\u65e0\u6cd5\u8c03\u7528addNotEqualFilter\u65b9\u6cd5\uff0c\u641c\u7d22\u5bf9\u8c61\u7c7b\u578b: " + searchVo.getClass().getName(), e);
        }
    }

    private Object invokeMethodSafely(Object obj, String methodName, Object ... args) {
        try {
            if (args == null || args.length == 0) {
                return this.invokeMethod(obj, methodName);
            }
            Class[] parameterTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                parameterTypes[i] = args[i] != null ? args[i].getClass() : Object.class;
            }
            try {
                return this.invokeMethod(obj, methodName, parameterTypes, args);
            }
            catch (NoSuchMethodException e) {
                return this.findAndInvokeCompatibleMethod(obj, methodName, args);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u65b9\u6cd5\u5931\u8d25: {}.{}({}), error: {}", new Object[]{obj.getClass().getSimpleName(), methodName, args != null ? Arrays.toString(args) : "null", e.getMessage()});
            return null;
        }
    }

    private Object findAndInvokeCompatibleMethod(Object obj, String methodName, Object ... args) throws Exception {
        Method[] methods;
        for (Method method : methods = obj.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != args.length || !this.isCompatibleParameters(method.getParameterTypes(), args)) continue;
            return method.invoke(obj, args);
        }
        throw new NoSuchMethodException("\u627e\u4e0d\u5230\u517c\u5bb9\u7684\u65b9\u6cd5: " + methodName + " with " + args.length + " parameters");
    }

    private boolean isCompatibleParameters(Class<?>[] parameterTypes, Object[] args) {
        if (parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!(args[i] == null ? parameterTypes[i].isPrimitive() : !parameterTypes[i].isAssignableFrom(args[i].getClass()) && !this.isPrimitiveWrapperCompatible(parameterTypes[i], args[i].getClass()))) continue;
            return false;
        }
        return true;
    }

    private boolean isPrimitiveWrapperCompatible(Class<?> targetType, Class<?> sourceType) {
        if (targetType.isPrimitive()) {
            if (targetType == Integer.TYPE && sourceType == Integer.class) {
                return true;
            }
            if (targetType == Long.TYPE && sourceType == Long.class) {
                return true;
            }
            if (targetType == Double.TYPE && sourceType == Double.class) {
                return true;
            }
            if (targetType == Float.TYPE && sourceType == Float.class) {
                return true;
            }
            if (targetType == Boolean.TYPE && sourceType == Boolean.class) {
                return true;
            }
            if (targetType == Character.TYPE && sourceType == Character.class) {
                return true;
            }
            if (targetType == Short.TYPE && sourceType == Short.class) {
                return true;
            }
            if (targetType == Byte.TYPE && sourceType == Byte.class) {
                return true;
            }
        } else if (sourceType.isPrimitive()) {
            if (sourceType == Integer.TYPE && targetType == Integer.class) {
                return true;
            }
            if (sourceType == Long.TYPE && targetType == Long.class) {
                return true;
            }
            if (sourceType == Double.TYPE && targetType == Double.class) {
                return true;
            }
            if (sourceType == Float.TYPE && targetType == Float.class) {
                return true;
            }
            if (sourceType == Boolean.TYPE && targetType == Boolean.class) {
                return true;
            }
            if (sourceType == Character.TYPE && targetType == Character.class) {
                return true;
            }
            if (sourceType == Short.TYPE && targetType == Short.class) {
                return true;
            }
            if (sourceType == Byte.TYPE && targetType == Byte.class) {
                return true;
            }
        }
        return false;
    }

    private String getAvailableMethods(Object obj) {
        try {
            Method[] methods = obj.getClass().getMethods();
            StringBuilder sb = new StringBuilder();
            sb.append("\u5bf9\u8c61\u7c7b\u578b: ").append(obj.getClass().getName()).append("\n");
            sb.append("\u53ef\u7528\u65b9\u6cd5:\n");
            for (Method method : methods) {
                if (!method.getName().contains("Filter") && !method.getName().contains("Range")) continue;
                sb.append("  ").append(method.getName());
                sb.append("(");
                Class<?>[] params = method.getParameterTypes();
                for (int i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(params[i].getSimpleName());
                }
                sb.append(")\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "\u83b7\u53d6\u65b9\u6cd5\u4fe1\u606f\u5931\u8d25: " + e.getMessage();
        }
    }

    private boolean supportsFilterMethod(Object obj, String methodName) {
        try {
            Method[] methods;
            for (Method method : methods = obj.getClass().getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.debug("\u68c0\u67e5\u8fc7\u6ee4\u65b9\u6cd5\u652f\u6301\u5931\u8d25: {}", (Object)e.getMessage());
            return false;
        }
    }

    public int getOrder() {
        return 2147483547;
    }
}

