/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.web;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.config.SapGlobalConfigProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@RefreshScope
public class SapPathInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SapPathInterceptor.class);
    private final SapConfigProperties sapConfigProperties;
    private final SapServiceContextProvider serviceContextProvider;
    private final SapGlobalConfigProvider sapGlobalConfigProvider;

    public SapPathInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider, SapGlobalConfigProvider sapGlobalConfigProvider) {
        this.sapConfigProperties = sapConfigProperties;
        this.serviceContextProvider = serviceContextProvider;
        this.sapGlobalConfigProvider = sapGlobalConfigProvider;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        List<SapConfigProperties.PathMapping> pathMappings;
        String requestPath = request.getRequestURI();
        logger.debug("SapPathInterceptor\u62e6\u622a\u5230\u8bf7\u6c42\u8def\u5f84: {}", (Object)requestPath);
        String existingSapFlag = (String)this.serviceContextProvider.getAttachment("sap-flag");
        if (!StringUtils.isEmpty((Object)existingSapFlag)) {
            logger.debug("sap-flag\u5df2\u901a\u8fc7\u8bf7\u6c42\u5934\u8bbe\u7f6e: {}\uff0c\u8df3\u8fc7\u8def\u5f84\u5339\u914d\u5904\u7406", (Object)existingSapFlag);
            return true;
        }
        SapConfigProperties.GlobalConfig globalConfig = this.sapConfigProperties.getGlobal();
        if (globalConfig == null) {
            logger.debug("\u5168\u5c40\u914d\u7f6e\u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e");
            globalConfig = new SapConfigProperties.GlobalConfig();
        }
        if (!CollectionUtils.isEmpty(pathMappings = this.sapConfigProperties.getPathMapping())) {
            for (SapConfigProperties.PathMapping pathMapping : pathMappings) {
                String configPath = pathMapping.getPath();
                String tableField = pathMapping.getTableField();
                if (!pathMapping.isEffective(globalConfig, this.sapGlobalConfigProvider) || globalConfig.isForceMode() && !Objects.equals("1", request.getHeader("x-eas-enabled"))) {
                    logger.debug("\u8def\u5f84\u6620\u5c04 {} \u672a\u751f\u6548\uff0c\u8df3\u8fc7: enabled={}, ignoreGlobal={}, globalEnabled={}", new Object[]{configPath, pathMapping.isEnabled(), pathMapping.isIgnoreGlobal(), globalConfig.isEnabled()});
                    continue;
                }
                if (!this.pathMatches(requestPath, configPath)) continue;
                logger.debug("\u8bf7\u6c42\u8def\u5f84 {} \u5339\u914d\u914d\u7f6e\u8def\u5f84 {}, \u8bbe\u7f6esap-flag: {}", new Object[]{requestPath, configPath, tableField});
                this.serviceContextProvider.setAttachment("sap-flag", tableField);
                break;
            }
        } else {
            logger.debug("\u672a\u914d\u7f6e\u8def\u5f84\u6620\u5c04\uff0c\u8df3\u8fc7\u5904\u7406");
        }
        return true;
    }

    private boolean pathMatches(String requestPath, String configPath) {
        if (configPath == null || requestPath == null) {
            return false;
        }
        if (configPath.contains("*")) {
            String regex = configPath.replace("*", ".*");
            return requestPath.matches(regex);
        }
        return requestPath.equals(configPath);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String sapFlag = (String)this.serviceContextProvider.getAttachment("sap-flag");
        if (!StringUtils.isEmpty((Object)sapFlag)) {
            logger.info("\u6e05\u7406ServiceContext\u4e2d\u7684sap-flag: {}", (Object)sapFlag);
            this.serviceContextProvider.removeAttachment("sap-flag");
        }
    }
}

