/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerSalesmanDomain;
import com.yunxi.dg.base.center.customer.domain.IDgRCustomerSalesmanDomain;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSalesmanReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgRCustomerSalesmanReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgSalesmanReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerSalesmanRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerSalesmanEo;
import com.yunxi.dg.base.center.customer.eo.DgRCustomerSalesmanEo;
import com.yunxi.dg.base.center.customer.service.IDgCustomerExtService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerSalesmanService;
import com.yunxi.dg.base.center.customer.service.IDgRCustomerSalesmanService;
import com.yunxi.dg.base.center.customer.utils.MybatisPlusUtils;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DgCustomerSalesmanServiceImpl
implements IDgCustomerSalesmanService {
    @Resource
    private IDgCustomerSalesmanDomain iDgCustomerSalesmanDomain;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IDgCustomerExtService customerExtService;
    @Autowired
    private IDgRCustomerSalesmanService rCustomerSalesmanService;
    @Autowired
    private IDgRCustomerSalesmanDomain iDgRCustomerSalesmanDomain;
    @Autowired
    private IContext context;

    private synchronized String getSalesmanCode() {
        String yyddd = DateUtil.format((Date)new Date(), (String)"yyDDD");
        HashSet<String> numbersSet = new HashSet<String>();
        while (numbersSet.size() != 5) {
            numbersSet.add(RandomUtil.randomNumbers((int)5));
        }
        List codeList = numbersSet.stream().map(code -> "YWY".concat(yyddd).concat((String)code)).collect(Collectors.toList());
        DgCustomerSalesmanEo customerSalesmanEo = new DgCustomerSalesmanEo();
        LambdaQueryWrapper<DgCustomerSalesmanEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(customerSalesmanEo);
        queryWrapper.in(DgCustomerSalesmanEo::getCode, codeList);
        List customerSalesmanEos = this.iDgCustomerSalesmanDomain.getMapper().selectList(queryWrapper);
        if (CollUtil.isEmpty((Collection)customerSalesmanEos)) {
            return (String)codeList.stream().findFirst().get();
        }
        return this.getSalesmanCode();
    }

    @Override
    public Long addCustomerSalesman(DgCustomerSalesmanReqDto addReqDto) {
        DgCustomerSalesmanEo customerSalesmanEo = new DgCustomerSalesmanEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerSalesmanEo);
        if (Objects.isNull(customerSalesmanEo.getUserId())) {
            BizExceptionHelper.throwBizException((IExceptionCode)DgCustomerExceptionCode.INVALID_USER_ID);
        }
        if (Objects.isNull(customerSalesmanEo.getOrgInfoId())) {
            customerSalesmanEo.setOrgInfoId(this.customerExtService.getCurrentUserOrgId());
        }
        MybatisPlusUtils.setCommonInfo(customerSalesmanEo);
        DgCustomerSalesmanEo userSalesmanEo = new DgCustomerSalesmanEo();
        userSalesmanEo.setUserId(customerSalesmanEo.getUserId());
        MybatisPlusUtils.checkUnique(this.iDgCustomerSalesmanDomain, userSalesmanEo, (IExceptionCode)DgCustomerExceptionCode.CUSTOMER_SALESMAN_EXISTS);
        if (StrUtil.isNotBlank((CharSequence)customerSalesmanEo.getJobNumber())) {
            DgCustomerSalesmanEo jobSalesmanEo = new DgCustomerSalesmanEo();
            jobSalesmanEo.setJobNumber(customerSalesmanEo.getJobNumber());
            jobSalesmanEo.setOrgInfoId(customerSalesmanEo.getOrgInfoId());
            MybatisPlusUtils.checkUnique(this.iDgCustomerSalesmanDomain, jobSalesmanEo, (IExceptionCode)DgCustomerExceptionCode.CUSTOMER_SALESMAN_JOB_NUMBER);
        }
        customerSalesmanEo.setCode(this.getSalesmanCode());
        this.iDgCustomerSalesmanDomain.insert((BaseEo)customerSalesmanEo);
        return customerSalesmanEo.getId();
    }

    @Override
    public void modifyCustomerSalesman(DgCustomerSalesmanReqDto modifyReqDto) {
        if (Objects.isNull(modifyReqDto.getId())) {
            return;
        }
        DgCustomerSalesmanEo customerSalesman = (DgCustomerSalesmanEo)this.iDgCustomerSalesmanDomain.selectByPrimaryKey(modifyReqDto.getId());
        if (Objects.isNull(customerSalesman)) {
            return;
        }
        DgCustomerSalesmanEo customerSalesmanEo = new DgCustomerSalesmanEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerSalesmanEo);
        if (Objects.isNull(customerSalesmanEo.getUserId())) {
            BizExceptionHelper.throwBizException((IExceptionCode)DgCustomerExceptionCode.INVALID_USER_ID);
        }
        DgCustomerSalesmanEo userSalesmanEo = new DgCustomerSalesmanEo();
        userSalesmanEo.setUserId(customerSalesmanEo.getUserId());
        userSalesmanEo.setId(customerSalesmanEo.getId());
        MybatisPlusUtils.checkUnique(this.iDgCustomerSalesmanDomain, userSalesmanEo, (IExceptionCode)DgCustomerExceptionCode.CUSTOMER_SALESMAN_EXISTS);
        if (StrUtil.isNotBlank((CharSequence)customerSalesmanEo.getJobNumber())) {
            DgCustomerSalesmanEo jobSalesmanEo = new DgCustomerSalesmanEo();
            jobSalesmanEo.setJobNumber(customerSalesmanEo.getJobNumber());
            jobSalesmanEo.setOrgInfoId(customerSalesmanEo.getOrgInfoId());
            jobSalesmanEo.setId(customerSalesmanEo.getId());
            MybatisPlusUtils.checkUnique(this.iDgCustomerSalesmanDomain, jobSalesmanEo, (IExceptionCode)DgCustomerExceptionCode.CUSTOMER_SALESMAN_JOB_NUMBER);
        }
        customerSalesmanEo.setCode(customerSalesman.getCode());
        customerSalesmanEo.setOrgInfoId(customerSalesman.getOrgInfoId());
        this.iDgCustomerSalesmanDomain.update((BaseEo)customerSalesmanEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerSalesman(String ids) {
        List salesmanIdList = Arrays.stream(ids.split(",")).distinct().map(id -> Long.valueOf(id)).collect(Collectors.toList());
        if (CollUtil.isEmpty(salesmanIdList)) {
            return;
        }
        List customerSalesmanEos = this.iDgCustomerSalesmanDomain.selectByIds(salesmanIdList);
        for (DgCustomerSalesmanEo customerSalesman : customerSalesmanEos) {
            if (Objects.equals(customerSalesman.getDr(), 1)) continue;
            this.iDgCustomerSalesmanDomain.logicDeleteById(customerSalesman.getId());
        }
        List userIdList = customerSalesmanEos.stream().filter(item -> Objects.equals(item.getDr(), 0) && Objects.nonNull(item.getUserId())).map(DgCustomerSalesmanEo::getUserId).distinct().collect(Collectors.toList());
        DgCustomerEo customerEo = new DgCustomerEo();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(customerEo).in(DgCustomerEo::getSalesmanId, userIdList);
        List customerEos = this.iDgCustomerDomain.getMapper().selectList((Wrapper)queryWrapper);
        for (DgCustomerEo customer : customerEos) {
            customer.setSalesmanId(null);
            this.iDgCustomerDomain.update((BaseEo)customer);
        }
    }

    @Override
    public DgCustomerSalesmanRespDto queryById(Long id) {
        DgCustomerSalesmanEo customerSalesmanEo = (DgCustomerSalesmanEo)this.iDgCustomerSalesmanDomain.selectByPrimaryKey(id);
        DgCustomerSalesmanRespDto customerSalesmanRespDto = new DgCustomerSalesmanRespDto();
        DtoHelper.eo2Dto((BaseEo)customerSalesmanEo, (BaseVo)customerSalesmanRespDto);
        UserDto userDto = (UserDto)RestResponseHelper.extractData((RestResponse)this.userQueryApi.queryById(customerSalesmanEo.getUserId(), "{}"));
        if (Objects.nonNull(userDto)) {
            customerSalesmanRespDto.setUserName(userDto.getUserName());
        }
        DgCustomerEo customerEo = new DgCustomerEo();
        customerEo.setSalesmanId(customerSalesmanRespDto.getUserId());
        customerSalesmanRespDto.setCustomerCount(Integer.valueOf(this.iDgCustomerDomain.count((BaseEo)customerEo)));
        return customerSalesmanRespDto;
    }

    @Override
    public PageInfo<DgCustomerSalesmanRespDto> queryByPage(DgCustomerSalesmanReqDto customerSalesmanReqDto, Integer pageNum, Integer pageSize) {
        DgCustomerSalesmanEo customerSalesmanEo = new DgCustomerSalesmanEo();
        DtoHelper.dto2Eo((BaseVo)customerSalesmanReqDto, (BaseEo)customerSalesmanEo);
        if (Objects.isNull(customerSalesmanEo.getOrgInfoId())) {
            customerSalesmanEo.setOrgInfoId(this.customerExtService.getCurrentUserOrgId());
        }
        String name = customerSalesmanEo.getName();
        customerSalesmanEo.setName(null);
        LambdaQueryWrapper<DgCustomerSalesmanEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(customerSalesmanEo);
        if (StrUtil.isNotBlank((CharSequence)name)) {
            queryWrapper.like(DgCustomerSalesmanEo::getName, (Object)name);
        }
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        PageInfo<DgCustomerSalesmanRespDto> dtoPageInfo = MybatisPlusUtils.selectPage(this.iDgCustomerSalesmanDomain, queryWrapper, DgCustomerSalesmanRespDto.class, pageNum, pageSize);
        List list = dtoPageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return dtoPageInfo;
        }
        List userIdList = list.stream().filter(item -> Objects.nonNull(item.getUserId())).map(item -> item.getUserId()).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(userIdList)) {
            return dtoPageInfo;
        }
        DgRCustomerSalesmanEo salesmanEo = new DgRCustomerSalesmanEo();
        salesmanEo.setDr(0);
        LambdaQueryWrapper customerWrapper = new QueryWrapper((Object)salesmanEo).select(new String[]{"salesman_id,COUNT(1) AS count"}).lambda();
        customerWrapper.groupBy(DgRCustomerSalesmanEo::getSalesmanId);
        customerWrapper.in(DgRCustomerSalesmanEo::getSalesmanId, userIdList);
        customerWrapper.eq(DgRCustomerSalesmanEo::getOrgId, (Object)this.customerExtService.queryOrgIdByUserId(this.context.userId()));
        List salesmanEos = this.iDgRCustomerSalesmanDomain.getMapper().selectList((Wrapper)customerWrapper);
        Map<Long, Integer> countMap = salesmanEos.stream().collect(Collectors.toMap(DgRCustomerSalesmanEo::getSalesmanId, DgRCustomerSalesmanEo::getCount));
        list.forEach(item -> {
            if (countMap.containsKey(item.getUserId())) {
                item.setCustomerCount((Integer)countMap.get(item.getUserId()));
            }
        });
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeSalesman(DgSalesmanReqDto salesmanReqDto) {
        DgCustomerSalesmanEo customerSalesmanEo = (DgCustomerSalesmanEo)this.iDgCustomerSalesmanDomain.selectByPrimaryKey(salesmanReqDto.getSalesmanId());
        if (Objects.isNull(customerSalesmanEo) || Objects.isNull(customerSalesmanEo.getUserId())) {
            return;
        }
        List customerIdList = salesmanReqDto.getCustomerIdList();
        if (CollUtil.isEmpty((Collection)customerIdList)) {
            return;
        }
        Long userId = customerSalesmanEo.getUserId();
        List customerEos = this.iDgCustomerDomain.selectByIds(customerIdList);
        for (DgCustomerEo customerEo : customerEos) {
            customerEo.setSalesmanId(userId);
            this.iDgCustomerDomain.update((BaseEo)customerEo);
        }
    }

    @Override
    public void endSalesman(DgSalesmanReqDto salesmanReqDto) {
        DgCustomerSalesmanEo customerSalesmanEo = (DgCustomerSalesmanEo)this.iDgCustomerSalesmanDomain.selectByPrimaryKey(salesmanReqDto.getSalesmanId());
        if (Objects.isNull(customerSalesmanEo)) {
            return;
        }
        List customerIdList = salesmanReqDto.getCustomerIdList();
        if (CollUtil.isEmpty((Collection)customerIdList)) {
            return;
        }
        DgCustomerEo customerEo = new DgCustomerEo();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(customerEo).in(BaseEo::getId, (Collection)customerIdList);
        List customerEos = this.iDgCustomerDomain.getMapper().selectList((Wrapper)queryWrapper);
        for (DgCustomerEo customer : customerEos) {
            customer.setSalesmanId(null);
            this.iDgCustomerDomain.update((BaseEo)customer);
        }
    }

    @Override
    public void addSalesmanRelation(DgSalesmanReqDto salesmanReqDto) {
        DgCustomerSalesmanEo customerSalesmanEo = (DgCustomerSalesmanEo)this.iDgCustomerSalesmanDomain.selectByPrimaryKey(salesmanReqDto.getSalesmanId());
        if (Objects.isNull(customerSalesmanEo) || Objects.isNull(customerSalesmanEo.getUserId())) {
            return;
        }
        List customerIdList = salesmanReqDto.getCustomerIdList();
        if (CollUtil.isEmpty((Collection)customerIdList)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (Long customerId : customerIdList) {
            DgRCustomerSalesmanEo salesmanEo = new DgRCustomerSalesmanEo();
            salesmanEo.setSalesmanId(customerSalesmanEo.getUserId());
            salesmanEo.setCustomerId(customerId);
            salesmanEo.setOrgId(customerSalesmanEo.getOrgInfoId());
            list.add(salesmanEo);
        }
        this.rCustomerSalesmanService.syncBatchAdd(list);
    }

    @Override
    public Boolean querySalesmanStatusByUserId(Long userId) {
        DgCustomerSalesmanEo customerSalesmanEo = new DgCustomerSalesmanEo();
        customerSalesmanEo.setUserId(userId);
        customerSalesmanEo.setDr(CommonConstants.Dr.NO);
        List list = this.iDgCustomerSalesmanDomain.selectList((BaseEo)customerSalesmanEo);
        if (CollUtil.isEmpty((Collection)list)) {
            return null;
        }
        DgCustomerSalesmanEo customerSalesman = (DgCustomerSalesmanEo)list.stream().findFirst().get();
        return Objects.equals(customerSalesman.getStatus(), 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddSalesmanRelation(List<DgCustomerSalesmanReqDto> customerSalesmanReqDtos) {
        if (CollectionUtils.isEmpty(customerSalesmanReqDtos)) {
            return;
        }
        for (DgCustomerSalesmanReqDto customerSalesmanReqDto : customerSalesmanReqDtos) {
            if (CollectionUtils.isEmpty((Collection)customerSalesmanReqDto.getCustomerSalesmanReqDtos())) continue;
            HashSet customerCodes = Sets.newHashSet();
            HashSet orgIds = Sets.newHashSet();
            for (DgRCustomerSalesmanReqDto salesmanReqDto : customerSalesmanReqDto.getCustomerSalesmanReqDtos()) {
                if (StringUtils.isNotBlank((CharSequence)salesmanReqDto.getCustomerCode())) {
                    customerCodes.add(salesmanReqDto.getCustomerCode());
                }
                if (salesmanReqDto.getOrgId() == null) continue;
                orgIds.add(salesmanReqDto.getOrgId());
            }
            DgCustomerSalesmanEo salesmanEo = new DgCustomerSalesmanEo();
            ArrayList salesmanSqlFilters = Lists.newArrayList();
            salesmanSqlFilters.add(SqlFilter.in((String)"org_info_id", (Object)orgIds));
            salesmanEo.setSqlFilters((List)salesmanSqlFilters);
            salesmanEo.setUserId(customerSalesmanReqDto.getUserId());
            salesmanEo.setDr(CommonConstants.Dr.NO);
            List eos = this.iDgCustomerSalesmanDomain.selectList((BaseEo)salesmanEo);
            Map<String, DgCustomerSalesmanEo> salesmanEoMap = eos.stream().collect(Collectors.toMap(e -> e.getUserId() + "#" + e.getOrgInfoId(), e -> e, (e1, e2) -> e1));
            Map<Object, Object> eoMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty((Collection)customerCodes)) {
                DgCustomerEo customerEo = new DgCustomerEo();
                ArrayList sqlFilters = Lists.newArrayList();
                sqlFilters.add(SqlFilter.in((String)"third_party_id", (Object)customerCodes));
                customerEo.setSqlFilters((List)sqlFilters);
                customerEo.setDr(CommonConstants.Dr.NO);
                List customerEos = this.iDgCustomerDomain.selectList((BaseEo)customerEo);
                eoMap = customerEos.stream().collect(Collectors.toMap(DgCustomerEo::getThirdPartyId, e -> e, (e1, e2) -> e1));
            }
            HashMap map = Maps.newHashMap();
            ArrayList relations = Lists.newArrayList();
            for (DgRCustomerSalesmanReqDto dto : customerSalesmanReqDto.getCustomerSalesmanReqDtos()) {
                DgCustomerSalesmanEo customerSalesmanEo;
                if (!salesmanEoMap.containsKey(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId()) && !map.containsKey(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId())) {
                    customerSalesmanEo = new DgCustomerSalesmanEo();
                    CubeBeanUtils.copyProperties((Object)customerSalesmanEo, (Object)customerSalesmanReqDto, (String[])new String[]{"orgInfoId"});
                    customerSalesmanEo.setOrgInfoId(dto.getOrgId());
                    customerSalesmanEo.setId(Long.valueOf(IdGenrator.nextId((long)IdGenrator.getWorkerId(), (long)ServiceContext.getContext().getRequestTenantCode())));
                    map.put(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId(), customerSalesmanEo);
                    salesmanEoMap.put(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId(), customerSalesmanEo);
                }
                if (!eoMap.containsKey(dto.getCustomerCode())) continue;
                customerSalesmanEo = salesmanEoMap.get(customerSalesmanReqDto.getUserId() + "#" + dto.getOrgId());
                DgCustomerEo customerEo1 = (DgCustomerEo)eoMap.get(dto.getCustomerCode());
                DgRCustomerSalesmanEo rCustomerSalesmanEo = new DgRCustomerSalesmanEo();
                rCustomerSalesmanEo.setSalesmanId(customerSalesmanReqDto.getUserId());
                rCustomerSalesmanEo.setCustomerId(customerEo1.getId());
                rCustomerSalesmanEo.setRealSalesmanId(customerSalesmanEo.getId());
                rCustomerSalesmanEo.setOrgId(dto.getOrgId());
                relations.add(rCustomerSalesmanEo);
            }
            this.iDgCustomerSalesmanDomain.insertBatch(new ArrayList(map.values()));
            this.rCustomerSalesmanService.syncBatchAdd(relations);
        }
    }

    @Override
    public void updateStatus(DgCustomerSalesmanReqDto modifyReqDto) {
        this.iDgCustomerSalesmanDomain.getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(true, DgCustomerSalesmanEo::getStatus, (Object)modifyReqDto.getStatus()).eq(DgCustomerSalesmanEo::getUserId, (Object)modifyReqDto.getUserId())).eq(DgCustomerSalesmanEo::getOrgInfoId, (Object)modifyReqDto.getOrgInfoId()));
    }
}

