/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.domain.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IReconciliationRuleDas;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationRuleDomain;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationRuleDto;
import com.yunxi.dg.base.center.finance.dto.enums.ReconciliationRuleStrategyEnum;
import com.yunxi.dg.base.center.finance.eo.ReconciliationRuleEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReconciliationRuleDomainImpl
extends BaseDomainImpl<ReconciliationRuleEo>
implements IReconciliationRuleDomain {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationRuleDomainImpl.class);
    @Resource
    private IReconciliationRuleDas das;

    public ICommonDas<ReconciliationRuleEo> commonDas() {
        return this.das;
    }

    @Override
    public List<ReconciliationRuleEo> queryList(List<String> customerCodes, List<String> shopCodes, String currentDate) {
        return this.das.queryList(customerCodes, shopCodes, currentDate);
    }

    @Override
    public List<ReconciliationRuleDto> getRuleDtoList(String ruleStrategy) {
        ExtQueryChainWrapper sqlFilters = this.das.filter();
        String currentDate = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        if (ReconciliationRuleStrategyEnum.AUTO_GENERATE_BILL.getCode().equals(ruleStrategy)) {
            sqlFilters.eq((Object)"auto_generate_bill", (Object)1);
        }
        if (ReconciliationRuleStrategyEnum.AUTO_AUDIT_BILL.getCode().equals(ruleStrategy)) {
            sqlFilters.eq((Object)"auto_audit_bill", (Object)1);
        }
        if (ReconciliationRuleStrategyEnum.AUTO_PUBLISH_BILL.getCode().equals(ruleStrategy)) {
            sqlFilters.eq((Object)"auto_publish_bill", (Object)1);
        }
        if (ReconciliationRuleStrategyEnum.AUTO_CONFIRM.getCode().equals(ruleStrategy)) {
            sqlFilters.eq((Object)"auto_confirm", (Object)1);
        }
        sqlFilters.le((Object)"effect_begin_time", (Object)currentDate);
        StringBuilder sql = new StringBuilder();
        sql.append(" ( ");
        sql.append("effect_end_time >= '" + currentDate + "' or effect = 1");
        sql.append(")");
        sqlFilters.apply(sql.toString(), new Object[0]);
        List ruleEoList = sqlFilters.list();
        if (CollectionUtils.isEmpty((Collection)ruleEoList)) {
            log.info("\u5339\u914d\u4e0d\u5230\u5bf9\u8d26\u89c4\u5219");
        }
        ArrayList ruleDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)ruleDtoList, (Collection)ruleEoList, ReconciliationRuleDto.class);
        return ruleDtoList;
    }
}

