/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.rest.eg;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.api.eg.IExampleApi;
import com.yunxi.dg.base.center.finance.dto.eg.ExampleDto;
import com.yunxi.dg.base.center.finance.dto.eg.ExamplePageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepAccountsDetailDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.scheduler.task.PushTradeStatusScheduleTask;
import com.yunxi.dg.base.center.finance.service.eg.IExampleService;
import com.yunxi.dg.base.center.finance.service.entity.IFianceInsiderTransactionService;
import com.yunxi.dg.base.center.finance.service.mq.keep.DeliveryNoticeAccountingConsumer;
import com.yunxi.dg.base.center.finance.service.mq.keep.SaleRealTimeAccountingConsumer;
import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u793a\u4f8b\u4e2d\u5fc3:\u793a\u4f8b\u63a5\u53e3"})
public class ExampleController
implements IExampleApi {
    @Resource
    private IExampleService service;
    @Resource
    private PushTradeStatusScheduleTask pushTradeStatusScheduleTask;
    @Resource
    private SaleRealTimeAccountingConsumer saleRealTimeAccountingConsumer;
    @Resource
    private DeliveryNoticeAccountingConsumer deliveryNoticeAccountingConsumer;
    @Resource
    private IFianceInsiderTransactionService fianceInsiderTransactionService;

    public RestResponse<ExampleDto> getExample(Long id) {
        return this.service.getExample(id);
    }

    @OptLogEntryMethod
    public RestResponse<Long> insertExample(ExampleDto dto) {
        OptUtil.addOptContent((String)"\u65b0\u589e-\u81ea\u5b9a\u4e49\u7684\u64cd\u4f5c\u5185\u5bb9");
        return this.service.insertExample(dto);
    }

    public RestResponse<PageInfo<ExampleDto>> pageExample(ExamplePageReqDto dto) {
        return this.service.pageExample(dto);
    }

    @OptLogEntryMethod(linkCodeSpel="#dto.getId()", linkCodeType="egName")
    public RestResponse<Integer> updateExample(ExampleDto dto) {
        OptUtil.addOptContent((String)"\u66f4\u65b0-\u81ea\u5b9a\u4e49\u7684\u64cd\u4f5c\u5185\u5bb9");
        return this.service.updateExample(dto);
    }

    public RestResponse<Long> testRpc(Long id) {
        return this.service.testRpc(id);
    }

    @PostMapping(path={"/v1/example/test/mq"})
    @ApiOperation(value="\u6d4b\u8bd5mq\u63a5\u53e3", notes="\u6d4b\u8bd5mq\u63a5\u53e3")
    public RestResponse<Void> testMq(@RequestBody ExamplePageReqDto dto) {
        return this.service.testMq(dto);
    }

    @PostMapping(path={"/v1/example/test/push/trade"})
    @ApiOperation(value="\u6d4b\u8bd5\u63a8\u9001\u4ea4\u6613\u72b6\u6001\u63a5\u53e3", notes="\u6d4b\u8bd5\u63a8\u9001\u4ea4\u6613\u72b6\u6001\u63a5\u53e3")
    public RestResponse<Void> testPushTrade() {
        TaskMsg taskMsg = new TaskMsg();
        this.pushTradeStatusScheduleTask.execute(taskMsg);
        return RestResponse.SUCCESS;
    }

    @PostMapping(path={"/v1/example/test/onTime/finance"})
    @ApiOperation(value="\u6b63\u5411\u5355\u636e-\u6d4b\u8bd5\u5b9e\u65f6\u8bb0\u8d26", notes="\u6b63\u5411\u5355\u636e-\u6d4b\u8bd5\u5b9e\u65f6\u8bb0\u8d26")
    public RestResponse<Void> testPushOnTime(@RequestBody MessageVo message) {
        this.saleRealTimeAccountingConsumer.process(message);
        return RestResponse.SUCCESS;
    }

    @PostMapping(path={"/v1/example/test/onTime/inventory/finance"})
    @ApiOperation(value="\u5e93\u5b58\u56de\u4f20\u5355\u636e-\u6d4b\u8bd5\u5b9e\u65f6\u8bb0\u8d26", notes="\u5e93\u5b58\u56de\u4f20\u5355\u636e-\u6d4b\u8bd5\u5b9e\u65f6\u8bb0\u8d26")
    public RestResponse<Void> testPushInventory(@RequestBody MessageVo message) {
        this.deliveryNoticeAccountingConsumer.process(message);
        return RestResponse.SUCCESS;
    }

    @PostMapping(path={"/v1/example/test/purchasePriceJudgment"})
    @ApiOperation(value="\u67e5\u8be2\u91c7\u8d2d\u4ef7", notes="\u67e5\u8be2\u91c7\u8d2d\u4ef7")
    public RestResponse<Void> purchasePriceJudgment(@RequestBody List<KeepAccountsDetailDto> keepAccountsDetailDtos) {
        List keepAccountsDetailEos = BeanUtil.copyToList(keepAccountsDetailDtos, KeepAccountsDetailEo.class);
        this.fianceInsiderTransactionService.purchasePriceJudgment(keepAccountsDetailEos, null);
        return RestResponse.SUCCESS;
    }
}

