/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IBillApplyDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillApplyMapper;
import com.yunxi.dg.base.center.finance.eo.BillApplyEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillApplyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class AutoReconvertBillApplyTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(AutoReconvertBillApplyTask.class);
    @Resource
    private IBillApplyService billApplyService;
    @Resource
    private IBillApplyDas billApplyDas;
    @Resource
    private BillApplyMapper billApplyMapper;

    public void before(TaskMsg taskMsg) {
        String reqId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)reqId);
        log.info("=========\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u8f6c\u6362\u53d1\u7968\u7533\u8bf7\u5355\u4efb\u52a1==========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        log.info("========>\u81ea\u52a8\u8f6c\u6362\u53d1\u7968\u7533\u8bf7\u5355\u4efb\u52a1\u6267\u884c\u4e2d");
        this.resetApplyPerson();
        try {
            List applyNoList = this.billApplyDas.getApplyNos(null);
            if (CollectionUtils.isNotEmpty((Collection)applyNoList)) {
                log.info("\u8c03\u5ea6\u4efb\u52a1\u91cd\u65b0\u8f6c\u6362\u5355\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)applyNoList));
                this.billApplyService.transformBillApply(applyNoList);
                this.updateApplyReconvertNum(applyNoList);
                this.updateApplyChangeType(applyNoList);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u81ea\u52a8\u8f6c\u6362\u53d1\u7968\u7533\u8bf7\u5355\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)e);
            boolean bl = true;
            return bl;
        }
        finally {
            log.info("\u81ea\u52a8\u8f6c\u6362\u53d1\u7968\u7533\u8bf7\u5355\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            return true;
        }
    }

    public void after(TaskMsg taskMsg) {
        log.info("=========\u7ed3\u675f\u81ea\u52a8\u8f6c\u6362\u53d1\u7968\u7533\u8bf7\u5355\u4efb\u52a1==========");
    }

    private void resetApplyPerson() {
        String oldApplyPerson = ServiceContext.getContext().getRequestUserCode();
        String newApplyPerson = "\u7cfb\u7edf";
        log.info("\u91cd\u8bbe\u53d1\u7968\u7533\u8bf7\u4eba\uff1a{} -> {}", (Object)oldApplyPerson, (Object)newApplyPerson);
        ServiceContext.getContext().setAttachment("yes.req.userCode", newApplyPerson);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateApplyReconvertNum(List<String> applyNos) {
        List<BillApplyEo> billApplyEos = Lists.partition(new ArrayList<String>(applyNos), (int)500).stream().flatMap(v -> {
            List list = this.billApplyMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BillApplyEo.class).in(BillApplyEo::getApplyNo, (Collection)v)).eq(BaseEo::getDr, (Object)0));
            return list.stream();
        }).collect(Collectors.toList());
        billApplyEos.forEach(info -> {
            BillApplyEo billApplyEo = new BillApplyEo();
            billApplyEo.setId(info.getId());
            billApplyEo.setReconvertNum(Integer.valueOf(info.getReconvertNum() + 1));
            this.billApplyDas.updateSelective((BaseEo)billApplyEo);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateApplyChangeType(List<String> applyNos) {
        List partition = Lists.partition(applyNos, (int)1000);
        partition.forEach(list -> {
            List applyEoList = ((ExtQueryChainWrapper)this.billApplyDas.filter().in((Object)"apply_no", (Collection)list)).list();
            if (CollectionUtils.isNotEmpty((Collection)applyEoList)) {
                List idList = applyEoList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
                this.billApplyDas.updateChangeType(idList);
            }
        });
    }
}

