/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class InvoiceAutoAuditTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAutoAuditTask.class);
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IBillInfoService billInfoService;

    public void before(TaskMsg taskMsg) {
        String reqId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)reqId);
        log.info("=========\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u5ba1\u6838\u53d1\u7968\u4efb\u52a1==========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        log.info("========>\u81ea\u52a8\u5ba1\u6838\u53d1\u7968\u4efb\u52a1\u6267\u884c\u4e2d");
        try {
            List billInfoEoList = this.billInfoDas.queryWaitAuditBlueBillList(null);
            if (CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
                List billFlowNoList = billInfoEoList.stream().map(BillInfoEo::getBillFlowNo).distinct().collect(Collectors.toList());
                List partition = Lists.partition(billFlowNoList, (int)1000);
                partition.forEach(list -> this.billInfoService.auditBillInfo(list));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u81ea\u52a8\u5ba1\u6838\u53d1\u7968\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)e);
            boolean bl = true;
            return bl;
        }
        finally {
            log.info("\u81ea\u52a8\u5ba1\u6838\u53d1\u7968\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            return true;
        }
    }

    public void after(TaskMsg taskMsg) {
        log.info("=========\u7ed3\u675f\u6267\u884c\u53d1\u7968\u89c4\u5219\u72b6\u6001\u5237\u65b0\u4efb\u52a1\u4efb\u52a1==========");
    }
}

