/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.MamualKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepAccountRuleFactory;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="returnBaseKeepAccountingTask")
public class ReturnBaseKeepAccountingTask
extends SingleTupleScheduleEvent {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Value(value="${keep.base.mode:AJR}")
    private String keepSystem;
    @Resource
    private IOrderRuleService service;
    @Resource
    private IOrderRuleService orderRuleService;
    @Value(value="${return.task.days.interval:7}")
    private Integer taskDaysInterval;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void before(TaskMsg taskMsg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        if (!this.extractedVaildTime()) {
            return true;
        }
        String reqId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)reqId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        ServiceContext.getContext().setAttachment("yes.req.userCode", "system");
        this.logger.info("========>\u9000\u8d27\u9000\u6b3e\u8bb0\u8d26\u4efb\u52a1\u6267\u884c\u4e2d");
        try {
            MamualKeepAccountReqDto mamualKeepAccountReqDto = new MamualKeepAccountReqDto();
            this.extractedInitParam(mamualKeepAccountReqDto);
            KeepNodeRuleParam keepNodeRuleParam = this.orderRuleService.init(mamualKeepAccountReqDto, mamualKeepAccountReqDto.getVoucherType(), mamualKeepAccountReqDto.getOrderType());
            keepNodeRuleParam.getParamReqDto().setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
            keepNodeRuleParam.setAction(true);
            List keepNodeRules = KeepAccountRuleFactory.getRefundsBaseNodeList((String)VoucherTypeEnum.DELIVERY.getCode(), (String)mamualKeepAccountReqDto.getOrderType(), (String)this.keepSystem);
            keepNodeRules.forEach(rule -> rule.execute(keepNodeRuleParam));
            this.logger.info("========>\u9000\u8d27\u9000\u6b3e\u8bb0\u8d26\u7ed3\u675f");
            keepNodeRuleParam.getParamReqDto().setVoucherType(VoucherTypeEnum.INVOICE.getCode());
            List keepNodeInvoiceRules = KeepAccountRuleFactory.getRefundsBaseNodeList((String)VoucherTypeEnum.INVOICE.getCode(), (String)mamualKeepAccountReqDto.getOrderType(), (String)this.keepSystem);
            keepNodeInvoiceRules.forEach(rule -> rule.execute(keepNodeRuleParam));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("\u9000\u8d27\u9000\u6b3e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.logger.info("\u9000\u8d27\u9000\u6b3e\u8bb0\u8d26\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            return true;
        }
    }

    private void extractedInitParam(MamualKeepAccountReqDto mamualKeepAccountReqDto) {
        mamualKeepAccountReqDto.setType(KeepTypeEnum.AUTO.getCode());
        mamualKeepAccountReqDto.setBillShopType("1");
        LocalDate currentDate = LocalDate.now();
        LocalDate earlierDate = currentDate.minusDays(this.taskDaysInterval.intValue());
        LocalDateTime startTime = LocalDateTime.of(earlierDate, LocalTime.MIN);
        LocalDateTime endTime = LocalDateTime.of(currentDate, LocalTime.MAX);
        String dateString = startTime.format(FORMATTER);
        String format = endTime.format(FORMATTER);
        mamualKeepAccountReqDto.setStartTime(dateString);
        mamualKeepAccountReqDto.setEndTime(format);
    }

    public void after(TaskMsg taskMsg) {
    }

    private boolean extractedVaildTime() {
        Date date = new Date();
        OrderRuleRespDto orderRuleRespDto = this.service.selectOrderRule();
        if (orderRuleRespDto.getAccountType().equals("REAL_TIME")) {
            return false;
        }
        String billTime = orderRuleRespDto.getBillTime();
        LocalTime billLocalTime = LocalTime.parse(billTime);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        boolean hourMatch = localDateTime.getHour() == billLocalTime.getHour();
        boolean minuteMatch = localDateTime.getMinute() == billLocalTime.getMinute();
        boolean isMatch = hourMatch && minuteMatch;
        return isMatch;
    }
}

