/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.AccountingTypeConverter;
import com.yunxi.dg.base.center.finance.dao.das.IAccountingTypeDas;
import com.yunxi.dg.base.center.finance.domain.entity.IAccountingTypeDomain;
import com.yunxi.dg.base.center.finance.dto.entity.AccountingTypeDto;
import com.yunxi.dg.base.center.finance.dto.request.AccountingTypeReqDto;
import com.yunxi.dg.base.center.finance.dto.response.AccountingTypeRespDto;
import com.yunxi.dg.base.center.finance.eo.AccountingTypeEo;
import com.yunxi.dg.base.center.finance.service.entity.IAccountingTypeService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountingTypeServiceImpl
extends BaseServiceImpl<AccountingTypeDto, AccountingTypeEo, IAccountingTypeDomain>
implements IAccountingTypeService {
    @Resource
    private IAccountingTypeDas accountingTypeDas;
    @Resource
    private IAccountingTypeDomain accountingTypeDomain;

    public AccountingTypeServiceImpl(IAccountingTypeDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<AccountingTypeDto, AccountingTypeEo> converter() {
        return AccountingTypeConverter.INSTANCE;
    }

    @Override
    public Long addAccountingType(AccountingTypeReqDto addReqDto) {
        AccountingTypeEo accountingTypeEo = new AccountingTypeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)accountingTypeEo);
        this.accountingTypeDas.insert((BaseEo)accountingTypeEo);
        return accountingTypeEo.getId();
    }

    @Override
    public void modifyAccountingType(AccountingTypeReqDto modifyReqDto) {
        AccountingTypeEo accountingTypeEo = new AccountingTypeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)accountingTypeEo);
        this.accountingTypeDas.updateSelective((BaseEo)accountingTypeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAccountingType(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.accountingTypeDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public AccountingTypeRespDto queryById(Long id) {
        AccountingTypeEo accountingTypeEo = (AccountingTypeEo)this.accountingTypeDas.selectByPrimaryKey(id);
        AccountingTypeRespDto accountingTypeRespDto = new AccountingTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)accountingTypeEo, (BaseVo)accountingTypeRespDto);
        return accountingTypeRespDto;
    }

    @Override
    public PageInfo<AccountingTypeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        AccountingTypeReqDto accountingTypeReqDto = (AccountingTypeReqDto)JSON.parseObject((String)filter, AccountingTypeReqDto.class);
        AccountingTypeEo accountingTypeEo = new AccountingTypeEo();
        DtoHelper.dto2Eo((BaseVo)accountingTypeReqDto, (BaseEo)accountingTypeEo);
        PageInfo eoPageInfo = this.accountingTypeDomain.selectPage((BaseEo)accountingTypeEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AccountingTypeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public AccountingTypeRespDto getAccountingInterface(String chargeAccountName, String vocherType) {
        AccountingTypeEo accountingTypeEo = new AccountingTypeEo();
        accountingTypeEo.setAccountingType(chargeAccountName);
        accountingTypeEo.setVoucherType(vocherType);
        AccountingTypeEo typeEo = (AccountingTypeEo)this.accountingTypeDas.selectOne((BaseEo)accountingTypeEo);
        AccountingTypeRespDto accountingTypeRespDto = new AccountingTypeRespDto();
        CubeBeanUtils.copyProperties((Object)accountingTypeRespDto, (Object)typeEo, (String[])new String[0]);
        return accountingTypeRespDto;
    }
}

