/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.BillItemConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillItemDas;
import com.yunxi.dg.base.center.finance.domain.entity.IBillItemDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillItemDto;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillItemQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillItemReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillItemRespDto;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillItemEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillItemService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillItemServiceImpl
extends BaseServiceImpl<BillItemDto, BillItemEo, IBillItemDomain>
implements IBillItemService {
    private static Logger logger = LoggerFactory.getLogger(BillItemServiceImpl.class);
    @Resource
    private IBillItemDas billItemDas;
    @Resource
    private IBillInfoDas billInfoDas;

    public BillItemServiceImpl(IBillItemDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillItemDto, BillItemEo> converter() {
        return BillItemConverter.INSTANCE;
    }

    @Override
    public Long addBillItem(BillItemReqDto addReqDto) {
        BillItemEo billItemEo = new BillItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billItemEo);
        this.billItemDas.insert((BaseEo)billItemEo);
        return billItemEo.getId();
    }

    @Override
    public void modifyBillItem(BillItemReqDto modifyReqDto) {
        BillItemEo billItemEo = new BillItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billItemEo);
        this.billItemDas.updateSelective((BaseEo)billItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBillItem(List<BillItemReqDto> billItemReqDtoList) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billItemReqDtoList.get(0).getBillFlowNo()), "\u5f00\u7968\u4fe1\u606f\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BillInfoEo billInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)billItemReqDtoList.get(0).getBillFlowNo())).one();
        if (!InvoiceStateEnum.WAIT_AUDIT.getCode().equals(billInfoEo.getInvoiceState()) && !InvoiceStateEnum.FAILED.getCode().equals(billInfoEo.getInvoiceState())) {
            throw new BizException("\u5f00\u7968\u4fe1\u606f\u975e\u5f85\u5ba1\u6838/\u5f00\u7968\u5931\u8d25\u72b6\u6001\u65e0\u6cd5\u4fee\u6539");
        }
        List ids = billItemReqDtoList.stream().map(BillItemReqDto::getId).collect(Collectors.toList());
        List billItemEos = ((ExtQueryChainWrapper)this.billItemDas.filter().in((Object)"id", ids)).list();
        Map itemEoMap = billItemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v2));
        billItemReqDtoList.forEach(item -> {
            if (itemEoMap.containsKey(item.getId())) {
                BillItemEo billItem = (BillItemEo)itemEoMap.get(item.getId());
                BillItemEo billItemEo = new BillItemEo();
                billItemEo.setId(item.getId());
                billItemEo.setBillLineItemName(item.getBillLineItemName());
                billItemEo.setItemName(item.getItemName());
                billItemEo.setSpecification(item.getSpecification());
                billItemEo.setUnit(item.getUnit());
                billItemEo.setTaxClassificationCode(item.getTaxClassificationCode());
                billItemEo.setTaxRate(item.getTaxRate());
                billItemEo.setTaxAmount(billItem.getAmount().divide(item.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(item.getTaxRate()).setScale(2, 4));
                this.billItemDas.updateSelective((BaseEo)billItemEo);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.billItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BillItemRespDto queryById(Long id) {
        BillItemEo billItemEo = (BillItemEo)this.billItemDas.selectByPrimaryKey(id);
        BillItemRespDto billItemRespDto = new BillItemRespDto();
        DtoHelper.eo2Dto((BaseEo)billItemEo, (BaseVo)billItemRespDto);
        return billItemRespDto;
    }

    @Override
    public List<BillItemRespDto> queryItemByBillFlowNo(BillItemQueryDto billItemQueryDto) {
        logger.info("\u6839\u636e\u5f00\u7968\u6d41\u6c34\u53f7\u67e5\u8be2\u5f00\u7968\u5546\u54c1\u4fe1\u606f-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)billItemQueryDto));
        ExtQueryChainWrapper<BillItemEo> param = this.assembleCondition(billItemQueryDto);
        List billItemEoList = param.list();
        ArrayList<BillItemRespDto> billItemRespDtoList = new ArrayList<BillItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)billItemEoList, billItemRespDtoList, BillItemRespDto.class);
        return billItemRespDtoList;
    }

    @Override
    public PageInfo<BillItemRespDto> queryByPage(BillItemQueryDto billItemQueryDto) {
        logger.info("\u5f00\u7968\u5546\u54c1\u4fe1\u606f\u5217\u8868\u67e5\u8be2-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)billItemQueryDto));
        Integer pageNum = billItemQueryDto.getPageNum();
        Integer pageSize = billItemQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        ExtQueryChainWrapper<BillItemEo> param = this.assembleCondition(billItemQueryDto);
        PageInfo eoPageInfo = param.select(new String[0]).page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<BillItemRespDto> queryItemByBillFlowNos(List<String> billFlowNos) {
        if (CollectionUtils.isEmpty(billFlowNos)) {
            return null;
        }
        ExtQueryChainWrapper filter = this.billItemDas.filter();
        filter.in((Object)"bill_flow_no", billFlowNos);
        List eoList = filter.list();
        ArrayList<BillItemRespDto> dtoList = new ArrayList<BillItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, BillItemRespDto.class);
        return dtoList;
    }

    public ExtQueryChainWrapper<BillItemEo> assembleCondition(BillItemQueryDto billItemQueryDto) {
        ExtQueryChainWrapper filter = this.billItemDas.filter();
        if (StringUtils.isNotBlank((CharSequence)billItemQueryDto.getBillFlowNo())) {
            filter.eq((Object)"bill_flow_no", (Object)billItemQueryDto.getBillFlowNo());
        }
        if (StringUtils.isNotBlank((CharSequence)billItemQueryDto.getApplyNo())) {
            filter.eq((Object)"apply_no", (Object)billItemQueryDto.getApplyNo());
        }
        if (StringUtils.isNotBlank((CharSequence)billItemQueryDto.getPlatformOrderNo())) {
            filter.eq((Object)"platform_order_no", (Object)billItemQueryDto.getPlatformOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)billItemQueryDto.getBusinessOrderNo())) {
            filter.eq((Object)"business_order_no", (Object)billItemQueryDto.getPlatformOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)billItemQueryDto.getSaleOrderNo())) {
            filter.eq((Object)"sale_order_no", (Object)billItemQueryDto.getSaleOrderNo());
        }
        filter.orderByDesc((Object)"id");
        return filter;
    }
}

