/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.convert.entity.BillStrategyShopConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyShopDas;
import com.yunxi.dg.base.center.finance.domain.entity.IBillStrategyShopDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillStrategyShopDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyShopQueryReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyShopReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyShopRespDto;
import com.yunxi.dg.base.center.finance.eo.BillStrategyShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyShopService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillStrategyShopServiceImpl
extends BaseServiceImpl<BillStrategyShopDto, BillStrategyShopEo, IBillStrategyShopDomain>
implements IBillStrategyShopService {
    @Resource
    private IBillStrategyShopDas billStrategyShopDas;
    @Resource
    private IBillStrategyShopDomain billStrategyShopDomain;

    public BillStrategyShopServiceImpl(IBillStrategyShopDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillStrategyShopDto, BillStrategyShopEo> converter() {
        return BillStrategyShopConverter.INSTANCE;
    }

    @Override
    public Long addBillStrategyShop(BillStrategyShopReqDto addReqDto) {
        BillStrategyShopEo billStrategyShopEo = new BillStrategyShopEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billStrategyShopEo);
        this.billStrategyShopDas.insert((BaseEo)billStrategyShopEo);
        return billStrategyShopEo.getId();
    }

    @Override
    public void modifyBillStrategyShop(BillStrategyShopReqDto modifyReqDto) {
        BillStrategyShopEo billStrategyShopEo = new BillStrategyShopEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billStrategyShopEo);
        this.billStrategyShopDas.updateSelective((BaseEo)billStrategyShopEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillStrategyShop(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.billStrategyShopDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BillStrategyShopRespDto queryById(Long id) {
        BillStrategyShopEo billStrategyShopEo = (BillStrategyShopEo)this.billStrategyShopDas.selectByPrimaryKey(id);
        BillStrategyShopRespDto billStrategyShopRespDto = new BillStrategyShopRespDto();
        DtoHelper.eo2Dto((BaseEo)billStrategyShopEo, (BaseVo)billStrategyShopRespDto);
        return billStrategyShopRespDto;
    }

    @Override
    public PageInfo<BillStrategyShopRespDto> queryByPage(BillStrategyShopQueryReqDto billStrategyShopReqDto) {
        Integer pageNum = Objects.isNull(billStrategyShopReqDto.getPageNum()) ? 1 : billStrategyShopReqDto.getPageNum();
        Integer pageSize = Objects.isNull(billStrategyShopReqDto.getPageSize()) ? 10 : billStrategyShopReqDto.getPageSize();
        BillStrategyShopEo billStrategyShopEo = new BillStrategyShopEo();
        DtoHelper.dto2Eo((BaseVo)billStrategyShopReqDto, (BaseEo)billStrategyShopEo);
        PageInfo eoPageInfo = this.billStrategyShopDomain.selectPage((BaseEo)billStrategyShopEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillStrategyShopRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<BillStrategyShopRespDto> queryByStrategyId(Long strategyId) {
        List billStrategyShopEos = this.billStrategyShopDas.queryBylist(strategyId);
        ArrayList list = Lists.newArrayList();
        billStrategyShopEos.forEach(eo -> {
            BillStrategyShopRespDto respDto = new BillStrategyShopRespDto();
            respDto.setBillStrategyId(eo.getBillStrategyId());
            respDto.setShopCode(eo.getShopCode());
            respDto.setShopName(eo.getShopName());
            list.add(respDto);
        });
        return list;
    }
}

