/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.finance.convert.entity.GroupKeepAccountsShopConverter;
import com.yunxi.dg.base.center.finance.domain.entity.IGroupKeepAccountsShopDomain;
import com.yunxi.dg.base.center.finance.dto.entity.GroupKeepAccountsShopDto;
import com.yunxi.dg.base.center.finance.eo.GroupKeepAccountsShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IGroupKeepAccountsShopService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupKeepAccountsShopServiceImpl
extends BaseServiceImpl<GroupKeepAccountsShopDto, GroupKeepAccountsShopEo, IGroupKeepAccountsShopDomain>
implements IGroupKeepAccountsShopService {
    private static final Logger log = LoggerFactory.getLogger(GroupKeepAccountsShopServiceImpl.class);

    public GroupKeepAccountsShopServiceImpl(IGroupKeepAccountsShopDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<GroupKeepAccountsShopDto, GroupKeepAccountsShopEo> converter() {
        return GroupKeepAccountsShopConverter.INSTANCE;
    }

    @Override
    public GroupKeepAccountsShopDto getByShopCode(String shopCode) {
        return (GroupKeepAccountsShopDto)this.converter().toDto((BaseEo)((IGroupKeepAccountsShopDomain)this.domain).getByShopCode(shopCode));
    }

    public RestResponse<Long> insert(GroupKeepAccountsShopDto dto) {
        GroupKeepAccountsShopDto dbDto = this.getByShopCode(dto.getShopCode());
        if (dbDto != null) {
            log.info("\u5e97\u94fa\u7f16\u7801 {} \u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0", (Object)dto.getShopCode());
            return new RestResponse((Object)dbDto.getId());
        }
        return super.insert((BaseDto)dto);
    }

    public RestResponse<Integer> insertBatch(List<GroupKeepAccountsShopDto> dtos) {
        Map<String, GroupKeepAccountsShopDto> map = dtos.stream().collect(Collectors.toMap(GroupKeepAccountsShopDto::getShopCode, v -> v, (a, b) -> b));
        List shopEoList = ((IGroupKeepAccountsShopDomain)this.domain).getByShopCodes(map.keySet());
        for (GroupKeepAccountsShopEo shop : shopEoList) {
            if (!map.containsKey(shop.getShopCode())) continue;
            log.info("\u5e97\u94fa\u7f16\u7801 {} \u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0 ", (Object)shop.getShopCode());
            map.remove(shop.getShopCode());
        }
        return super.insertBatch(new ArrayList<GroupKeepAccountsShopDto>(map.values()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceAll(List<GroupKeepAccountsShopDto> dtoList) {
        Map<String, GroupKeepAccountsShopDto> map = dtoList.stream().collect(Collectors.toMap(GroupKeepAccountsShopDto::getShopCode, v -> v, (a, b) -> b));
        List shopEoList = ((IGroupKeepAccountsShopDomain)this.domain).selectAll();
        ArrayList<GroupKeepAccountsShopEo> deleteList = new ArrayList<GroupKeepAccountsShopEo>();
        for (GroupKeepAccountsShopEo shop : shopEoList) {
            if (!map.containsKey(shop.getShopCode())) {
                deleteList.add(shop);
                continue;
            }
            map.remove(shop.getShopCode());
        }
        if (CollectionUtil.isNotEmpty(deleteList)) {
            List ids = deleteList.stream().map(BaseEo::getId).collect(Collectors.toList());
            log.info("\u5220\u9664\u8bb0\u5f55\uff1a {}", ids);
            ((IGroupKeepAccountsShopDomain)this.domain).logicDeleteByIds(ids);
        }
        super.insertBatch(new ArrayList<GroupKeepAccountsShopDto>(map.values()));
    }
}

