/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.LineItemInfoConverter;
import com.yunxi.dg.base.center.finance.dao.das.ILineItemInfoDas;
import com.yunxi.dg.base.center.finance.domain.entity.ILineItemInfoDomain;
import com.yunxi.dg.base.center.finance.dto.entity.LineItemInfoDto;
import com.yunxi.dg.base.center.finance.dto.request.LineItemInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.response.LineItemInfoRespDto;
import com.yunxi.dg.base.center.finance.eo.LineItemInfoEo;
import com.yunxi.dg.base.center.finance.service.entity.ILineItemInfoService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LineItemInfoServiceImpl
extends BaseServiceImpl<LineItemInfoDto, LineItemInfoEo, ILineItemInfoDomain>
implements ILineItemInfoService {
    @Resource
    private ILineItemInfoDas lineItemInfoDas;
    @Resource
    private ILineItemInfoDomain lineItemInfoDomain;

    public LineItemInfoServiceImpl(ILineItemInfoDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LineItemInfoDto, LineItemInfoEo> converter() {
        return LineItemInfoConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addLineItemInfo(LineItemInfoReqDto addReqDto) {
        Optional.ofNullable(addReqDto).orElseThrow(() -> {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        });
        LineItemInfoEo lineItemInfoEo = (LineItemInfoEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.lineItemInfoDas.filter().eq((Object)"company_code", (Object)addReqDto.getCompanyCode())).eq((Object)"line_order_type", (Object)addReqDto.getLineOrderType())).eq((Object)"product_type", (Object)addReqDto.getProductType())).one();
        if (Objects.nonNull(lineItemInfoEo)) {
            throw new BizException("\u5df2\u5b58\u5728\u8be5\u884c\u9879\u76ee\u7c7b\u522b");
        }
        LineItemInfoEo itemInfoEo = new LineItemInfoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemInfoEo);
        this.lineItemInfoDas.insert((BaseEo)itemInfoEo);
        return itemInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyLineItemInfo(LineItemInfoReqDto modifyReqDto) {
        Optional.ofNullable(modifyReqDto).orElseThrow(() -> {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        });
        LineItemInfoEo lineItemInfoEo = (LineItemInfoEo)((ExtQueryChainWrapper)this.lineItemInfoDas.filter().eq((Object)"id", (Object)modifyReqDto.getId())).one();
        if (Objects.isNull(modifyReqDto.getId())) {
            throw new BizException("\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Objects.isNull(lineItemInfoEo)) {
            throw new BizException("\u884c\u9879\u76ee\u7c7b\u522b\u4fe1\u606f\u4e3a\u7a7a");
        }
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)lineItemInfoEo);
        this.lineItemInfoDas.updateSelective((BaseEo)lineItemInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLineItemInfo(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ids.forEach(v -> this.lineItemInfoDas.logicDeleteById(v));
        }
    }

    @Override
    public LineItemInfoRespDto queryById(Long id) {
        LineItemInfoEo lineItemInfoEo = (LineItemInfoEo)this.lineItemInfoDas.selectByPrimaryKey(id);
        LineItemInfoRespDto lineItemInfoRespDto = new LineItemInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)lineItemInfoEo, (BaseVo)lineItemInfoRespDto);
        return lineItemInfoRespDto;
    }

    @Override
    public PageInfo<LineItemInfoRespDto> queryByPage(LineItemInfoReqDto reqDto, Integer pageNum, Integer pageSize) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (Objects.nonNull(reqDto) && Objects.nonNull(reqDto.getCompanyCategory())) {
            sqlFilters.add(SqlFilter.like((String)"company_category", (Object)reqDto.getCompanyCategory()));
        }
        if (Objects.nonNull(reqDto) && Objects.nonNull(reqDto.getCompanyCode())) {
            sqlFilters.add(SqlFilter.like((String)"company_code", (Object)reqDto.getCompanyCode()));
        }
        if (Objects.nonNull(reqDto) && Objects.nonNull(reqDto.getLineOrderType())) {
            sqlFilters.add(SqlFilter.eq((String)"line_order_type", (Object)reqDto.getLineOrderType()));
        }
        if (Objects.nonNull(reqDto) && Objects.nonNull(reqDto.getProductType())) {
            sqlFilters.add(SqlFilter.like((String)"product_type", (Object)reqDto.getProductType()));
        }
        if (Objects.nonNull(reqDto) && Objects.nonNull(reqDto.getLineItemCode())) {
            sqlFilters.add(SqlFilter.like((String)"line_item_code", (Object)reqDto.getLineItemCode()));
        }
        LineItemInfoEo query = new LineItemInfoEo();
        query.setSqlFilters(sqlFilters);
        query.setOrderBy("create_time");
        PageInfo eoPageInfo = this.lineItemInfoDas.selectPage((BaseEo)query);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, LineItemInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Map<String, LineItemInfoEo> getLineItemInfoEoMap(List<String> companyCodes, List<Integer> lineOrderTypes, List<Integer> productTypes) {
        ExtQueryChainWrapper sqlFilters = this.lineItemInfoDas.filter();
        sqlFilters.in((Object)"company_code", companyCodes);
        sqlFilters.in((Object)"line_order_type", lineOrderTypes);
        sqlFilters.in((Object)"product_type", productTypes);
        List lineItemInfoEos = sqlFilters.list();
        if (CollectionUtils.isNotEmpty((Collection)lineItemInfoEos)) {
            return lineItemInfoEos.stream().collect(Collectors.toMap(k -> k.getCompanyCode() + "_" + k.getLineOrderType() + "_" + k.getProductType(), Function.identity()));
        }
        return new HashMap<String, LineItemInfoEo>();
    }
}

