/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.ShopRuleConverter;
import com.yunxi.dg.base.center.finance.dao.das.IShopRuleDas;
import com.yunxi.dg.base.center.finance.domain.entity.IShopRuleDomain;
import com.yunxi.dg.base.center.finance.dto.entity.ShopRuleDto;
import com.yunxi.dg.base.center.finance.dto.request.ShopRuleReqDto;
import com.yunxi.dg.base.center.finance.dto.response.ShopRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.ShopRuleEo;
import com.yunxi.dg.base.center.finance.service.entity.IShopRuleService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShopRuleServiceImpl
extends BaseServiceImpl<ShopRuleDto, ShopRuleEo, IShopRuleDomain>
implements IShopRuleService {
    @Resource
    private IShopRuleDas shopRuleDas;
    @Resource
    private IShopRuleDomain shopRuleDomain;

    public ShopRuleServiceImpl(IShopRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ShopRuleDto, ShopRuleEo> converter() {
        return ShopRuleConverter.INSTANCE;
    }

    @Override
    public Long addShopRule(ShopRuleReqDto addReqDto) {
        ShopRuleEo shopRuleEo = new ShopRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)shopRuleEo);
        this.shopRuleDas.insert((BaseEo)shopRuleEo);
        return shopRuleEo.getId();
    }

    @Override
    public void modifyShopRule(ShopRuleReqDto modifyReqDto) {
        ShopRuleEo shopRuleEo = new ShopRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)shopRuleEo);
        this.shopRuleDas.updateSelective((BaseEo)shopRuleEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeShopRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.shopRuleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ShopRuleRespDto queryById(Long id) {
        ShopRuleEo shopRuleEo = (ShopRuleEo)this.shopRuleDas.selectByPrimaryKey(id);
        ShopRuleRespDto shopRuleRespDto = new ShopRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)shopRuleEo, (BaseVo)shopRuleRespDto);
        return shopRuleRespDto;
    }

    @Override
    public PageInfo<ShopRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ShopRuleReqDto shopRuleReqDto = (ShopRuleReqDto)JSON.parseObject((String)filter, ShopRuleReqDto.class);
        ShopRuleEo shopRuleEo = new ShopRuleEo();
        DtoHelper.dto2Eo((BaseVo)shopRuleReqDto, (BaseEo)shopRuleEo);
        PageInfo eoPageInfo = this.shopRuleDomain.selectPage((BaseEo)shopRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ShopRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ShopRuleRespDto> page(ShopRuleReqDto ruleReqDto, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.shopRuleDas.filter().orderByDesc((Object)"id");
        if (Objects.nonNull(ruleReqDto) && StringUtils.isNotBlank((CharSequence)ruleReqDto.getShopCode())) {
            sqlFilters.like((Object)"shop_code", (Object)ruleReqDto.getShopCode());
        }
        if (Objects.nonNull(ruleReqDto) && StringUtils.isNotBlank((CharSequence)ruleReqDto.getShopName())) {
            sqlFilters.like((Object)"shop_name", (Object)ruleReqDto.getShopName());
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ShopRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

