/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl.rule;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dao.das.impl.HckAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.vo.BookAccountsReqVo;
import com.yunxi.dg.base.center.finance.dao.vo.DeliveryOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.SaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.enums.BillShopTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BookKeepingType;
import com.yunxi.dg.base.center.finance.dto.enums.ConditionTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsOrderStatusEnum;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepNodeCommonService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.center.finance.service.utils.TradeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class HckSaleBillingKeepingNodeRule
implements KeepNodeRule {
    private static final Logger log = LoggerFactory.getLogger(HckSaleBillingKeepingNodeRule.class);
    private String voucherType = "1";
    @Value(value="${keep.base.mode:AJR}")
    private String keepSystem;

    public HckSaleBillingKeepingNodeRule(String keepSystem) {
        this.keepSystem = keepSystem;
    }

    @Override
    public void execute(KeepNodeRuleParam context) {
        long start = System.currentTimeMillis();
        context.setVoucherType("1");
        List<Object> orderItemVoList = Lists.newArrayList();
        BookAccountsReqVo reqVo = new BookAccountsReqVo();
        reqVo.setOrderStatus(Arrays.asList(OmsOrderStatusEnum.COMPLETE.getCode()));
        if (Objects.isNull(context.getParamReqDto().getExecuteCAndBillKeep())) {
            reqVo.setBillShopType(Objects.equals(BillShopTypeEnum.B.getCode(), context.getParamReqDto().getBillShopType()) ? BillShopTypeEnum.B.getCode() : BillShopTypeEnum.C.getCode());
        }
        reqVo.setExecuteCAndBillKeep(context.getParamReqDto().getExecuteCAndBillKeep());
        if (Objects.equals(KeepTypeEnum.AUTO.getCode(), context.getParamReqDto().getType())) {
            reqVo.setStartTime(context.getParamReqDto().getStartDate());
            reqVo.setEndTime(context.getOrderRuleEo().getBillTime());
        } else if (Objects.equals(KeepTypeEnum.REAL.getCode(), context.getParamReqDto().getType())) {
            reqVo.setPlatformNo(context.getParamReqDto().getPlatformNo());
            reqVo.setInnerOrderNos(context.getParamReqDto().getInnerOrderNos());
            reqVo.setRealTimeFlag(Integer.valueOf(BigDecimal.ONE.intValue()));
        } else {
            reqVo.setStartTime(context.getParamReqDto().getStartTime() + " 00:00:00");
            reqVo.setEndTime(context.getParamReqDto().getEndTime() + " 23:59:59");
            reqVo.setWarehouseCode(context.getParamReqDto().getWarehouseCode());
        }
        IKeepNodeCommonService keepNodeCommonService = (IKeepNodeCommonService)SpringBeanUtil.getBean(IKeepNodeCommonService.class);
        context.getParamReqDto().setVoucherType(this.voucherType);
        log.info("\u9500\u552e\u5355\u5f00\u7968\u5165\u5e93\u521d\u59cb\u5316\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context));
        orderItemVoList = keepNodeCommonService.matcherCustomerItemWarehouseInfo(context, reqVo);
        log.info("\u6b63\u5411\u5355\u636e-\u5f00\u7968-\u67e5\u8be2\u5230\u7684\u5355\u636e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)orderItemVoList));
        if (CollectionUtils.isNotEmpty((Collection)orderItemVoList)) {
            keepNodeCommonService.summaryGroupingKeepNode(context, (List<SaleOrderItemVo>)orderItemVoList);
        }
        log.info("\u6b63\u5411\u5355\u636e-\u5f00\u7968-\u6c47\u603b-\u67e5\u8be2\u5230\u7684\u5355\u636e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)orderItemVoList));
        if (CollectionUtils.isEmpty((Collection)orderItemVoList)) {
            return;
        }
        keepNodeCommonService.insertPushKeepAccountAndDetail((List<SaleOrderItemVo>)orderItemVoList, context);
        List<String> chargCodes = orderItemVoList.stream().map(SaleOrderItemVo::getChargeCode).distinct().collect(Collectors.toList());
        IKeepNodeCommonService iKeepNodeCommonService = (IKeepNodeCommonService)SpringBeanUtil.getBean(IKeepNodeCommonService.class);
        iKeepNodeCommonService.sendPushKeepAccountMessage(chargCodes);
    }

    private Map<String, Object> vaildatekeep(List<SaleOrderItemVo> orderItemVoList, KeepNodeRuleParam context) {
        HashMap keepAccountingMap = Maps.newHashMap();
        HashMap batchNoCache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orderItemVoList)) {
            ArrayList accountsDetailEos = Lists.newArrayList();
            HashSet exceptionDetailEos = new HashSet();
            List platformOrderNos = orderItemVoList.stream().map(SaleOrderItemVo::getPlatformOrderNo).collect(Collectors.toList());
            Map<Object, Object> deliveryOrderItemVoMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(platformOrderNos)) {
                HckAccountsDetailDas hckAccountsDetailDas = (HckAccountsDetailDas)SpringBeanUtil.getBean(HckAccountsDetailDas.class);
                List deliveryOrderItemVos = hckAccountsDetailDas.queryDeliveryKeepByPlatformNos(platformOrderNos);
                deliveryOrderItemVoMap = deliveryOrderItemVos.stream().collect(Collectors.toMap(DeliveryOrderItemVo::getPlatformNo, Function.identity(), (k1, k2) -> k2));
            }
            HashMap finalDeliveryOrderItemVoMap = deliveryOrderItemVoMap;
            orderItemVoList.forEach(v -> {
                DeliveryOrderItemVo orderItemVo;
                if (null != v.getExistDelivered() && v.getExistDelivered() > 0) {
                    log.error("\u5e73\u53f0\u8ba2\u5355\uff1a" + v.getPlatformOrderNo() + "  \u5bf9\u5e94\u5b58\u5728\u672a\u5b8c\u6210\u7684\u914d\u8d27\u8ba2\u5355");
                    String extension = "\u8ba2\u5355\uff1a" + v.getOrderNo() + " \u5546\u54c1\uff1a" + v.getItemCode() + " \u5bf9\u5e94\u5b58\u5728\u672a\u5b8c\u6210\u7684\u914d\u8d27\u8ba2\u5355";
                    exceptionDetailEos.add(this.setKeepException(v.getOrderNo(), v.getItemCode(), extension));
                    return;
                }
                if (finalDeliveryOrderItemVoMap.containsKey(v.getPlatformNo()) && Objects.nonNull(orderItemVo = (DeliveryOrderItemVo)finalDeliveryOrderItemVoMap.get(v.getPlatformNo())) && orderItemVo.getCountKeeping() > 1) {
                    log.error("\u5e73\u53f0\u8ba2\u5355\uff1a" + v.getPlatformOrderNo() + "  \u5bf9\u5e94\u5b58\u5728\u672a\u5b8c\u6210\u7684\u914d\u8d27\u8ba2\u5355");
                    String extension = "\u8ba2\u5355\uff1a" + v.getOrderNo() + " \u5546\u54c1\uff1a" + v.getItemCode() + " \u5bf9\u5e94\u5b58\u5728\u672a\u5b8c\u6210\u7684\u914d\u8d27\u8ba2\u5355";
                    exceptionDetailEos.add(this.setKeepException(v.getOrderNo(), v.getItemCode(), extension));
                    return;
                }
                String batch = (String)batchNoCache.get(v.getPlatformOrderNo());
                if (StringUtils.isBlank((CharSequence)batch)) {
                    String batchNo = TradeUtil.generateTradeNo();
                    v.setBatchNo(batchNo);
                    batchNoCache.put(v.getPlatformOrderNo(), batchNo);
                } else {
                    v.setBatchNo(batch);
                }
                KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
                IKeepNodeCommonService keepNodeCommonService = (IKeepNodeCommonService)SpringBeanUtil.getBean(IKeepNodeCommonService.class);
                keepNodeCommonService.initKeepAccountsDetail(keepAccountsDetailEo, (SaleOrderItemVo)v);
                accountsDetailEos.add(keepAccountsDetailEo);
            });
            keepAccountingMap.put("keepDetails", accountsDetailEos);
            keepAccountingMap.put("exceptionDetails", exceptionDetailEos);
        }
        return keepAccountingMap;
    }

    public void handler(List<KeepAccountsDetailEo> keepAccountsDetailEos, String startTime, String endTime, String orderType) {
        long start = System.currentTimeMillis();
        IBookKeepAccountService iBookKeepAccountService = (IBookKeepAccountService)SpringBeanUtil.getBean(IBookKeepAccountService.class);
        if (CollectionUtils.isNotEmpty(keepAccountsDetailEos)) {
            iBookKeepAccountService.partialDealKeepAccountDetails(keepAccountsDetailEos, orderType);
            log.info("\u4fdd\u5b58\u8bb0\u8d26\u660e\u7ec6\u8017\u65f6\uff1a{}~{}\uff0c{}", new Object[]{startTime, endTime, System.currentTimeMillis() - start});
        }
    }

    public void handlerException(List<KeepExceptionDetailEo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            IBookKeepAccountService iBookKeepAccountService = (IBookKeepAccountService)SpringBeanUtil.getBean(IBookKeepAccountService.class);
            iBookKeepAccountService.batchInsertKeepExceptionDetail(list);
        }
    }

    public void initKeepAccountsDetail(KeepAccountsDetailEo keepAccountsDetailEo, SaleOrderItemVo v) {
        keepAccountsDetailEo.setChargeCode(v.getChargeCode());
        keepAccountsDetailEo.setBatchNo(v.getBatchNo());
        keepAccountsDetailEo.setOrderNo(v.getOrderNo());
        keepAccountsDetailEo.setCustomerId(v.getCustomerId());
        keepAccountsDetailEo.setCustomerCode(v.getCustomerCode());
        keepAccountsDetailEo.setCustomerName(v.getCustomerName());
        keepAccountsDetailEo.setSapCode(v.getSapCode());
        keepAccountsDetailEo.setItemCode(v.getItemCode());
        keepAccountsDetailEo.setWarehouseCode(v.getWarehouseCode());
        keepAccountsDetailEo.setOutWarehouseCode(v.getWarehouseCode());
        keepAccountsDetailEo.setItemNum(v.getItemNum());
        keepAccountsDetailEo.setItemPrice(v.getItemPrice());
        keepAccountsDetailEo.setBookKeeping(BookKeepingType.NOT_DEAL.getCode());
        keepAccountsDetailEo.setOrderInterface(v.getOrderInterface());
        keepAccountsDetailEo.setBillingInterface(v.getBillingInterface());
        keepAccountsDetailEo.setItemType(Convert.toStr((Object)v.getItemType()));
        keepAccountsDetailEo.setOrderType(v.getOrderType());
        keepAccountsDetailEo.setOrderId(v.getOrderId());
        keepAccountsDetailEo.setConditionType(v.getConditionType());
        keepAccountsDetailEo.setVoucherType(v.getVoucherType());
        keepAccountsDetailEo.setDeliveryConfirmTime(v.getDeliveryCompleteDate());
        keepAccountsDetailEo.setItemName(v.getItemName());
        keepAccountsDetailEo.setSiteCode(v.getSiteCode());
        keepAccountsDetailEo.setSiteName(v.getSiteName());
        keepAccountsDetailEo.setOrderItemId(v.getOrderItemId());
        keepAccountsDetailEo.setInvoice(v.getInvoice());
        keepAccountsDetailEo.setShopCode(v.getShopCode());
        keepAccountsDetailEo.setShopName(v.getShopName());
        keepAccountsDetailEo.setShopId(v.getShopId());
        keepAccountsDetailEo.setSingle(v.getSingle());
        keepAccountsDetailEo.setProductType(v.getProductType());
        keepAccountsDetailEo.setLineOrderType(v.getLineOrderType());
        keepAccountsDetailEo.setPlaceTime(v.getPlaceTime());
        keepAccountsDetailEo.setPlatformNo(v.getPlatformOrderNo());
        keepAccountsDetailEo.setPlatformOrderNo(v.getPlatformOrderNo());
        keepAccountsDetailEo.setDocumentNo(v.getDocumentNo());
        keepAccountsDetailEo.setDocumentId(v.getDocumentId());
        keepAccountsDetailEo.setOrderStatus(v.getOrderStatus());
        keepAccountsDetailEo.setCompleteTime(v.getConfirmReceiveTime());
        keepAccountsDetailEo.setDeliveryTime(v.getDeliveryCompleteDate());
        keepAccountsDetailEo.setItemId(v.getItemId());
        keepAccountsDetailEo.setGeneratePerson(v.getGeneratePerson());
        keepAccountsDetailEo.setPlatformCreateTime(v.getPlatformCreateTime());
        keepAccountsDetailEo.setSaleOrderType(v.getSaleOrderType());
        keepAccountsDetailEo.setGroupSkuCode(v.getGroupSkuCode());
        keepAccountsDetailEo.setGroupItemName(v.getGroupItemName());
        keepAccountsDetailEo.setGroupItemId(v.getGroupItemId());
        keepAccountsDetailEo.setRealTimeFlag(v.getRealTimeFlag());
        keepAccountsDetailEo.setOrganizationCode(v.getOrganizationCode());
        keepAccountsDetailEo.setOrganizationName(v.getOrganizationName());
        keepAccountsDetailEo.setErpOrderType(v.getErpOrderType());
        keepAccountsDetailEo.setErpOutOrderType(v.getErpOutOrderType());
        keepAccountsDetailEo.setRemark(v.getRemark());
        keepAccountsDetailEo.setSellerRemark(v.getSellerRemark());
        keepAccountsDetailEo.setBuyerRemark(v.getBuyerRemark());
        keepAccountsDetailEo.setShippingNo(v.getShippingNo());
        keepAccountsDetailEo.setShopOrganizationCode(v.getShopOrganizationCode());
        keepAccountsDetailEo.setShopOrganizationName(v.getShopOrganizationName());
        keepAccountsDetailEo.setWarehouseType(v.getWarehouseType());
        keepAccountsDetailEo.setDeliveryWay(v.getDeliveryWay());
        keepAccountsDetailEo.setWarehouseProperty(v.getWarehouseProperty());
        keepAccountsDetailEo.setOutResultCreateTime(v.getOutResultCreateTime());
        keepAccountsDetailEo.setPreOrderNo(v.getPreOrderNo());
        keepAccountsDetailEo.setDeliveryNote(v.getDeliveryNote());
        keepAccountsDetailEo.setSaleNo(v.getSaleNo());
        keepAccountsDetailEo.setChargeAccountName(v.getChargeAccountName());
        keepAccountsDetailEo.setBillAccountName(v.getBillAccountName());
        keepAccountsDetailEo.setSupplierCode(v.getSupplierCode());
        keepAccountsDetailEo.setPlatformCompleteTime(v.getPlatformCompleteTime());
        keepAccountsDetailEo.setPlatformOrderId(v.getPlatformOrderId());
        keepAccountsDetailEo.setPlatformOrderItemNo(v.getPlatformOrderItemNo());
        keepAccountsDetailEo.setPlatformItemName(v.getPlatformItemName());
        keepAccountsDetailEo.setPlatformItemCode(v.getPlatformItemCode());
        keepAccountsDetailEo.setPlatformItemSkuCode(v.getPlatformItemSkuCode());
    }

    private KeepExceptionDetailEo setKeepException(String saleOrderNo, String itemCode, String extension) {
        KeepExceptionDetailEo exceptionDetailEo = new KeepExceptionDetailEo();
        exceptionDetailEo.setOrderNo(saleOrderNo);
        exceptionDetailEo.setConditionType(ConditionTypeEnum.SALE_CREATE_BILLING.getCode());
        exceptionDetailEo.setOrderType(BillTypeEnum.SALE_LIST.getCode());
        exceptionDetailEo.setItemCode(itemCode);
        exceptionDetailEo.setExtension(extension);
        return exceptionDetailEo;
    }
}

