/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.mq;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.finance.dto.request.ReissueBillDto;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.mq.IWhDgMessageProcessor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="REISSUE_BILL")
public class ReissueBillConsumer
implements IWhDgMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(ReissueBillConsumer.class);
    @Resource
    private IBillInfoService billInfoService;

    public MessageResponse process(MessageVo message) {
        log.info("\u9884\u89c8\u5e76\u91cd\u5f00\u53d1\u7968\uff1a\u6536\u5230\u91cd\u5f00\u53d1\u7968\u7684\u6d88\u606f\uff1a{}", JSON.toJSON((Object)message));
        try {
            ReissueBillDto dto = (ReissueBillDto)JSON.parseObject((String)message.getData().toString(), ReissueBillDto.class);
            if (dto == null || StrUtil.isBlank((CharSequence)dto.getPlatformOrderNo())) {
                log.info("\u9884\u89c8\u5e76\u91cd\u5f00\u53d1\u7968\uff1adto\u4e3a\u7a7a\u6216\u5e73\u53f0\u5355\u53f7\u4e3a\u7a7a");
                return MessageResponse.SUCCESS;
            }
            String newApplyPerson = dto.getApplyPerson();
            if (StrUtil.isNotBlank((CharSequence)newApplyPerson)) {
                String oldApplyPerson = ServiceContext.getContext().getRequestUserCode();
                log.info("\u91cd\u8bbe\u53d1\u7968\u7533\u8bf7\u4eba\uff1a{} -> {}", (Object)oldApplyPerson, (Object)newApplyPerson);
                ServiceContext.getContext().setAttachment("yes.req.userCode", newApplyPerson);
            }
            this.billInfoService.reissue(dto.getPlatformOrderNo());
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.error("\u9884\u89c8\u5e76\u91cd\u5f00\u53d1\u7968\uff1a\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

