/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.utils;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.DateUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class GenerateCodeDataUtils {
    @Resource
    private ICacheService cacheService;

    private static String getDatePrefix(LocalDateTime now, String format) {
        return now.format(DateTimeFormatter.ofPattern(format));
    }

    private long generate(String key, Date expireTime) {
        boolean exists = this.cacheService.exists(key);
        if (exists) {
            return this.cacheService.incr(key);
        }
        int expireSecond = DateUtil.getDifferMinute((Date)new Date(), (Date)expireTime) * 60;
        return this.cacheService.incr(key, (long)expireSecond);
    }

    private Date getExpireAtTime(LocalDateTime now) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = now.plusDays(1L);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public String generateNo(String prefix) {
        LocalDateTime now = LocalDateTime.now();
        String datePrefix = GenerateCodeDataUtils.getDatePrefix(now, "yyyyMMddHHmmss");
        String code = prefix + datePrefix + String.format("%1$03d", this.generate(datePrefix, this.getExpireAtTime(now)));
        return code;
    }
}

